/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.Vector;
import mc.alk.arena.BattleArena;
import mc.alk.arena.util.Log;

public class FileLogger {
    static final String version = "1.0.3";
    static Vector<String> msgs = new Vector();
    public static Integer count = 0;
    public static final Integer saveEvery = 100;
    public static final Integer saveTime = 60000;
    public static final Integer maxFileSize = 300000;
    public static final Integer reduceToSize = 100000;
    static long lastSave = 0L;

    public static synchronized void init() {
        File f = new File(BattleArena.getSelf().getDataFolder() + "/saves/log.txt");
        try {
            int lineCount = FileLogger.count(f.getAbsolutePath());
            if (lineCount > maxFileSize) {
                FileLogger.trimFile(f, lineCount);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static synchronized int log(String msg) {
        block6: {
            block5: {
                block4: {
                    try {
                        GregorianCalendar cal = new GregorianCalendar();
                        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd,hh:mm:ss");
                        msgs.add(sdf.format(cal.getTime()) + "," + msg + "\n");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (saveEvery == null) break block4;
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                    if (n % saveEvery == 0) break block5;
                }
                if (System.currentTimeMillis() - lastSave <= (long)saveTime.intValue()) break block6;
            }
            FileLogger.saveAll();
            lastSave = System.currentTimeMillis();
        }
        return -1;
    }

    public static synchronized int log(String node, Object ... varArgs) {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd,hh:mm:ss");
            StringBuilder buf = new StringBuilder();
            Formatter form = new Formatter(buf);
            form.format(node, varArgs);
            msgs.add(sdf.format(cal.getTime()) + "," + buf.toString() + "\n");
            form.close();
            return msgs.size();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (saveEvery != null) {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                if (n % saveEvery == 0) {
                    FileLogger.saveAll();
                }
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void saveAll() {
        BufferedWriter out = null;
        try {
            File f = new File(BattleArena.getSelf().getDataFolder() + "/saves/log.txt");
            out = new BufferedWriter(new FileWriter(f, true));
            for (String msg : msgs) {
                out.write(msg);
            }
            msgs.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File trimFile(File f, int lineCount) {
        File f2 = new File(BattleArena.getSelf().getDataFolder() + "/log2.txt");
        BufferedWriter out = null;
        BufferedReader br = null;
        try {
            String line;
            out = new BufferedWriter(new FileWriter(f2, true));
            br = new BufferedReader(new FileReader(f));
            int count = 0;
            while (count < maxFileSize - lineCount) {
                br.readLine();
            }
            while ((line = br.readLine()) != null) {
                out.write(line + "\n");
            }
            if (!f2.renameTo(f)) {
                Log.info("Couldn't rename file " + f.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {}
            }
        }
        return f2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int count(String filename) throws IOException {
        File f = new File(filename);
        if (!f.exists()) {
            return 0;
        }
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(filename));
        try {
            int readChars;
            byte[] c = new byte[1024];
            int count = 0;
            while ((readChars = ((InputStream)is).read(c)) != -1) {
                for (int i = 0; i < readChars; ++i) {
                    if (c[i] != 10) continue;
                    ++count;
                }
            }
            int n = count;
            return n;
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (Exception e) {}
        }
    }
}

