/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import mc.alk.arena.BattleArena;
import mc.alk.arena.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static InputStream getInputStream(Class<?> clazz, File file) {
        String path;
        InputStream inputStream = null;
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                Log.printStackTrace(e);
            }
        }
        if ((inputStream = clazz.getResourceAsStream(path = file.getPath())) == null) {
            inputStream = clazz.getClassLoader().getResourceAsStream(path);
        }
        return inputStream;
    }

    public static InputStream getInputStream(Class<?> clazz, File defaultFile, File defaultPluginFile) {
        InputStream inputStream = null;
        if (defaultPluginFile.exists()) {
            try {
                inputStream = new FileInputStream(defaultPluginFile);
            }
            catch (FileNotFoundException e) {
                Log.printStackTrace(e);
            }
        }
        if (inputStream == null) {
            inputStream = clazz.getResourceAsStream(defaultPluginFile.getPath());
        }
        if (inputStream == null) {
            inputStream = clazz.getClassLoader().getResourceAsStream(defaultPluginFile.getPath());
        }
        if (inputStream == null) {
            inputStream = ((Object)((Object)BattleArena.getSelf())).getClass().getResourceAsStream(defaultFile.getPath());
        }
        if (inputStream == null) {
            inputStream = ((Object)((Object)BattleArena.getSelf())).getClass().getClassLoader().getResourceAsStream(defaultFile.getPath());
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasResource(Class<?> clazz, String default_file) {
        InputStream inputStream = null;
        try {
            inputStream = clazz.getResourceAsStream(default_file);
            if (inputStream == null) {
                inputStream = clazz.getClassLoader().getResourceAsStream(default_file);
            }
            boolean bl = inputStream != null;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File load(Class<?> clazz, String config_file, String default_file) {
        File file = new File(config_file);
        if (!file.exists()) {
            InputStream inputStream = null;
            OutputStream out = null;
            try {
                int len;
                inputStream = clazz.getResourceAsStream(default_file);
                if (inputStream == null) {
                    inputStream = clazz.getClassLoader().getResourceAsStream(default_file);
                }
                out = new FileOutputStream(config_file);
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return file;
    }
}

