/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mc.alk.arena.Defaults;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.compat.IInventoryHelper;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InventoryUtil {
    static final String version = "BA InventoryUtil 2.1.7";
    static final boolean DEBUG = false;
    static IInventoryHelper handler;
    static final Map<Material, Armor> armor;
    private static final Pattern PATTERN_LORE;
    private static final Pattern PATTERN_OWNER;
    private static final Pattern PATTERN_DISPLAY_NAME;
    private static final Pattern PATTERN_COLOR;
    private static final Pattern PATTERN_POSITION;

    public static Enchantment getEnchantmentByCommonName(String iname) {
        if ((iname = iname.toLowerCase()).contains("smite")) {
            return Enchantment.DAMAGE_UNDEAD;
        }
        if (iname.contains("sharp")) {
            return Enchantment.DAMAGE_ALL;
        }
        if (iname.contains("sharp")) {
            return Enchantment.DAMAGE_ARTHROPODS;
        }
        if (iname.contains("fire") && iname.contains("prot")) {
            return Enchantment.PROTECTION_FIRE;
        }
        if (iname.contains("fire")) {
            return Enchantment.FIRE_ASPECT;
        }
        if (iname.contains("exp") && iname.contains("prot")) {
            return Enchantment.PROTECTION_EXPLOSIONS;
        }
        if (iname.contains("blast") && iname.contains("prot")) {
            return Enchantment.PROTECTION_EXPLOSIONS;
        }
        if (iname.contains("arrow") && iname.contains("prot")) {
            return Enchantment.PROTECTION_PROJECTILE;
        }
        if (iname.contains("proj") && iname.contains("prot")) {
            return Enchantment.PROTECTION_PROJECTILE;
        }
        if (iname.contains("respiration")) {
            return Enchantment.OXYGEN;
        }
        if (iname.contains("fall")) {
            return Enchantment.PROTECTION_FALL;
        }
        if (iname.contains("prot")) {
            return Enchantment.PROTECTION_ENVIRONMENTAL;
        }
        if (iname.contains("respiration")) {
            return Enchantment.OXYGEN;
        }
        if (iname.contains("oxygen")) {
            return Enchantment.OXYGEN;
        }
        if (iname.contains("aqua")) {
            return Enchantment.WATER_WORKER;
        }
        if (iname.contains("arth")) {
            return Enchantment.DAMAGE_ARTHROPODS;
        }
        if (iname.contains("knockback")) {
            return Enchantment.KNOCKBACK;
        }
        if (iname.contains("loot")) {
            return Enchantment.LOOT_BONUS_MOBS;
        }
        if (iname.contains("lootmobs")) {
            return Enchantment.LOOT_BONUS_MOBS;
        }
        if (iname.contains("fortune")) {
            return Enchantment.LOOT_BONUS_BLOCKS;
        }
        if (iname.contains("lootblocks")) {
            return Enchantment.LOOT_BONUS_BLOCKS;
        }
        if (iname.contains("dig")) {
            return Enchantment.DIG_SPEED;
        }
        if (iname.contains("eff")) {
            return Enchantment.DIG_SPEED;
        }
        if (iname.contains("silk")) {
            return Enchantment.SILK_TOUCH;
        }
        if (iname.contains("flame")) {
            return Enchantment.ARROW_FIRE;
        }
        if (iname.contains("power")) {
            return Enchantment.ARROW_DAMAGE;
        }
        if (iname.contains("punch")) {
            return Enchantment.ARROW_KNOCKBACK;
        }
        if (iname.contains("inf")) {
            return Enchantment.ARROW_INFINITE;
        }
        if (iname.contains("unbreaking")) {
            return Enchantment.DURABILITY;
        }
        if (iname.contains("dura")) {
            return Enchantment.DURABILITY;
        }
        return handler.getEnchantmentByCommonName(iname);
    }

    public static String getCommonNameByEnchantment(Enchantment enc) {
        if (enc.getId() == Enchantment.PROTECTION_ENVIRONMENTAL.getId()) {
            return "Protection";
        }
        if (enc.getId() == Enchantment.PROTECTION_FIRE.getId()) {
            return "Fire Protection";
        }
        if (enc.getId() == Enchantment.PROTECTION_FALL.getId()) {
            return "Fall Protection";
        }
        if (enc.getId() == Enchantment.PROTECTION_EXPLOSIONS.getId()) {
            return "Blast Protection";
        }
        if (enc.getId() == Enchantment.PROTECTION_PROJECTILE.getId()) {
            return "Projectile Protection";
        }
        if (enc.getId() == Enchantment.OXYGEN.getId()) {
            return "Respiration";
        }
        if (enc.getId() == Enchantment.WATER_WORKER.getId()) {
            return "Aqua Affinity";
        }
        if (enc.getId() == Enchantment.DAMAGE_ALL.getId()) {
            return "Sharp";
        }
        if (enc.getId() == Enchantment.DAMAGE_UNDEAD.getId()) {
            return "Smite";
        }
        if (enc.getId() == Enchantment.DAMAGE_ARTHROPODS.getId()) {
            return "Bane of Arthropods";
        }
        if (enc.getId() == Enchantment.KNOCKBACK.getId()) {
            return "Knockback";
        }
        if (enc.getId() == Enchantment.FIRE_ASPECT.getId()) {
            return "Fire Aspect";
        }
        if (enc.getId() == Enchantment.LOOT_BONUS_MOBS.getId()) {
            return "Looting";
        }
        if (enc.getId() == Enchantment.DIG_SPEED.getId()) {
            return "Efficiency";
        }
        if (enc.getId() == Enchantment.SILK_TOUCH.getId()) {
            return "Silk Touch";
        }
        if (enc.getId() == Enchantment.DURABILITY.getId()) {
            return "Unbreaking";
        }
        if (enc.getId() == Enchantment.LOOT_BONUS_BLOCKS.getId()) {
            return "Fortune";
        }
        if (enc.getId() == Enchantment.ARROW_DAMAGE.getId()) {
            return "Power";
        }
        if (enc.getId() == Enchantment.ARROW_KNOCKBACK.getId()) {
            return "Punch";
        }
        if (enc.getId() == Enchantment.ARROW_FIRE.getId()) {
            return "Flame";
        }
        if (enc.getId() == Enchantment.ARROW_INFINITE.getId()) {
            return "Infinity";
        }
        return handler.getCommonNameByEnchantment(enc);
    }

    public static int arrowCount(Player p) {
        return InventoryUtil.getItemAmount(p.getInventory().getContents(), new ItemStack(Material.ARROW, 1));
    }

    public static boolean isEnderChest(InventoryType type) {
        return handler.isEnderChest(type);
    }

    public static int getItemAmountFromInventory(Inventory inv, ItemStack is) {
        return InventoryUtil.getItemAmount(inv.getContents(), is);
    }

    public static boolean isArmor(ItemStack is) {
        return armor.get(is.getType()) != null;
    }

    public static boolean isRealArmor(ItemStack is) {
        return armor.get(is.getType()) != null && is.getType() != Material.WOOL;
    }

    public static boolean hasArmor(Player p) {
        PlayerInventory pi = p.getInventory();
        return pi.getBoots() != null && pi.getBoots().getType() != Material.AIR && pi.getHelmet() != null && pi.getBoots().getType() != Material.AIR && pi.getLeggings() != null && pi.getBoots().getType() != Material.AIR && pi.getChestplate() != null && pi.getBoots().getType() != Material.AIR;
    }

    public static ArmorLevel hasArmorSet(List<ItemStack> inv) {
        ArmorLevel[] armorSet = new ArmorLevel[4];
        for (ItemStack is : inv) {
            Armor a = armor.get(is.getType());
            if (a == null) continue;
            switch (a.type) {
                case BOOTS: {
                    armorSet[0] = a.level;
                    break;
                }
                case LEGGINGS: {
                    armorSet[1] = a.level;
                    break;
                }
                case CHEST: {
                    armorSet[2] = a.level;
                    break;
                }
                case HELM: {
                    armorSet[3] = a.level;
                }
            }
        }
        ArmorLevel lvl = null;
        for (ArmorLevel a : armorSet) {
            if (lvl == null) {
                lvl = a;
                continue;
            }
            if (lvl == a) continue;
            return null;
        }
        return lvl;
    }

    public static int getItemAmount(ItemStack[] items, ItemStack is) {
        int count = 0;
        for (ItemStack item : items) {
            if (item == null || item.getType() != is.getType() || item.getDurability() != is.getDurability() && item.getDurability() != -1) continue;
            count += item.getAmount();
        }
        return count;
    }

    public static ItemStack getItemStack(String itemStr) {
        Material mat;
        if (itemStr == null || itemStr.isEmpty()) {
            return null;
        }
        itemStr = itemStr.replace(" ", "_");
        itemStr = itemStr.replace(";", ":");
        itemStr = itemStr.toLowerCase();
        String[] split = itemStr.split(":");
        short dataValue = 0;
        if (split.length > 1 && InventoryUtil.isInt(split[1])) {
            int i = Integer.valueOf(split[1]);
            dataValue = (short)i;
            itemStr = split[0];
        }
        if ((mat = Material.matchMaterial((String)itemStr)) != null && mat != Material.AIR) {
            return new ItemStack(mat.getId(), 1, dataValue);
        }
        if (itemStr.equalsIgnoreCase("steak")) {
            return new ItemStack(Material.COOKED_BEEF, 1);
        }
        if (itemStr.equalsIgnoreCase("chicken")) {
            return new ItemStack(Material.COOKED_CHICKEN, 1);
        }
        itemStr = itemStr.toUpperCase();
        for (Material m : Material.values()) {
            String itemName = m.name();
            int index = itemName.indexOf(itemStr, 0);
            if (index == -1 || index != 0) continue;
            return new ItemStack(m.getId(), 1, dataValue);
        }
        return null;
    }

    public static boolean isInt(String i) {
        try {
            Integer.parseInt(i);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFloat(String i) {
        try {
            Float.parseFloat(i);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Material getMat(String name) {
        Integer id = null;
        try {
            id = Integer.parseInt(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id == null) {
            id = InventoryUtil.getMaterialID(name);
        }
        return id != -1 && id >= 0 ? Material.getMaterial((int)id) : null;
    }

    public static int getMaterialID(String name) {
        Material mat = Material.getMaterial((String)(name = name.toUpperCase()));
        if (mat != null) {
            return mat.getId();
        }
        int temp = Integer.MAX_VALUE;
        mat = null;
        name = name.replaceAll("\\s+", "").replaceAll("_", "");
        for (Material m : Material.values()) {
            if (!m.name().replaceAll("_", "").startsWith(name) || m.name().length() >= temp) continue;
            mat = m;
            temp = m.name().length();
        }
        return mat != null ? mat.getId() : -1;
    }

    public static boolean hasItem(Player p, ItemStack item) {
        PlayerInventory inv = p.getInventory();
        for (ItemStack is : inv.getContents()) {
            if (is == null || is.getType() != item.getType()) continue;
            return true;
        }
        for (ItemStack is : inv.getArmorContents()) {
            if (is == null || is.getType() != item.getType()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAllItems(Player p, List<ItemStack> items) {
        for (ItemStack is : items) {
            if (InventoryUtil.hasItem(p, is)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAnyItem(Player p) {
        PlayerInventory inv = p.getInventory();
        for (ItemStack is : inv.getContents()) {
            if (is == null || is.getType() == Material.AIR) continue;
            return true;
        }
        for (ItemStack is : inv.getArmorContents()) {
            if (is == null || is.getType() == Material.AIR) continue;
            return true;
        }
        return false;
    }

    public static void addItemToInventory(Player player, ItemStack itemStack) {
        InventoryUtil.addItemToInventory(player, itemStack, itemStack.getAmount(), true, false, null);
    }

    public static void addItemToInventory(Player player, ItemStack itemStack, int stockAmount, boolean update) {
        InventoryUtil.addItemToInventory(player, itemStack, stockAmount, update, false, null);
    }

    public static void addItemsToInventory(Player p, List<ItemStack> items, boolean ignoreCustomHelmet) {
        InventoryUtil.addItemsToInventory(p, items, ignoreCustomHelmet, null);
    }

    public static void addItemsToInventory(Player p, List<ItemStack> items, boolean ignoreCustomHelmet, Color color) {
        block4: {
            if (items == null) {
                return;
            }
            for (ItemStack is : items) {
                InventoryUtil.addItemToInventory(p, is.clone(), is.getAmount(), false, ignoreCustomHelmet, color);
            }
            try {
                p.updateInventory();
            }
            catch (Exception e) {
                if (Defaults.DEBUG_VIRTUAL) break block4;
                Log.printStackTrace(e);
            }
        }
    }

    public static void addItemToInventory(Player player, ItemStack itemStack, int stockAmount, boolean update, boolean ignoreCustomHelmet) {
        InventoryUtil.addItemToInventory(player, itemStack, stockAmount, update, ignoreCustomHelmet, null);
    }

    public static void addItemToInventory(Player player, ItemStack itemStack, int stockAmount, boolean update, boolean ignoreCustomHelmet, Color color) {
        block5: {
            PlayerInventory inv = player.getInventory();
            Material itemType = itemStack.getType();
            if (armor.containsKey(itemType)) {
                InventoryUtil.addArmorToInventory(inv, itemStack, stockAmount, ignoreCustomHelmet, color);
            } else {
                InventoryUtil.addItemToInventory((Inventory)inv, itemStack, stockAmount);
            }
            if (update) {
                try {
                    player.updateInventory();
                }
                catch (Exception e) {
                    if (Defaults.DEBUG_VIRTUAL) break block5;
                    Log.printStackTrace(e);
                }
            }
        }
    }

    private static void addArmorToInventory(PlayerInventory inv, ItemStack itemStack, int stockAmount, boolean ignoreCustomHelmet, Color color) {
        boolean better;
        Material itemType = itemStack.getType();
        boolean isHelmet = InventoryUtil.armor.get((Object)itemType).type == ArmorType.HELM;
        Armor a = armor.get(itemType);
        ItemStack oldArmor = InventoryUtil.getArmorSlot(inv, a.type);
        boolean empty = oldArmor == null || oldArmor.getType() == Material.AIR;
        boolean bl = better = empty || InventoryUtil.armorSlotBetter(armor.get(oldArmor.getType()), a);
        if (color != null && a.level == ArmorLevel.LEATHER) {
            handler.setColor(itemStack, color);
        }
        if (empty || better) {
            switch (InventoryUtil.armor.get((Object)itemType).type) {
                case HELM: {
                    if (!empty && ignoreCustomHelmet) break;
                    inv.setHelmet(itemStack);
                    break;
                }
                case CHEST: {
                    inv.setChestplate(itemStack);
                    break;
                }
                case LEGGINGS: {
                    inv.setLeggings(itemStack);
                    break;
                }
                case BOOTS: {
                    inv.setBoots(itemStack);
                }
            }
        }
        if (!empty) {
            if (!(!better || isHelmet && ignoreCustomHelmet)) {
                InventoryUtil.addItemToInventory((Inventory)inv, oldArmor, oldArmor.getAmount());
            } else {
                InventoryUtil.addItemToInventory((Inventory)inv, itemStack, stockAmount);
            }
        }
    }

    public static int first(Inventory inv, ItemStack is1) {
        if (is1 == null) {
            return -1;
        }
        ItemStack[] inventory = inv.getContents();
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack is2 = inventory[i];
            if (is2 == null || is1.getTypeId() != is2.getTypeId() || is1.getDurability() != is2.getDurability()) continue;
            return i;
        }
        return -1;
    }

    public static HashMap<Integer, ItemStack> removeItems(Inventory inv, List<ItemStack> items) {
        return InventoryUtil.removeItem(inv, items.toArray(new ItemStack[items.size()]));
    }

    public static HashMap<Integer, ItemStack> removeItems(PlayerInventory inv, ItemStack ... items) {
        HashMap<Integer, ItemStack> leftover = InventoryUtil.removeItem((Inventory)inv, items);
        if (leftover.isEmpty()) {
            return leftover;
        }
        for (ItemStack is1 : items) {
            ItemStack is2 = inv.getBoots();
            if (is2 != null && is1.getTypeId() == is2.getTypeId() && is1.getDurability() == is2.getDurability()) {
                inv.setBoots(null);
                continue;
            }
            is2 = inv.getLeggings();
            if (is2 != null && is1.getTypeId() == is2.getTypeId() && is1.getDurability() == is2.getDurability()) {
                inv.setLeggings(null);
                continue;
            }
            is2 = inv.getChestplate();
            if (is2 != null && is1.getTypeId() == is2.getTypeId() && is1.getDurability() == is2.getDurability()) {
                inv.setChestplate(null);
                continue;
            }
            is2 = inv.getHelmet();
            if (is2 == null || is1.getTypeId() != is2.getTypeId() || is1.getDurability() != is2.getDurability()) continue;
            inv.setHelmet(null);
        }
        return leftover;
    }

    public static HashMap<Integer, ItemStack> removeItem(Inventory inv, ItemStack ... items) {
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        block0: for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            int toDelete = item.getAmount();
            do {
                int first;
                if ((first = InventoryUtil.first(inv, item)) == -1) {
                    item.setAmount(toDelete);
                    leftover.put(i, item);
                    continue block0;
                }
                ItemStack itemStack = inv.getItem(first);
                int amount = itemStack.getAmount();
                if (amount <= toDelete) {
                    toDelete -= amount;
                    inv.setItem(first, null);
                    continue;
                }
                itemStack.setAmount(amount - toDelete);
                inv.setItem(first, itemStack);
                toDelete = 0;
            } while (toDelete > 0);
        }
        return leftover;
    }

    private static boolean armorSlotBetter(Armor oldArmor, Armor newArmor) {
        return oldArmor != null && newArmor != null && oldArmor.level.ordinal() < newArmor.level.ordinal();
    }

    private static ItemStack getArmorSlot(PlayerInventory inv, ArmorType armorType) {
        switch (armorType) {
            case HELM: {
                return inv.getHelmet();
            }
            case CHEST: {
                return inv.getChestplate();
            }
            case LEGGINGS: {
                return inv.getLeggings();
            }
            case BOOTS: {
                return inv.getBoots();
            }
        }
        return null;
    }

    public static void addItemToInventory(Inventory inv, ItemStack is, int left) {
        if (is == null || is.getType() == Material.AIR) {
            return;
        }
        if (Defaults.ITEMS_IGNORE_STACKSIZE) {
            inv.addItem(new ItemStack[]{is});
            return;
        }
        int maxStackSize = is.getType().getMaxStackSize();
        ItemStack is2 = is.clone();
        if (left <= maxStackSize) {
            is2.setAmount(left);
            inv.addItem(new ItemStack[]{is2});
            return;
        }
        if (maxStackSize != 64) {
            Object[] iArray;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            int i = 0;
            while ((double)i < Math.ceil((double)left / (double)maxStackSize)) {
                if (left < maxStackSize) {
                    is2.setAmount(left);
                    items.add(is2);
                    return;
                }
                is2.setAmount(maxStackSize);
                items.add(is2);
                ++i;
            }
            for (Object o : iArray = items.toArray()) {
                inv.addItem(new ItemStack[]{(ItemStack)o});
            }
        } else {
            inv.addItem(new ItemStack[]{is});
        }
    }

    public static void closeInventory(Player p) {
        try {
            p.closeInventory();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void clearInventory(Player p) {
        if (Defaults.DEBUG_STORAGE) {
            Log.info("Clearing inventory of " + p.getName() + " o=" + p.isOnline() + ", d=" + p.isDead() + "   inv=" + p.getInventory());
        }
        try {
            PlayerInventory inv = p.getInventory();
            InventoryUtil.closeInventory(p);
            if (inv != null) {
                inv.clear();
                inv.setArmorContents(null);
                inv.setItemInHand(null);
            }
            p.updateInventory();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public static void clearInventory(Player p, boolean skipHead) {
        if (!skipHead) {
            InventoryUtil.clearInventory(p);
            return;
        }
        if (Defaults.DEBUG_STORAGE) {
            Log.info("Clearing inventory of " + p.getName());
        }
        try {
            PlayerInventory inv = p.getInventory();
            InventoryUtil.closeInventory(p);
            if (inv != null) {
                inv.clear();
                if (inv.getHelmet() != null && InventoryUtil.isRealArmor(inv.getHelmet())) {
                    inv.setHelmet(null);
                }
                inv.setBoots(null);
                inv.setChestplate(null);
                inv.setLeggings(null);
                inv.setItemInHand(null);
            }
            p.updateInventory();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public static Object getCommonName(ItemStack is) {
        int id = is.getTypeId();
        short datavalue = is.getDurability();
        if (datavalue > 0) {
            return Material.getMaterial((int)id).toString() + ":" + datavalue;
        }
        return Material.getMaterial((int)id).toString();
    }

    public static boolean isItem(String str) {
        try {
            return InventoryUtil.parseItem(str) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ItemStack parseItem(String str) throws Exception {
        int amt;
        String[] split;
        ItemStack is;
        Integer pos;
        Color c;
        String displayName;
        String ownerName;
        LinkedList<String> lore;
        if (str.contains("{")) {
            str = str.replaceFirst("=", " ");
        }
        if ((lore = InventoryUtil.parseLore(str = str.replaceAll("[}{]", ""))) != null) {
            str = PATTERN_LORE.matcher(str).replaceFirst("");
        }
        if ((ownerName = InventoryUtil.parseOwner(str)) != null) {
            str = PATTERN_OWNER.matcher(str).replaceFirst("");
        }
        if ((displayName = InventoryUtil.parseDisplayName(str)) != null) {
            str = PATTERN_DISPLAY_NAME.matcher(str).replaceFirst("");
        }
        if ((c = InventoryUtil.parseColor(str)) != null) {
            str = PATTERN_COLOR.matcher(str).replaceFirst("");
        }
        if ((pos = InventoryUtil.parsePosition(str)) != null) {
            str = PATTERN_POSITION.matcher(str).replaceFirst("");
        }
        if ((is = InventoryUtil.getItemStack((split = str.split(" +"))[0].trim())) == null) {
            return null;
        }
        if (split.length > 1) {
            try {
                amt = Integer.valueOf(split[split.length - 1]);
            }
            catch (Exception e) {
                amt = 1;
            }
        } else {
            amt = 1;
        }
        is.setAmount(amt);
        if (lore != null && !lore.isEmpty()) {
            handler.setLore(is, lore);
        }
        if (c != null) {
            handler.setColor(is, c);
        }
        if (displayName != null) {
            handler.setDisplayName(is, displayName);
        }
        if (ownerName != null) {
            handler.setOwnerName(is, ownerName);
        }
        for (int i = 1; i < split.length - 1; ++i) {
            if (Defaults.TESTSERVER) continue;
            EnchantmentWithLevel ewl = InventoryUtil.getEnchantment(split[i].trim());
            if (ewl == null) {
                throw new IllegalArgumentException(" enchantment " + split[i].trim() + " does not exist");
            }
            try {
                is.addUnsafeEnchantment(ewl.e, ewl.lvl.intValue());
                continue;
            }
            catch (IllegalArgumentException iae) {
                Log.warn(ewl + " can not be applied to the item " + str);
            }
        }
        return is;
    }

    public static Integer parsePosition(String str) {
        Matcher m = PATTERN_POSITION.matcher(str);
        if (!m.find()) {
            return null;
        }
        return Integer.valueOf(m.group(1));
    }

    public static Color parseColor(String str) {
        Matcher m = PATTERN_COLOR.matcher(str);
        if (!m.find()) {
            return null;
        }
        return new Color(Integer.valueOf(m.group(1)), Integer.valueOf(m.group(2)), Integer.valueOf(m.group(3)));
    }

    public static String parseOwner(String str) {
        Matcher matcher = PATTERN_OWNER.matcher(str);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(1);
    }

    public static String parseDisplayName(String str) {
        Matcher matcher = PATTERN_DISPLAY_NAME.matcher(str);
        if (!matcher.find()) {
            return null;
        }
        return MessageUtil.colorChat(matcher.group(1));
    }

    public static LinkedList<String> parseLore(String str) {
        try {
            Matcher matcher = PATTERN_LORE.matcher(str);
            if (matcher.find()) {
                String part = ChatColor.translateAlternateColorCodes((char)'&', (String)matcher.group(1));
                String[] lines = part.split("([;\\n]|\\\\n)");
                LinkedList<String> lore = new LinkedList<String>();
                Collections.addAll(lore, lines);
                return lore;
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        return null;
    }

    public static EnchantmentWithLevel getEnchantment(String str) {
        if (str.equalsIgnoreCase("all")) {
            return new EnchantmentWithLevel(true);
        }
        Enchantment e = null;
        int index = (str = str.replaceAll(",", ":")).indexOf(58);
        index = index != -1 ? index : -1;
        int lvl = -1;
        if (index != -1) {
            try {
                lvl = Integer.parseInt(str.substring(index + 1));
            }
            catch (Exception err) {
                // empty catch block
            }
            str = str.substring(0, index);
        }
        try {
            e = Enchantment.getById((int)Integer.valueOf(str));
        }
        catch (Exception err) {
            // empty catch block
        }
        if (e == null) {
            e = Enchantment.getByName((String)str);
        }
        if (e == null) {
            e = InventoryUtil.getEnchantmentByCommonName(str);
        }
        if (e == null) {
            return null;
        }
        EnchantmentWithLevel ewl = new EnchantmentWithLevel();
        ewl.e = e;
        if (lvl < e.getStartLevel()) {
            lvl = e.getStartLevel();
        }
        if (!Defaults.ITEMS_UNSAFE_ENCHANTMENTS && lvl > e.getMaxLevel()) {
            lvl = e.getMaxLevel();
        }
        ewl.lvl = lvl;
        return ewl;
    }

    public boolean addEnchantments(ItemStack is, String[] args) {
        HashMap<Enchantment, Integer> encs = new HashMap<Enchantment, Integer>();
        for (String s : args) {
            EnchantmentWithLevel ewl = InventoryUtil.getEnchantment(s);
            if (ewl == null) continue;
            if (ewl.all) {
                return this.addAllEnchantments(is);
            }
            encs.put(ewl.e, ewl.lvl);
        }
        this.addEnchantments(is, encs);
        return true;
    }

    public void addEnchantments(ItemStack is, Map<Enchantment, Integer> enchantments) {
        for (Enchantment e : enchantments.keySet()) {
            is.addUnsafeEnchantment(e, enchantments.get(e).intValue());
        }
    }

    public boolean addAllEnchantments(ItemStack is) {
        for (Enchantment enc : Enchantment.values()) {
            if (!enc.canEnchantItem(is)) continue;
            is.addUnsafeEnchantment(enc, enc.getMaxLevel());
        }
        return true;
    }

    public static String getItemString(ItemStack is) {
        String op;
        Color color;
        StringBuilder sb = new StringBuilder();
        if (is.getDurability() > 0) {
            sb.append(is.getType().toString()).append(":").append(is.getDurability()).append(" ");
        } else {
            sb.append(is.getType().toString()).append(" ");
        }
        Map encs = is.getEnchantments();
        for (Enchantment enc : encs.keySet()) {
            sb.append(enc.getName()).append(":").append(encs.get(enc)).append(" ");
        }
        List<String> lore = handler.getLore(is);
        if (lore != null && !lore.isEmpty()) {
            sb.append("lore=\"").append(StringUtils.join(lore, (String)"\\n")).append("\" ");
        }
        if ((color = handler.getColor(is)) != null) {
            sb.append("color=\"").append(color.getRed()).append(",").append(color.getGreen()).append(",").append(color.getBlue()).append("\" ");
        }
        if ((op = handler.getDisplayName(is)) != null && !op.isEmpty()) {
            sb.append("displayName=\"").append(op).append("\" ");
        }
        if ((op = handler.getOwnerName(is)) != null && !op.isEmpty()) {
            sb.append("ownerName=\"").append(op).append("\" ");
        }
        sb.append(is.getAmount());
        return sb.toString();
    }

    public static boolean isColorable(ItemStack item) {
        Armor a = armor.get(item.getType());
        return a != null && a.level == ArmorLevel.LEATHER;
    }

    public static boolean hasEnchantedItem(Player p) {
        Map enc;
        PlayerInventory inv = p.getInventory();
        for (ItemStack is : inv.getContents()) {
            if (is == null || is.getType() == Material.AIR || (enc = is.getEnchantments()) == null || enc.isEmpty()) continue;
            return true;
        }
        for (ItemStack is : inv.getArmorContents()) {
            if (is == null || is.getType() == Material.AIR || (enc = is.getEnchantments()) == null || enc.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean sameMaterial(ArmorLevel lvl, ItemStack is) {
        Armor a = armor.get(is.getType());
        return a != null && a.level == lvl;
    }

    public static ItemStack getWool(int color) {
        return new ItemStack(Material.WOOL, 1, (short)color);
    }

    public static void printInventory(Player p) {
        PlayerInventory pi = p.getInventory();
        Log.info("Inventory of " + p.getName());
        for (ItemStack is : pi.getContents()) {
            if (is == null || is.getType() == Material.AIR) continue;
            Log.info(InventoryUtil.getCommonName(is) + "  " + is.getAmount());
        }
        for (ItemStack is : pi.getArmorContents()) {
            if (is == null || is.getType() == Material.AIR) continue;
            Log.info(InventoryUtil.getCommonName(is) + "  " + is.getAmount());
        }
    }

    public static boolean sameItem(ItemStack item1, ItemStack item2) {
        return InventoryUtil.compareItem(item1, item2) == 0;
    }

    public static int compareItem(ItemStack item1, ItemStack item2) {
        if (item1 == null && item2 == null) {
            return 0;
        }
        if (item1 == null) {
            return 1;
        }
        if (item2 == null) {
            return -1;
        }
        Integer i = item1.getTypeId();
        Integer i2 = item2.getTypeId();
        if (i.intValue() == Material.AIR.getId() && i2.intValue() == Material.AIR.getId()) {
            return 0;
        }
        if (i.intValue() == Material.AIR.getId()) {
            return 1;
        }
        if (i2.intValue() == Material.AIR.getId()) {
            return -1;
        }
        int c = i.compareTo(i2);
        if (c != 0) {
            return c;
        }
        Short s = item1.getDurability();
        c = s.compareTo(item2.getDurability());
        if (c != 0) {
            return c;
        }
        i = item1.getAmount();
        c = i.compareTo(item2.getAmount());
        if (c != 0) {
            return c;
        }
        Map e1 = item1.getEnchantments();
        Map e2 = item1.getEnchantments();
        i = e1.size();
        c = i.compareTo(e2.size());
        if (c != 0) {
            return c;
        }
        for (Enchantment e : e1.keySet()) {
            if (!e2.containsKey(e)) {
                return -1;
            }
            i = (Integer)e1.get(e);
            c = i.compareTo(i2 = (Integer)e2.get(e));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public static boolean sameItems(List<ItemStack> items, PlayerInventory inv, boolean woolTeams) {
        ItemStack[] contents = inv.getContents();
        ItemStack[] armor = inv.getArmorContents();
        int nitems1 = 0;
        int nitems2 = 0;
        int dura1 = 0;
        int dura2 = 0;
        for (ItemStack is : items) {
            if (is == null || is.getType() == Material.AIR) continue;
            nitems1 += is.getAmount();
            dura1 += is.getDurability() * is.getAmount();
        }
        for (ItemStack is : contents) {
            if (is == null || is.getType() == Material.AIR) continue;
            nitems2 += is.getAmount();
            dura2 += is.getDurability() * is.getAmount();
        }
        if (!woolTeams) {
            for (ItemStack is : armor) {
                if (is == null || is.getType() == Material.AIR) continue;
                nitems2 += is.getAmount();
                dura2 += is.getDurability() * is.getAmount();
            }
        } else {
            ItemStack is = inv.getHelmet();
            if (is != null && is.getType() != Material.AIR && InventoryUtil.isRealArmor(is)) {
                nitems2 += is.getAmount();
                dura2 += is.getDurability() * is.getAmount();
            }
            if ((is = inv.getBoots()) != null && is.getType() != Material.AIR) {
                nitems2 += is.getAmount();
                dura2 += is.getDurability() * is.getAmount();
            }
            if ((is = inv.getLeggings()) != null && is.getType() != Material.AIR) {
                nitems2 += is.getAmount();
                dura2 += is.getDurability() * is.getAmount();
            }
            if ((is = inv.getChestplate()) != null && is.getType() != Material.AIR) {
                nitems2 += is.getAmount();
                dura2 += is.getDurability() * is.getAmount();
            }
        }
        return nitems1 == nitems2 && dura1 == dura2;
    }

    public static void addToInventory(Player p, PInv pinv) {
        try {
            ArmorType armor;
            int ord;
            PlayerInventory inv = p.getPlayer().getInventory();
            ArmorType[] arr$ = ArmorType.values();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (ord = (armor = arr$[i$]).ordinal()) < pinv.armor.length; ++i$) {
                boolean empty;
                ItemStack newArmor = pinv.armor[ord];
                if (newArmor == null || newArmor.getType() == Material.AIR) continue;
                ItemStack oldArmor = InventoryUtil.getArmorSlot(inv, armor);
                boolean bl = empty = oldArmor == null || oldArmor.getType() == Material.AIR;
                if (empty) {
                    switch (armor) {
                        case HELM: {
                            inv.setHelmet(newArmor);
                            break;
                        }
                        case CHEST: {
                            inv.setChestplate(newArmor);
                            break;
                        }
                        case LEGGINGS: {
                            inv.setLeggings(newArmor);
                            break;
                        }
                        case BOOTS: {
                            inv.setBoots(newArmor);
                        }
                    }
                    continue;
                }
                InventoryUtil.addItemToInventory(p, newArmor, newArmor.getAmount(), false, false);
            }
            inv.setContents(pinv.contents);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        try {
            p.getPlayer().updateInventory();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public static List<ItemStack> getItemList(Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack item : player.getInventory().getArmorContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            items.add(item);
        }
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            items.add(item);
        }
        return items;
    }

    public static void dropItems(Player player) {
        Location loc = player.getLocation();
        World w = loc.getWorld();
        PlayerInventory inv = player.getInventory();
        for (ItemStack is : inv.getArmorContents()) {
            if (is == null || is.getType() == Material.AIR) continue;
            w.dropItemNaturally(loc, is);
        }
        for (ItemStack is : inv.getContents()) {
            if (is == null || is.getType() == Material.AIR) continue;
            w.dropItemNaturally(loc, is);
        }
    }

    public static ArrayList<ItemStack> getItemList(ConfigurationSection cs, String nodeString) {
        if (cs == null || cs.getList(nodeString) == null) {
            return null;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        try {
            String str = null;
            for (Object o : cs.getList(nodeString)) {
                try {
                    str = o.toString();
                    ItemStack is = InventoryUtil.parseItem(str);
                    if (is != null) {
                        items.add(is);
                        continue;
                    }
                    Log.err(cs.getCurrentPath() + "." + nodeString + " couldnt parse item " + str);
                }
                catch (IllegalArgumentException e) {
                    Log.err(cs.getCurrentPath() + "." + nodeString + " couldnt parse item " + str);
                }
                catch (Exception e) {
                    Log.err(cs.getCurrentPath() + "." + nodeString + " couldnt parse item " + str);
                }
            }
        }
        catch (Exception e) {
            Log.err(cs.getCurrentPath() + "." + nodeString + " could not be parsed in config.yml");
            Log.printStackTrace(e);
        }
        return items;
    }

    static {
        block7: {
            handler = null;
            Class[] args = new Class[]{};
            try {
                String pkg = Bukkit.getServer().getClass().getPackage().getName();
                String version = pkg.substring(pkg.lastIndexOf(46) + 1);
                Class<?> clazz = version.equalsIgnoreCase("craftbukkit") ? Class.forName("mc.alk.arena.util.compat.pre.InventoryHelper") : Class.forName("mc.alk.arena.util.compat.v1_4_5.InventoryHelper");
                handler = (IInventoryHelper)clazz.getConstructor(args).newInstance(args);
            }
            catch (Exception e) {
                block6: {
                    try {
                        Class<?> clazz = Class.forName("mc.alk.arena.util.compat.pre.InventoryHelper");
                        handler = (IInventoryHelper)clazz.getConstructor(args).newInstance(args);
                    }
                    catch (Exception e2) {
                        if (Defaults.TESTSERVER) break block6;
                        Log.printStackTrace(e2);
                    }
                }
                if (Defaults.TESTSERVER) break block7;
                Log.printStackTrace(e);
            }
        }
        armor = new EnumMap<Material, Armor>(Material.class);
        try {
            armor.put(Material.SKULL_ITEM, new Armor(ArmorType.HELM, ArmorLevel.DISGUISE));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        armor.put(Material.WOOL, new Armor(ArmorType.HELM, ArmorLevel.WOOL));
        armor.put(Material.LEATHER_HELMET, new Armor(ArmorType.HELM, ArmorLevel.LEATHER));
        armor.put(Material.IRON_HELMET, new Armor(ArmorType.HELM, ArmorLevel.IRON));
        armor.put(Material.GOLD_HELMET, new Armor(ArmorType.HELM, ArmorLevel.GOLD));
        armor.put(Material.DIAMOND_HELMET, new Armor(ArmorType.HELM, ArmorLevel.DIAMOND));
        armor.put(Material.CHAINMAIL_HELMET, new Armor(ArmorType.HELM, ArmorLevel.CHAINMAIL));
        armor.put(Material.LEATHER_CHESTPLATE, new Armor(ArmorType.CHEST, ArmorLevel.LEATHER));
        armor.put(Material.IRON_CHESTPLATE, new Armor(ArmorType.CHEST, ArmorLevel.IRON));
        armor.put(Material.GOLD_CHESTPLATE, new Armor(ArmorType.CHEST, ArmorLevel.GOLD));
        armor.put(Material.DIAMOND_CHESTPLATE, new Armor(ArmorType.CHEST, ArmorLevel.DIAMOND));
        armor.put(Material.CHAINMAIL_CHESTPLATE, new Armor(ArmorType.CHEST, ArmorLevel.CHAINMAIL));
        armor.put(Material.LEATHER_LEGGINGS, new Armor(ArmorType.LEGGINGS, ArmorLevel.LEATHER));
        armor.put(Material.IRON_LEGGINGS, new Armor(ArmorType.LEGGINGS, ArmorLevel.IRON));
        armor.put(Material.GOLD_LEGGINGS, new Armor(ArmorType.LEGGINGS, ArmorLevel.GOLD));
        armor.put(Material.DIAMOND_LEGGINGS, new Armor(ArmorType.LEGGINGS, ArmorLevel.DIAMOND));
        armor.put(Material.CHAINMAIL_LEGGINGS, new Armor(ArmorType.LEGGINGS, ArmorLevel.CHAINMAIL));
        armor.put(Material.LEATHER_BOOTS, new Armor(ArmorType.BOOTS, ArmorLevel.LEATHER));
        armor.put(Material.IRON_BOOTS, new Armor(ArmorType.BOOTS, ArmorLevel.IRON));
        armor.put(Material.GOLD_BOOTS, new Armor(ArmorType.BOOTS, ArmorLevel.GOLD));
        armor.put(Material.DIAMOND_BOOTS, new Armor(ArmorType.BOOTS, ArmorLevel.DIAMOND));
        armor.put(Material.CHAINMAIL_BOOTS, new Armor(ArmorType.BOOTS, ArmorLevel.CHAINMAIL));
        PATTERN_LORE = Pattern.compile("lore= ?\"([^\"]*)\"", 2);
        PATTERN_OWNER = Pattern.compile("owner= ?\"([^\"]*)\"", 2);
        PATTERN_DISPLAY_NAME = Pattern.compile("displayName= ?\"([^\"]*)\"", 2);
        PATTERN_COLOR = Pattern.compile("color= ?([0-9]+),([0-9]+),([0-9]+)", 2);
        PATTERN_POSITION = Pattern.compile("position= ?\"([^\"]*)\"", 2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ItemComparator
    implements Comparator<ItemStack> {
        @Override
        public int compare(ItemStack arg0, ItemStack arg1) {
            return InventoryUtil.compareItem(arg0, arg1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArmorType {
        BOOTS,
        LEGGINGS,
        CHEST,
        HELM;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArmorLevel {
        DISGUISE,
        WOOL,
        LEATHER,
        IRON,
        GOLD,
        CHAINMAIL,
        DIAMOND;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PInv {
        public ItemStack[] contents;
        public ItemStack[] armor;

        public PInv() {
        }

        public PInv(PlayerInventory inventory) {
            this.contents = inventory.getContents();
            this.setArmor(inventory);
        }

        public PInv(List<ItemStack> items) {
            this.contents = items.toArray(new ItemStack[items.size()]);
            this.armor = new ItemStack[0];
        }

        public void setArmor(PlayerInventory inventory) {
            this.armor = new ItemStack[4];
            this.armor[ArmorType.HELM.ordinal()] = inventory.getHelmet();
            this.armor[ArmorType.CHEST.ordinal()] = inventory.getChestplate();
            this.armor[ArmorType.LEGGINGS.ordinal()] = inventory.getLeggings();
            this.armor[ArmorType.BOOTS.ordinal()] = inventory.getBoots();
        }
    }

    public static class EnchantmentWithLevel {
        public Enchantment e;
        public Integer lvl;
        boolean all = false;

        public EnchantmentWithLevel() {
        }

        public EnchantmentWithLevel(boolean all) {
            this.all = all;
        }

        public String toString() {
            return (this.e != null ? this.e.getName() : "null") + ":" + this.lvl;
        }
    }

    public static class Armor {
        public final ArmorLevel level;
        public final ArmorType type;

        Armor(ArmorType at, ArmorLevel al) {
            this.level = al;
            this.type = at;
        }
    }
}

