/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util;

import java.util.logging.Logger;
import mc.alk.arena.Defaults;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.NotifierUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public class Log {
    private static Logger log;

    public static void setLogger(Logger log) {
        Log.log = log;
    }

    public static void info(String msg) {
        if (msg == null) {
            return;
        }
        try {
            MessageUtil.sendMessage((CommandSender)Bukkit.getConsoleSender(), Log.colorChat(msg));
        }
        catch (Exception e) {
            if (log != null) {
                log.info(Log.colorChat(msg));
            }
            System.out.println(Log.colorChat(msg));
        }
        NotifierUtil.notify("info", msg);
    }

    public static void warn(String msg) {
        if (msg == null) {
            return;
        }
        try {
            MessageUtil.sendMessage((CommandSender)Bukkit.getConsoleSender(), Log.colorChat(msg));
        }
        catch (Exception e) {
            if (log != null) {
                log.warning(Log.colorChat(msg));
            }
            System.out.println(Log.colorChat(msg));
        }
        NotifierUtil.notify("warn", msg);
    }

    public static void err(String msg) {
        if (msg == null) {
            return;
        }
        try {
            MessageUtil.sendMessage((CommandSender)Bukkit.getConsoleSender(), Log.colorChat(msg));
        }
        catch (Exception e) {
            if (log != null) {
                log.severe(Log.colorChat(msg));
            }
            System.err.println(Log.colorChat(msg));
        }
        NotifierUtil.notify("errors", msg);
    }

    public static String colorChat(String msg) {
        return msg.replace('&', '\u00a7');
    }

    public static void debug(String msg) {
        msg = MessageUtil.colorChat(msg);
        if (Defaults.DEBUG_MSGS) {
            try {
                MessageUtil.sendMessage((CommandSender)Bukkit.getConsoleSender(), msg);
            }
            catch (Exception e) {
                System.out.println(msg);
            }
        }
        if (NotifierUtil.hasListener("debug")) {
            NotifierUtil.notify("debug", msg);
        }
    }

    public static void printStackTrace(Throwable e) {
        e.printStackTrace();
        if (NotifierUtil.hasListener("errors")) {
            NotifierUtil.notify("errors", e);
        }
    }

    public static void trace(int id, String msg) {
        Log.info(msg);
        NotifierUtil.notify(id, Log.colorChat(msg));
    }
}

