/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util;

import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapOfTreeSet<K, V>
extends HashMap<K, TreeSet<V>> {
    private static final long serialVersionUID = 1L;
    Comparator<V> comparator = null;
    final Class<V> vClass;

    public MapOfTreeSet(Class<V> valueParameterClass) {
        this.vClass = valueParameterClass;
    }

    public MapOfTreeSet(Class<V> valueParameterClass, Comparator<V> comparator) {
        this.comparator = comparator;
        this.vClass = valueParameterClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(K k, V v) {
        MapOfTreeSet mapOfTreeSet = this;
        synchronized (mapOfTreeSet) {
            TreeSet<V> set = (TreeSet<V>)this.get(k);
            if (set == null) {
                set = this.comparator != null ? new TreeSet<V>(this.comparator) : new TreeSet<V>();
                this.put(k, set);
            }
            return set.add(v);
        }
    }

    @Override
    public boolean remove(K k, V v) {
        if (!this.containsKey(k)) {
            return false;
        }
        Set set = (Set)this.get(k);
        if (set.remove(v) && set.isEmpty()) {
            this.remove(k);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V[] getSafe(K k) {
        TreeSet set = (TreeSet)this.get(k);
        MapOfTreeSet mapOfTreeSet = this;
        synchronized (mapOfTreeSet) {
            if (set == null) {
                return null;
            }
            return set.toArray((Object[])Array.newInstance(this.vClass, set.size()));
        }
    }
}

