/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import mc.alk.arena.controllers.messaging.MessageHandler;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.teams.ArenaTeam;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageUtil {
    public static String colorChat(String msg) {
        return msg.replace('&', '\u00a7');
    }

    public static String decolorChat(String msg) {
        return msg.contains("\u00a7") || msg.contains("&") ? ChatColor.stripColor((String)msg).replaceAll("(&|\u00a7).", "") : msg;
    }

    public static boolean sendSystemMessage(CommandSender p, String nodeString, Object ... varArgs) {
        return MessageUtil.sendMessage(p, MessageHandler.getSystemMessage(nodeString, varArgs));
    }

    public static boolean sendMessage(CommandSender p, String message) {
        if (message == null || message.isEmpty()) {
            return true;
        }
        if (message.contains("\n")) {
            return MessageUtil.sendMultilineMessage(p, message);
        }
        if (p instanceof Player) {
            if (((Player)p).isOnline()) {
                p.sendMessage(MessageUtil.colorChat(message));
            }
        } else {
            p.sendMessage(MessageUtil.colorChat(message));
        }
        return true;
    }

    public static boolean sendMultilineMessage(CommandSender p, String message) {
        String[] msgs;
        if (message == null || message.isEmpty()) {
            return true;
        }
        for (String msg : msgs = message.split("\n")) {
            if (p instanceof Player) {
                if (!((Player)p).isOnline()) continue;
                p.sendMessage(MessageUtil.colorChat(msg));
                continue;
            }
            p.sendMessage(MessageUtil.colorChat(msg));
        }
        return true;
    }

    public static void sendPlayerMessage(Set<Player> players, String message) {
        String msg = MessageUtil.colorChat(message);
        for (Player p : players) {
            p.sendMessage(msg);
        }
    }

    public static String minuteOrMinutes(int minutes) {
        return minutes == 1 ? "minute" : "minutes";
    }

    public static String getTeamsOrPlayers(int teamSize) {
        return teamSize == 1 ? "players" : "teams";
    }

    public static String teamsOrPlayers(int nPlayersPerTeam) {
        return nPlayersPerTeam > 1 ? "teams" : "players";
    }

    public static String playerOrPlayers(int n) {
        return n > 1 ? "players" : "player";
    }

    public static String hasOrHave(int size) {
        return size == 1 ? "has" : "have";
    }

    public static boolean sendMessage(ArenaPlayer player, String message) {
        return MessageUtil.sendMessage((CommandSender)player.getPlayer(), message);
    }

    public static boolean sendMessage(ArenaPlayer player, List<String> messages) {
        for (String s : messages) {
            MessageUtil.sendMessage((CommandSender)player.getPlayer(), s);
        }
        return true;
    }

    public static void sendMessage(Collection<ArenaPlayer> players, String message) {
        if (message == null) {
            return;
        }
        String msg = MessageUtil.colorChat(message.trim());
        if (msg.isEmpty()) {
            return;
        }
        for (ArenaPlayer p : players) {
            p.getPlayer().sendMessage(msg);
        }
    }

    public static String convertToString(List<String> strs) {
        if (strs == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : strs) {
            if (!first) {
                sb.append("\n");
            }
            sb.append(s).append("\n");
            first = false;
        }
        return sb.toString();
    }

    public static ChatColor getFirstColor(String str) {
        ChatColor cc;
        int index = str.indexOf(167);
        if (index == -1) {
            index = str.indexOf(38);
        }
        if (index != -1 && str.length() > index + 1 && (cc = ChatColor.getByChar((char)str.charAt(index + 1))) != null) {
            return cc;
        }
        return ChatColor.WHITE;
    }

    public static String joinTeams(Collection<ArenaTeam> teams, String joinStr) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ArenaTeam t : teams) {
            if (!first) {
                sb.append(joinStr);
            }
            sb.append(t.getDisplayName());
            first = false;
        }
        return sb.toString();
    }

    public static String joinPlayers(Collection<ArenaPlayer> players, String joinStr) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ArenaPlayer p : players) {
            if (!first) {
                sb.append(joinStr);
            } else {
                first = false;
            }
            sb.append(p.getName());
        }
        return sb.toString();
    }

    public static void broadcastMessage(String message) {
        try {
            Bukkit.broadcastMessage((String)message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

