/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util;

import mc.alk.arena.objects.ArenaSize;

public class MinMax {
    public int min;
    public int max;

    public MinMax() {
        this.min = -1;
        this.max = -1;
    }

    public MinMax(int size) {
        this.min = size;
        this.max = size;
    }

    public MinMax(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public MinMax(MinMax mm) {
        this.min = mm.min;
        this.max = mm.max;
    }

    public String toString() {
        return ArenaSize.rangeString(this.min, this.max);
    }

    public boolean contains(int i) {
        return this.min <= i && this.max >= i;
    }

    public static MinMax valueOf(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("Number can not be null");
        }
        if (s.indexOf(43) != -1) {
            Integer i = Integer.valueOf(s.substring(0, s.indexOf(43)));
            return new MinMax(i, Integer.MAX_VALUE);
        }
        if (s.contains("-")) {
            String[] vals = s.split("-");
            int i = Integer.valueOf(vals[0]);
            int j = Integer.valueOf(vals[1]);
            return new MinMax(i, j);
        }
        Integer i = s.contains("v") ? Integer.valueOf(s.split("v")[0]) : Integer.valueOf(s);
        return new MinMax(i, i);
    }

    public boolean intersect(MinMax mm) {
        return Math.max(mm.min, this.min) <= Math.min(mm.max, this.max);
    }

    public boolean valid() {
        return this.min <= this.max;
    }
}

