/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util;

import mc.alk.arena.BattleArena;
import mc.alk.arena.Defaults;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.util.plugins.VaultPermUtil;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PermissionsUtil {
    static final int ticks = 0;
    static boolean hasVaultPerms = false;

    public static void setPermission(Plugin plugin) {
        hasVaultPerms = VaultPermUtil.setPermission(plugin);
    }

    public static void givePlayerInventoryPerms(ArenaPlayer p) {
        PermissionsUtil.givePlayerInventoryPerms(p.getPlayer());
    }

    public static void givePlayerInventoryPerms(Player p) {
        if (BattleArena.getSelf().isEnabled()) {
            if (Defaults.PLUGIN_MULTI_INV) {
                p.getPlayer().addAttachment((Plugin)BattleArena.getSelf(), "multiinv.exempt", true, 0);
            }
            if (Defaults.PLUGIN_MULITVERSE_CORE) {
                p.getPlayer().addAttachment((Plugin)BattleArena.getSelf(), "mv.bypass.gamemode.*", true, 0);
            }
            if (Defaults.PLUGIN_MULITVERSE_INV) {
                p.getPlayer().addAttachment((Plugin)BattleArena.getSelf(), "mvinv.bypass.*", true, 0);
            }
        }
    }

    public static int getPriority(Player player) {
        if (player.hasPermission("arena.priority.lowest")) {
            return 1000;
        }
        if (player.hasPermission("arena.priority.low")) {
            return 800;
        }
        if (player.hasPermission("arena.priority.normal")) {
            return 600;
        }
        if (player.hasPermission("arena.priority.high")) {
            return 400;
        }
        if (player.hasPermission("arena.priority.highest")) {
            return 200;
        }
        return 1000;
    }

    public static boolean isAdmin(CommandSender sender) {
        return sender.isOp() || sender.hasPermission("arena.admin");
    }

    public static boolean giveAdminPerms(Player player, Boolean enable) {
        return hasVaultPerms && VaultPermUtil.giveAdminPerms(player, enable);
    }

    public static boolean giveWGPerms(Player player, Boolean enable) {
        return hasVaultPerms && VaultPermUtil.giveWorldGuardPerms(player, enable);
    }

    public static boolean hasTeamPerm(CommandSender sender, MatchParams mp, Integer teamIndex) {
        return sender.hasPermission("arena.add.team.all") || sender.hasPermission("arena.add." + mp.getName().toLowerCase() + ".team.all") || sender.hasPermission("arena.add." + mp.getCommand().toLowerCase() + ".team." + (teamIndex + 1));
    }

    public static boolean hasMatchPerm(CommandSender sender, MatchParams mp, String perm) {
        return sender.hasPermission("arena." + mp.getName().toLowerCase() + "." + perm) || sender.hasPermission("arena." + mp.getCommand().toLowerCase() + "." + perm) || sender.hasPermission("arena." + perm + "." + mp.getName().toLowerCase()) || sender.hasPermission("arena." + perm + "." + mp.getCommand().toLowerCase());
    }
}

