/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util;

import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import mc.alk.arena.Defaults;
import mc.alk.arena.controllers.plugins.EssentialsController;
import mc.alk.arena.controllers.plugins.HeroesController;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.CommandLineString;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.PermissionsUtil;
import mc.alk.arena.util.Util;
import mc.alk.arena.util.compat.IPlayerHelper;
import mc.alk.mc.updater.Version;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerUtil {
    static IPlayerHelper handler = null;

    public static int getHunger(Player player) {
        return player.getFoodLevel();
    }

    public static void setHunger(Player player, Integer hunger) {
        player.setFoodLevel(hunger.intValue());
    }

    public static void setHealthP(Player player, Double health) {
        PlayerUtil.setHealthP(player, health, false);
    }

    public static void setHealthP(Player player, Double health, boolean skipHeroes) {
        if (!skipHeroes && HeroesController.enabled()) {
            HeroesController.setHealthP(player, health);
            return;
        }
        double val = player.getMaxHealth() * health / 100.0;
        PlayerUtil.setHealth(player, val);
    }

    public static void setHealth(Player player, Double health) {
        PlayerUtil.setHealth(player, health, false);
    }

    public static void setHealth(Player player, Double health, boolean skipHeroes) {
        handler.setHealth(player, health, skipHeroes);
    }

    public static Double getHealth(Player player) {
        return PlayerUtil.getHealth(player, false);
    }

    public static Double getHealth(Player player, boolean skipHeroes) {
        return !skipHeroes && HeroesController.enabled() ? HeroesController.getHealth(player) : handler.getHealth(player);
    }

    public static void setInvulnerable(Player player, Integer invulnerableTime) {
        player.setNoDamageTicks(invulnerableTime.intValue());
        player.setLastDamage(2.147483647E9);
    }

    public static void setGameMode(Player p, GameMode gameMode) {
        if (p.getGameMode() != gameMode) {
            PermissionsUtil.givePlayerInventoryPerms(p);
            p.setGameMode(gameMode);
        }
    }

    public static void doCommands(Player p, List<CommandLineString> doCommands) {
        String name = p.getName();
        for (CommandLineString cls : doCommands) {
            try {
                ConsoleCommandSender cs;
                Object object = cs = cls.isConsoleSender() ? Bukkit.getConsoleSender() : p;
                if (Defaults.DEBUG_TRANSITIONS) {
                    Log.info("BattleArena doing command '" + cls.getCommand(name) + "' as " + cs.getName());
                }
                PlayerUtil.doCommand((CommandSender)cs, cls.getCommand(name));
            }
            catch (Exception e) {
                Log.err("[BattleArena] Error executing command as console or player");
                Log.printStackTrace(e);
            }
        }
    }

    public static void doCommand(CommandSender cs, String cmd) {
        Bukkit.getServer().dispatchCommand(cs, cmd);
    }

    public static void setFlight(Player player, boolean enable) {
        if (player.getAllowFlight() != enable) {
            player.setAllowFlight(enable);
        }
        if (player.isFlying() != enable) {
            player.setFlying(enable);
        }
    }

    public static void setFlightSpeed(Player player, Float flightSpeed) {
        try {
            player.setFlySpeed(flightSpeed.floatValue());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setGod(Player player, boolean enable) {
        if (EssentialsController.enabled()) {
            EssentialsController.setGod(player, enable);
        }
    }

    public static Object getScoreboard(Player player) {
        return handler.getScoreboard(player);
    }

    public static void setScoreboard(Player player, Object scoreboard) {
        handler.setScoreboard(player, scoreboard);
    }

    public static UUID getID(ArenaPlayer player) {
        return handler.getID((OfflinePlayer)player.getPlayer());
    }

    public static UUID getID(OfflinePlayer player) {
        return handler.getID(player);
    }

    public static UUID getID(Player player) {
        return handler.getID((OfflinePlayer)player);
    }

    public static UUID getID(CommandSender sender) {
        if (sender instanceof ArenaPlayer) {
            return handler.getID((OfflinePlayer)((ArenaPlayer)sender).getPlayer());
        }
        if (sender instanceof Player) {
            return handler.getID((OfflinePlayer)((Player)sender));
        }
        return new UUID(0L, sender.getName().hashCode());
    }

    static {
        Class[] args = new Class[]{};
        try {
            Method m = Player.class.getMethod("getHealth", new Class[0]);
            Version version = Util.getCraftBukkitVersion();
            if (version.compareTo("v1_7_R3") >= 0) {
                Class<?> clazz = Class.forName("mc.alk.arena.util.compat.v1_7_R3.PlayerHelper");
                handler = (IPlayerHelper)clazz.getConstructor(args).newInstance(args);
            } else if (m.getReturnType() == Double.TYPE || version.compareTo("v1_6_R1") >= 0) {
                Class<?> clazz = Class.forName("mc.alk.arena.util.compat.v1_6_R1.PlayerHelper");
                handler = (IPlayerHelper)clazz.getConstructor(args).newInstance(args);
            } else {
                Class<?> clazz = Class.forName("mc.alk.arena.util.compat.pre.PlayerHelper");
                handler = (IPlayerHelper)clazz.getConstructor(args).newInstance(args);
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            try {
                Class<?> clazz = Class.forName("mc.alk.arena.util.compat.pre.PlayerHelper");
                handler = (IPlayerHelper)clazz.getConstructor(args).newInstance(args);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }
}

