/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoreMap<K>
extends ConcurrentHashMap<K, Integer> {
    private static final long serialVersionUID = 1L;

    public int addPoints(K key, int points) {
        Integer p = (Integer)this.get(key);
        if (p == null) {
            this.put(key, points);
            return points;
        }
        p = p + points;
        this.put(key, p);
        return p;
    }

    public int subtractPoints(K key, int points) {
        return this.addPoints(key, -points);
    }

    public int setPoints(K key, int points) {
        Integer p = (Integer)this.get(key);
        if (p == null) {
            p = 0;
        }
        this.put(key, points);
        return p;
    }

    public int getPoints(K key) {
        Integer p = (Integer)this.get(key);
        return p == null ? 0 : p;
    }

    public void reset() {
        this.clear();
    }

    public List<K> getLeaders() {
        int highest = Integer.MIN_VALUE;
        ArrayList victors = new ArrayList();
        for (Object t : this.keySet()) {
            int points = this.getPoints(t);
            if (points == highest) {
                victors.add(t);
            }
            if (points <= highest) continue;
            victors.clear();
            highest = points;
            victors.add(t);
        }
        return victors;
    }

    public synchronized TreeMap<Integer, Collection<K>> getRankings() {
        TreeMap map = new TreeMap(Collections.reverseOrder());
        for (Map.Entry entry : this.entrySet()) {
            Collection<K> col = map.get(entry.getValue());
            if (col == null) {
                col = new ArrayList<K>();
                map.put((Integer)entry.getValue(), col);
            }
            col.add(entry.getKey());
        }
        return map;
    }
}

