/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import mc.alk.arena.controllers.BukkitInterface;
import mc.alk.arena.controllers.containers.AreaContainer;
import mc.alk.arena.objects.spawns.FixedLocation;
import mc.alk.arena.objects.spawns.SpawnLocation;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializerUtil {
    public static Map<String, List<String>> createSaveableLocations(Map<Integer, List<SpawnLocation>> mlocs) {
        TreeMap<String, List<String>> locations = new TreeMap<String, List<String>>();
        if (mlocs != null) {
            for (Integer key : mlocs.keySet()) {
                ArrayList<String> list = new ArrayList<String>();
                for (SpawnLocation l : mlocs.get(key)) {
                    String s = SerializerUtil.getLocString(l);
                    list.add(s);
                }
                locations.put(key + "", list);
            }
        }
        return locations;
    }

    public static Map<String, List<String>> toSpawnMap(AreaContainer rc) {
        if (rc == null) {
            return null;
        }
        Map<String, List<String>> locations = null;
        Map<Integer, List<SpawnLocation>> spawns = SerializerUtil.toMap(rc.getSpawns());
        SpawnLocation mainSpawn = rc.getMainSpawn();
        if (spawns != null || mainSpawn != null) {
            locations = SerializerUtil.createSaveableLocations(spawns);
            if (mainSpawn != null) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(SerializerUtil.getLocString(mainSpawn));
                locations.put(String.valueOf(Integer.MAX_VALUE), list);
            }
        }
        return locations;
    }

    public static Map<Integer, List<SpawnLocation>> toMap(List<List<SpawnLocation>> spawns) {
        if (spawns == null) {
            return null;
        }
        HashMap<Integer, List<SpawnLocation>> map = new HashMap<Integer, List<SpawnLocation>>();
        for (int i = 0; i < spawns.size(); ++i) {
            ArrayList list = new ArrayList(spawns.get(i));
            map.put(i, list);
        }
        return map;
    }

    public static String getLocString(SpawnLocation l) {
        return l.getLocation().getWorld().getName() + "," + l.getLocation().getX() + "," + l.getLocation().getY() + "," + l.getLocation().getZ() + "," + l.getLocation().getYaw() + "," + l.getLocation().getPitch();
    }

    public static void expandMapIntoConfig(ConfigurationSection conf, Map<String, Object> map) {
        for (Map.Entry<String, Object> e : map.entrySet()) {
            if (e.getValue() instanceof Map) {
                ConfigurationSection section = conf.createSection(e.getKey());
                Map subMap = (Map)e.getValue();
                SerializerUtil.expandMapIntoConfig(section, subMap);
                continue;
            }
            conf.set(e.getKey(), e.getValue());
        }
    }

    public static Location getLocation(String locstr) throws IllegalArgumentException {
        if (locstr == null) {
            throw new IllegalArgumentException("Error parsing location. Location string was null");
        }
        String[] split = locstr.split(",");
        String w = split[0];
        float x = Float.valueOf(split[1]).floatValue();
        float y = Float.valueOf(split[2]).floatValue();
        float z = Float.valueOf(split[3]).floatValue();
        float yaw = 0.0f;
        float pitch = 0.0f;
        if (split.length > 4) {
            yaw = Float.valueOf(split[4]).floatValue();
        }
        if (split.length > 5) {
            pitch = Float.valueOf(split[5]).floatValue();
        }
        World world = null;
        if (w != null) {
            world = BukkitInterface.getWorld(w);
        }
        if (world == null) {
            throw new IllegalArgumentException("Error parsing location, World '" + locstr + "' does not exist");
        }
        return new Location(world, (double)x, (double)y, (double)z, yaw, pitch);
    }

    public static String getLocString(Location l) {
        if (l == null) {
            return null;
        }
        return l.getWorld().getName() + "," + l.getX() + "," + l.getY() + "," + l.getZ() + "," + l.getYaw() + "," + l.getPitch();
    }

    public static String getBlockLocString(Location l) {
        if (l == null) {
            return null;
        }
        return l.getWorld().getName() + "," + l.getBlockX() + "," + l.getBlockY() + "," + l.getBlockZ();
    }

    public static Map<Integer, List<SpawnLocation>> parseLocations(ConfigurationSection cs) throws IllegalArgumentException {
        if (cs == null) {
            return null;
        }
        TreeMap<Integer, List<SpawnLocation>> locs = new TreeMap<Integer, List<SpawnLocation>>();
        Set indices = cs.getKeys(false);
        for (String locIndexStr : indices) {
            Integer i = Integer.valueOf(locIndexStr);
            ArrayList<FixedLocation> list = new ArrayList<FixedLocation>();
            if (cs.getList(locIndexStr, null) != null) {
                for (String strloc : cs.getStringList(locIndexStr)) {
                    Location loc = SerializerUtil.getLocation(strloc);
                    list.add(new FixedLocation(loc));
                }
            } else {
                Location loc = SerializerUtil.getLocation(cs.getString(locIndexStr));
                list.add(new FixedLocation(loc));
            }
            locs.put(i, list);
        }
        return locs;
    }

    public static String getBlockString(Block b) {
        return b.getTypeId() + ";" + b.getData() + ";" + SerializerUtil.getBlockLocString(b.getLocation());
    }

    public static Block parseBlock(String string) {
        String[] split = string.split(";");
        Location l = SerializerUtil.getLocation(split[2]);
        return l.getWorld().getBlockAt(l);
    }
}

