/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util;

import java.io.File;
import java.util.Set;
import java.util.UUID;
import mc.alk.arena.Defaults;
import mc.alk.arena.util.Log;
import mc.alk.mc.updater.Version;
import mc.alk.virtualPlayer.VirtualPlayers;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerUtil {
    public static Player findOnlinePlayer(String name) {
        return ServerUtil.findPlayer(name);
    }

    public static Player findPlayer(UUID id) {
        if (id == null) {
            return null;
        }
        try {
            Player player = Bukkit.getPlayer((UUID)id);
            if (player != null) {
                return player;
            }
            if (Defaults.DEBUG_VIRTUAL) {
                return VirtualPlayers.getPlayer((UUID)id);
            }
        }
        catch (Throwable e) {
            Log.err("Craftbukkit version does not have find player by UUID yet.");
            Log.printStackTrace(e);
        }
        return null;
    }

    @Deprecated
    public static Player findPlayerExact(String name) {
        if (name == null) {
            return null;
        }
        Player player = Bukkit.getPlayerExact((String)name);
        if (player != null) {
            return player;
        }
        if (Defaults.DEBUG_VIRTUAL) {
            return VirtualPlayers.getPlayer((String)name);
        }
        return null;
    }

    @Deprecated
    public static Player findPlayer(String name) {
        if (name == null) {
            return null;
        }
        Player foundPlayer = Bukkit.getPlayer((String)name);
        if (foundPlayer != null) {
            return foundPlayer;
        }
        if (Defaults.DEBUG_VIRTUAL) {
            foundPlayer = VirtualPlayers.getPlayer((String)name);
        }
        if (foundPlayer != null) {
            return foundPlayer;
        }
        Player[] online = Bukkit.getOnlinePlayers();
        if (Defaults.DEBUG_VIRTUAL) {
            online = VirtualPlayers.getOnlinePlayers();
        }
        for (Player player : online) {
            String playerName = player.getName();
            if (playerName.equalsIgnoreCase(name)) {
                foundPlayer = player;
                break;
            }
            if (playerName.toLowerCase().indexOf(name.toLowerCase(), 0) == -1) continue;
            if (foundPlayer != null) {
                return null;
            }
            foundPlayer = player;
        }
        return foundPlayer;
    }

    @Deprecated
    public static OfflinePlayer findOfflinePlayer(String name) {
        Player p = ServerUtil.findPlayer(name);
        if (p != null) {
            return p;
        }
        for (World w : Bukkit.getWorlds()) {
            File f = new File(w.getName() + "/players/" + name + ".dat");
            if (!f.exists()) continue;
            return Bukkit.getOfflinePlayer((String)name);
        }
        return null;
    }

    public static Player[] getOnlinePlayers() {
        if (Defaults.DEBUG_VIRTUAL) {
            return VirtualPlayers.getOnlinePlayers();
        }
        return Bukkit.getOnlinePlayers();
    }

    public static void findOnlinePlayers(Set<String> names, Set<Player> foundplayers, Set<String> unfoundplayers) {
        Player[] online = ServerUtil.getOnlinePlayers();
        for (String name : names) {
            Player lastPlayer = null;
            for (Player player : online) {
                String playerName = player.getName();
                if (playerName.equalsIgnoreCase(name)) {
                    lastPlayer = player;
                    break;
                }
                if (playerName.toLowerCase().indexOf(name.toLowerCase(), 0) == -1) continue;
                if (lastPlayer != null) {
                    lastPlayer = null;
                    break;
                }
                lastPlayer = player;
            }
            if (lastPlayer != null) {
                foundplayers.add(lastPlayer);
                continue;
            }
            unfoundplayers.add(name);
        }
    }

    public static Version getBukkitVersion() {
        String pkg = Bukkit.getServer().getClass().getPackage().getName();
        String version = pkg.substring(pkg.lastIndexOf(46) + 1);
        if (version.equalsIgnoreCase("craftbukkit")) {
            return new Version("v1_4_5-");
        }
        return new Version(version);
    }
}

