/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util;

import java.text.SimpleDateFormat;
import mc.alk.arena.BattleArena;
import mc.alk.arena.controllers.messaging.MessageHandler;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class TimeUtil {
    static long lastCheck = 0L;

    public static void testClock() {
        final long start = System.currentTimeMillis();
        if (start - lastCheck < 10000L) {
            return;
        }
        lastCheck = start;
        int seconds = 2;
        double millis = 2000.0;
        int nTicks = 40;
        Runnable task = new Runnable(){

            public void run() {
                long now = System.currentTimeMillis();
                long elapsedTime = now - start;
                double mult = 2000.0 / (double)elapsedTime;
                if (mult < 0.2) {
                    mult = 0.2;
                }
            }
        };
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)BattleArena.getSelf(), task, 40L);
    }

    public static String convertMillisToString(long t) {
        return TimeUtil.convertSecondsToString(t / 1000L);
    }

    public static String convertSecondsToString(long t) {
        long s = t % 60L;
        long m = (t /= 60L) % 60L;
        long h = (t /= 60L) % 24L;
        long d = t /= 24L;
        boolean has = false;
        StringBuilder sb = new StringBuilder();
        if (d > 0L) {
            has = true;
            sb.append(MessageHandler.getSystemMessage("time_format", d, TimeUtil.dayOrDays(d)));
        }
        if (h > 0L) {
            sb.append(has ? " " : "").append(MessageHandler.getSystemMessage("time_format", h, TimeUtil.hourOrHours(h)));
            has = true;
        }
        if (m > 0L) {
            sb.append(has ? " " : "").append(MessageHandler.getSystemMessage("time_format", m, TimeUtil.minOrMins(m)));
            has = true;
        }
        if (s > 0L) {
            sb.append(has ? " " : "").append(MessageHandler.getSystemMessage("time_format", s, TimeUtil.secOrSecs(s)));
            has = true;
        }
        if (!has) {
            sb.append(MessageHandler.getSystemMessage("zero_time", new Object[0]));
        }
        return sb.toString();
    }

    public static String convertToString(long t) {
        return TimeUtil.convertSecondsToString(t /= 1000L);
    }

    public static String dayOrDays(long t) {
        return MessageHandler.getSystemMessage(t > 1L || t == 0L ? "days" : "day", new Object[0]);
    }

    public static String hourOrHours(long t) {
        return MessageHandler.getSystemMessage(t > 1L || t == 0L ? "hours" : "hour", new Object[0]);
    }

    public static String minOrMins(long t) {
        return MessageHandler.getSystemMessage(t > 1L || t == 0L ? "minutes" : "minute", new Object[0]);
    }

    public static String secOrSecs(long t) {
        return MessageHandler.getSystemMessage(t > 1L || t == 0L ? "seconds" : "second", new Object[0]);
    }

    public static String convertLongToDate(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd hh:mm");
        return sdf.format(time);
    }

    public static String convertLongToSimpleDate(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("hh:mm");
        return sdf.format(time);
    }

    public static String PorP(int size) {
        return size == 1 ? "person" : "people";
    }
}

