/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimingUtil {
    static List<TimingUtil> timers;
    Map<String, TimingStat> timings = new HashMap<String, TimingStat>();

    public static List<TimingUtil> getTimers() {
        return timers;
    }

    public static void resetTimers() {
        for (TimingUtil t : timers) {
            t.timings.clear();
        }
    }

    public TimingUtil() {
        if (timers == null) {
            timers = new ArrayList<TimingUtil>();
        }
        timers.add(this);
    }

    public void put(String key, TimingStat t) {
        this.timings.put(key, t);
    }

    public TimingStat getOrCreate(String key) {
        TimingStat t = this.timings.get(key);
        if (t == null) {
            t = new TimingStat();
            this.timings.put(key, t);
        }
        return t;
    }

    public Map<String, TimingStat> getTimings() {
        return this.timings;
    }

    public class TimingStat {
        public int count = 0;
        public long totalTime = 0L;

        public long getAverage() {
            return this.totalTime / (long)this.count;
        }
    }
}

