/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import mc.alk.arena.competition.match.Match;
import mc.alk.arena.objects.teams.ArenaTeam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VictoryUtil {
    static final Random rand = new Random();

    public static List<ArenaTeam> getLeaderByHighestKills(Match match) {
        List<ArenaTeam> teams = match.getTeams();
        List<ArenaTeam> victors = VictoryUtil.getLeaderByHighestKills(teams);
        if (victors.size() > 1) {
            victors = VictoryUtil.getLeaderByLeastDeaths(victors);
        }
        return victors;
    }

    public static List<ArenaTeam> getLeaderByHighestKills(List<ArenaTeam> teams) {
        int highest = Integer.MIN_VALUE;
        ArrayList<ArenaTeam> victors = new ArrayList<ArenaTeam>();
        for (ArenaTeam t : teams) {
            int nkills = t.getNKills();
            if (nkills == highest) {
                victors.add(t);
            }
            if (nkills <= highest) continue;
            victors.clear();
            highest = nkills;
            victors.add(t);
        }
        return victors;
    }

    public static List<ArenaTeam> getLeaderByLeastDeaths(List<ArenaTeam> teams) {
        int lowest = Integer.MAX_VALUE;
        ArrayList<ArenaTeam> result = new ArrayList<ArenaTeam>();
        for (ArenaTeam t : teams) {
            int ndeaths = t.getNDeaths();
            if (ndeaths == lowest) {
                result.add(t);
            }
            if (ndeaths >= lowest) continue;
            result.clear();
            lowest = ndeaths;
            result.add(t);
        }
        return result;
    }

    public static List<ArenaTeam> getRanksByHighestKills(List<ArenaTeam> teams) {
        ArrayList<ArenaTeam> ts = new ArrayList<ArenaTeam>(teams);
        Collections.sort(ts, new Comparator<ArenaTeam>(){

            @Override
            public int compare(ArenaTeam arg0, ArenaTeam arg1) {
                Integer k2;
                Integer k1 = arg0.getNKills();
                int c = k1.compareTo(k2 = Integer.valueOf(arg1.getNKills()));
                return c != 0 ? -c : new Integer(arg0.getNDeaths()).compareTo(arg1.getNDeaths());
            }
        });
        return ts;
    }

    public static TreeMap<Integer, Collection<ArenaTeam>> getRankingByHighestKills(List<ArenaTeam> teams) {
        TreeMap<Integer, Collection<ArenaTeam>> map = new TreeMap<Integer, Collection<ArenaTeam>>(Collections.reverseOrder());
        for (ArenaTeam t : teams) {
            Collection<ArenaTeam> col = map.get(t.getNKills());
            if (col == null) {
                col = new ArrayList<ArenaTeam>();
                map.put(t.getNKills(), col);
            }
            col.add(t);
        }
        return map;
    }
}

