/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util.compat.pre;

import java.lang.reflect.Method;
import java.util.UUID;
import mc.alk.arena.controllers.plugins.HeroesController;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.compat.IPlayerHelper;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class PlayerHelper
implements IPlayerHelper {
    Method getHealth;
    Method setHealth;
    Method getMaxHealth;
    Method getAmount;
    final Object[] blankArgs = new Object[0];

    public PlayerHelper() {
        try {
            this.setHealth = Player.class.getMethod("setHealth", Integer.TYPE);
            this.getHealth = Player.class.getMethod("getHealth", new Class[0]);
            this.getMaxHealth = Player.class.getMethod("getMaxHealth", new Class[0]);
            this.getAmount = EntityRegainHealthEvent.class.getMethod("getAmount", new Class[0]);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void setHealth(Player player, double health, boolean skipHeroes) {
        if (!skipHeroes && HeroesController.enabled()) {
            HeroesController.setHealth(player, health);
            return;
        }
        int oldHealth = (int)this.getHealth(player);
        if ((double)oldHealth > health) {
            EntityDamageEvent event = new EntityDamageEvent((Entity)player, EntityDamageEvent.DamageCause.CUSTOM, (int)((double)oldHealth - health));
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                player.setLastDamageCause(event);
                int dmg = (int)Math.max(0.0, (double)oldHealth - event.getDamage());
                this.setHealth(player, dmg);
            }
        } else if ((double)oldHealth < health) {
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((Entity)player, (int)(health - (double)oldHealth), EntityRegainHealthEvent.RegainReason.CUSTOM);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                Integer regen = Math.min(oldHealth + this.getAmount(event), (int)this.getMaxHealth(player));
                this.setHealth(player, regen);
            }
        }
    }

    public double getHealth(Player player) {
        try {
            return new Double(((Integer)this.getHealth.invoke((Object)player, this.blankArgs)).intValue());
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            return 20.0;
        }
    }

    public double getMaxHealth(Player player) {
        try {
            return new Double(((Integer)this.getMaxHealth.invoke((Object)player, this.blankArgs)).intValue());
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            return 20.0;
        }
    }

    public Object getScoreboard(Player player) {
        return null;
    }

    public void setScoreboard(Player player, Object scoreboard) {
    }

    public UUID getID(OfflinePlayer player) {
        return new UUID(0L, player.getName().hashCode());
    }

    public Integer getAmount(EntityRegainHealthEvent event) {
        try {
            return new Integer((Integer)this.getAmount.invoke((Object)event, this.blankArgs));
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            return null;
        }
    }

    public void setHealth(Player player, Integer health) {
        try {
            this.setHealth.invoke((Object)player, health);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }
}

