/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util.compat.v1_7_R3;

import java.util.UUID;
import mc.alk.arena.controllers.plugins.HeroesController;
import mc.alk.arena.util.compat.IPlayerHelper;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.scoreboard.Scoreboard;

public class PlayerHelper
implements IPlayerHelper {
    public void setHealth(Player player, double health, boolean skipHeroes) {
        if (!skipHeroes && HeroesController.enabled()) {
            HeroesController.setHealth(player, health);
            return;
        }
        double oldHealth = player.getHealth();
        if (oldHealth > health) {
            EntityDamageEvent event = new EntityDamageEvent((Entity)player, EntityDamageEvent.DamageCause.CUSTOM, oldHealth - health);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                player.setLastDamageCause(event);
                double dmg = Math.max(0.0, oldHealth - event.getDamage());
                player.setHealth(dmg);
            }
        } else if (oldHealth < health) {
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((Entity)player, health - oldHealth, EntityRegainHealthEvent.RegainReason.CUSTOM);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                double regen = Math.min(oldHealth + event.getAmount(), player.getMaxHealth());
                player.setHealth(regen);
            }
        }
    }

    public double getHealth(Player player) {
        return player.getHealth();
    }

    public double getMaxHealth(Player player) {
        return player.getMaxHealth();
    }

    public Object getScoreboard(Player player) {
        return player.getScoreboard();
    }

    public void setScoreboard(Player player, Object scoreboard) {
        player.setScoreboard((Scoreboard)scoreboard);
    }

    public UUID getID(OfflinePlayer player) {
        return player.getUniqueId();
    }
}

