/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util.plugins;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.classes.HeroClassManager;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.party.HeroParty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mc.alk.arena.BattleArena;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.objects.teams.CompositeTeam;
import mc.alk.arena.objects.teams.TeamFactory;
import mc.alk.arena.util.plugins.heroes.Heroes_1_5_2;
import mc.alk.arena.util.plugins.heroes.Heroes_pre1_5_2;
import mc.alk.mc.updater.Version;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class HeroesUtil {
    static Heroes heroes = null;
    static Map<ArenaTeam, HeroParty> parties = Collections.synchronizedMap(new HashMap());
    static HeroesUtil util = null;

    public abstract void setHeroPlayerHealth(Player var1, double var2);

    public abstract double getHeroHealth(Player var1);

    public abstract void setHeroHealthP(Player var1, double var2);

    public static boolean hasHeroClass(String name) {
        if (heroes == null) {
            return false;
        }
        HeroClassManager manager = heroes.getClassManager();
        return manager.getClass(name) != null;
    }

    public static void setHeroClass(Player player, String name) {
        HeroClassManager manager = heroes.getClassManager();
        HeroClass hc = manager.getClass(name);
        if (hc == null) {
            return;
        }
        Hero hero = HeroesUtil.getHero(player);
        if (hero == null) {
            return;
        }
        if (hero.getHeroClass().getName().equals(hc.getName())) {
            return;
        }
        hero.setHeroClass(hc, false);
    }

    public static void setHeroes(Plugin plugin) {
        heroes = (Heroes)plugin;
        Version v = new Version(heroes.getDescription().getVersion());
        util = v.compareTo("1.5.2") >= 0 ? new Heroes_1_5_2() : new Heroes_pre1_5_2();
    }

    public static String getHeroClassName(Player player) {
        Hero hero = HeroesUtil.getHero(player);
        if (hero == null) {
            return null;
        }
        HeroClass hc = hero.getHeroClass();
        return hc == null ? null : hc.getName();
    }

    public static int getLevel(Player player) {
        Hero hero = HeroesUtil.getHero(player);
        return hero == null ? -1 : hero.getLevel();
    }

    protected static Hero getHero(Player player) {
        CharacterManager cm = heroes.getCharacterManager();
        return cm.getHero(player);
    }

    public static boolean isInCombat(Player player) {
        Hero hero = HeroesUtil.getHero(player);
        return hero != null && hero.isInCombat();
    }

    public static void deEnchant(Player player) {
        Hero hero = HeroesUtil.getHero(player);
        if (hero == null) {
            return;
        }
        for (Effect effect : hero.getEffects()) {
            hero.removeEffect(effect);
        }
    }

    public static HeroParty createParty(ArenaTeam team, Hero hero) {
        HeroParty party = new HeroParty(hero, heroes);
        heroes.getPartyManager().addParty(party);
        parties.put(team, party);
        return party;
    }

    private static void removeOldParty(Hero hero, HeroParty newParty) {
        HeroParty party = hero.getParty();
        if (party == null || newParty != null && newParty == party) {
            return;
        }
        party.removeMember(hero);
        hero.setParty(null);
    }

    public static void removeTeam(ArenaTeam team) {
        HeroParty party = parties.remove(team);
        if (party != null) {
            heroes.getPartyManager().removeParty(party);
        }
    }

    public static HeroParty createTeam(ArenaTeam team) {
        HeroParty party = null;
        for (ArenaPlayer player : team.getPlayers()) {
            Hero hero = HeroesUtil.getHero(player.getPlayer());
            if (hero == null) continue;
            HeroesUtil.removeOldParty(hero, null);
            if (party == null) {
                party = HeroesUtil.createParty(team, hero);
            }
            party.addMember(hero);
            hero.setParty(party);
        }
        return party;
    }

    public static void addedToTeam(ArenaTeam team, Player player) {
        Hero hero;
        HeroParty party = parties.get(team);
        if (party == null) {
            party = HeroesUtil.createTeam(team);
        }
        if ((hero = HeroesUtil.getHero(player)) == null) {
            return;
        }
        HeroesUtil.removeOldParty(hero, party);
        if (party == null) {
            party = HeroesUtil.createParty(team, hero);
        }
        party.addMember(hero);
        hero.setParty(party);
    }

    public static void removedFromTeam(ArenaTeam team, Player player) {
        HeroParty party = parties.get(team);
        if (party == null) {
            return;
        }
        Hero hero = HeroesUtil.getHero(player);
        if (hero == null) {
            return;
        }
        HeroesUtil.removeOldParty(hero, null);
    }

    public static ArenaTeam getTeam(Player player) {
        Set members;
        Hero hero = HeroesUtil.getHero(player);
        if (hero == null) {
            return null;
        }
        HeroParty party = hero.getParty();
        if (party == null) {
            return null;
        }
        CompositeTeam t = TeamFactory.createCompositeTeam();
        Hero leader = party.getLeader();
        if (leader != null) {
            t.addPlayer(BattleArena.toArenaPlayer(leader.getPlayer()));
        }
        if ((members = party.getMembers()) != null) {
            for (Hero h : members) {
                t.addPlayer(BattleArena.toArenaPlayer(h.getPlayer()));
            }
        }
        return t.size() > 0 ? t : null;
    }

    public static Integer getMagicLevel(Player player) {
        Hero hero = HeroesUtil.getHero(player);
        return hero == null ? null : Integer.valueOf(hero.getMana());
    }

    public static void setMagicLevel(Player player, Integer val) {
        Hero hero = HeroesUtil.getHero(player);
        if (hero == null) {
            return;
        }
        hero.setMana(val.intValue());
    }

    public static void setMagicLevelP(Player player, Integer magic) {
        Hero hero = HeroesUtil.getHero(player);
        if (hero == null) {
            return;
        }
        double val = (double)hero.getMaxMana() * (double)magic.intValue() / 100.0;
        hero.setMana((int)val);
    }

    public static void setHealth(Player player, double health) {
        util.setHeroPlayerHealth(player, health);
    }

    public static void setHealthP(Player player, double health) {
        util.setHeroHealthP(player, health);
    }

    public static double getHealth(Player player) {
        return util.getHeroHealth(player);
    }
}

