/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util.plugins;

import mc.alk.arena.BattleArena;
import mc.alk.arena.objects.messaging.AnnouncementOptions;
import mc.alk.arena.util.Log;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultPermUtil {
    static Permission perm = null;

    public static boolean hasPermissions() {
        return perm != null;
    }

    public static boolean setPermission(Plugin plugin) {
        try {
            RegisteredServiceProvider provider = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
            if (provider != null && provider.getProvider() != null) {
                perm = (Permission)provider.getProvider();
            } else if (AnnouncementOptions.chatPlugin == null) {
                Log.info("[BattleArena] Vault Perms not detected");
                return false;
            }
        }
        catch (Error e) {
            Log.err(BattleArena.getPluginName() + " exception loading permissions through Vault");
            Log.printStackTrace(e);
            return false;
        }
        return true;
    }

    public static boolean giveAdminPerms(Player player, Boolean enable) {
        if (enable.booleanValue()) {
            return perm.playerAdd(player, "arena.admin");
        }
        return perm.playerRemove(player, "arena.admin");
    }

    public static boolean giveWorldGuardPerms(Player player, Boolean enable) {
        String[] perms;
        for (String p : perms = new String[]{"worldguard.region.wand", "worldguard.region.info.*", "worldguard.region.list", "worldguard.region.flag.regions.*", "worldguard.region.flag.flags.*", "worldguard.region.setpriority.*"}) {
            if (enable.booleanValue()) {
                perm.playerAdd(player, p);
                continue;
            }
            perm.playerRemove(player, p);
        }
        return true;
    }
}

