/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util.plugins;

import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitCommandSender;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.selections.Polygonal2DSelection;
import com.sk89q.worldedit.bukkit.selections.Selection;
import com.sk89q.worldedit.commands.SchematicCommands;
import com.sk89q.worldedit.data.DataException;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.schematic.SchematicFormat;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.domains.DefaultDomain;
import com.sk89q.worldguard.protection.databases.ProtectionDatabaseException;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedPolygonalRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import mc.alk.arena.objects.exceptions.RegionNotFound;
import mc.alk.arena.objects.regions.ArenaRegion;
import mc.alk.arena.objects.regions.WorldGuardRegion;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.plugins.WorldEditUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldGuardUtil {
    static WorldGuardPlugin wgp;
    static boolean hasWorldGuard;
    static Map<String, Set<String>> trackedRegions;

    public static boolean setWorldGuard(Plugin plugin) {
        wgp = (WorldGuardPlugin)plugin;
        hasWorldGuard = true;
        return WorldGuardUtil.hasWorldGuard();
    }

    public static boolean hasWorldGuard() {
        return WorldEditUtil.hasWorldEdit() && hasWorldGuard;
    }

    public static ProtectedRegion getRegion(String world, String id) {
        World w = Bukkit.getWorld((String)world);
        return WorldGuardUtil.getRegion(w, id);
    }

    public static ProtectedRegion getRegion(World w, String id) {
        if (w == null) {
            return null;
        }
        return wgp.getRegionManager(w).getRegion(id);
    }

    public static boolean hasRegion(ArenaRegion region) {
        return WorldGuardUtil.hasRegion(region.getWorldName(), region.getID());
    }

    public static boolean hasRegion(World world, String id) {
        RegionManager mgr = wgp.getGlobalRegionManager().get(world);
        return mgr.hasRegion(id);
    }

    public static boolean hasRegion(String world, String id) {
        World w = Bukkit.getWorld((String)world);
        if (w == null) {
            return false;
        }
        RegionManager mgr = wgp.getGlobalRegionManager().get(w);
        return mgr.hasRegion(id);
    }

    public static ProtectedRegion updateProtectedRegion(Player p, String id) throws Exception {
        return WorldGuardUtil.createRegion(p, id);
    }

    public static ProtectedRegion createProtectedRegion(Player p, String id) throws Exception {
        return WorldGuardUtil.createRegion(p, id);
    }

    private static ProtectedRegion createRegion(Player p, String id) throws ProtectionDatabaseException {
        ProtectedCuboidRegion region;
        Selection sel = WorldEditUtil.getSelection(p);
        World w = sel.getWorld();
        RegionManager mgr = wgp.getGlobalRegionManager().get(w);
        mgr.removeRegion(id);
        if (sel instanceof Polygonal2DSelection) {
            Polygonal2DSelection polySel = (Polygonal2DSelection)sel;
            int minY = polySel.getNativeMinimumPoint().getBlockY();
            int maxY = polySel.getNativeMaximumPoint().getBlockY();
            region = new ProtectedPolygonalRegion(id, polySel.getNativePoints(), minY, maxY);
        } else {
            region = new ProtectedCuboidRegion(id, sel.getNativeMinimumPoint().toBlockVector(), sel.getNativeMaximumPoint().toBlockVector());
        }
        region.setPriority(11);
        region.setFlag((Flag)DefaultFlag.PVP, (Object)StateFlag.State.ALLOW);
        wgp.getRegionManager(w).addRegion((ProtectedRegion)region);
        mgr.save();
        return region;
    }

    public static void clearRegion(WorldGuardRegion region) {
        WorldGuardUtil.clearRegion(region.getRegionWorld(), region.getID());
    }

    public static void clearRegion(String world, String id) {
        World w = Bukkit.getWorld((String)world);
        if (w == null) {
            return;
        }
        ProtectedRegion region = WorldGuardUtil.getRegion(w, id);
        if (region == null) {
            return;
        }
        for (Entity entity : w.getEntitiesByClasses(new Class[]{Item.class, Creature.class})) {
            Location l = entity.getLocation();
            if (!region.contains(l.getBlockX(), l.getBlockY(), l.getBlockZ())) continue;
            entity.remove();
        }
    }

    public static boolean isLeavingArea(Location from, Location to, ArenaRegion region) {
        return WorldGuardUtil.isLeavingArea(from, to, Bukkit.getWorld((String)region.getWorldName()), region.getID());
    }

    public static boolean isLeavingArea(Location from, Location to, World w, String id) {
        ProtectedRegion pr = WorldGuardUtil.getRegion(w, id);
        return pr != null && !pr.contains(to.getBlockX(), to.getBlockY(), to.getBlockZ()) && pr.contains(from.getBlockX(), from.getBlockY(), from.getBlockZ());
    }

    public static boolean setFlag(WorldGuardRegion region, String flag, boolean enable) {
        return WorldGuardUtil.setFlag(region.getRegionWorld(), region.getID(), flag, enable);
    }

    public static Flag<?> getWGFlag(String flagString) {
        for (Flag f : DefaultFlag.getFlags()) {
            if (!f.getName().equalsIgnoreCase(flagString)) continue;
            return f;
        }
        throw new IllegalStateException("Worldguard flag " + flagString + " not found");
    }

    public static StateFlag getStateFlag(String flagString) {
        for (Flag f : DefaultFlag.getFlags()) {
            if (!f.getName().equalsIgnoreCase(flagString) || !(f instanceof StateFlag)) continue;
            return (StateFlag)f;
        }
        throw new IllegalStateException("Worldguard flag " + flagString + " not found");
    }

    public static boolean setFlag(String worldName, String id, String flag, boolean enable) {
        World w = Bukkit.getWorld((String)worldName);
        if (w == null) {
            return false;
        }
        ProtectedRegion pr = WorldGuardUtil.getRegion(w, id);
        if (pr == null) {
            return false;
        }
        StateFlag f = WorldGuardUtil.getStateFlag(flag);
        StateFlag.State newState = enable ? StateFlag.State.ALLOW : StateFlag.State.DENY;
        StateFlag.State state = (StateFlag.State)pr.getFlag((Flag)f);
        if (state == null || state != newState) {
            pr.setFlag((Flag)f, (Object)newState);
        }
        return true;
    }

    public static boolean allowEntry(Player player, String regionWorld, String id) {
        World w = Bukkit.getWorld((String)regionWorld);
        if (w == null) {
            return false;
        }
        ProtectedRegion pr = WorldGuardUtil.getRegion(w, id);
        if (pr == null) {
            return false;
        }
        DefaultDomain dd = pr.getMembers();
        dd.addPlayer(player.getName());
        pr.setMembers(dd);
        return true;
    }

    public static boolean addMember(String playerName, WorldGuardRegion region) {
        return WorldGuardUtil.addMember(playerName, region.getRegionWorld(), region.getID());
    }

    public static boolean addMember(String playerName, String regionWorld, String id) {
        return WorldGuardUtil.changeMember(playerName, regionWorld, id, true);
    }

    public static boolean removeMember(String playerName, WorldGuardRegion region) {
        return WorldGuardUtil.removeMember(playerName, region.getRegionWorld(), region.getID());
    }

    public static boolean removeMember(String playerName, String regionWorld, String id) {
        return WorldGuardUtil.changeMember(playerName, regionWorld, id, false);
    }

    private static boolean changeMember(String name, String regionWorld, String id, boolean add) {
        World w = Bukkit.getWorld((String)regionWorld);
        if (w == null) {
            return false;
        }
        ProtectedRegion pr = WorldGuardUtil.getRegion(w, id);
        if (pr == null) {
            return false;
        }
        DefaultDomain dd = pr.getMembers();
        if (add) {
            dd.addPlayer(name);
        } else {
            dd.removePlayer(name);
        }
        pr.setMembers(dd);
        return true;
    }

    public static void deleteRegion(String worldName, String id) {
        World w = Bukkit.getWorld((String)worldName);
        if (w == null) {
            return;
        }
        RegionManager mgr = wgp.getRegionManager(w);
        if (mgr == null) {
            return;
        }
        mgr.removeRegion(id);
    }

    public static boolean pasteSchematic(CommandSender consoleSender, String worldName, String id) {
        World w = Bukkit.getWorld((String)worldName);
        if (w == null) {
            return false;
        }
        ProtectedRegion pr = WorldGuardUtil.getRegion(w, id);
        return pr != null && WorldGuardUtil.pasteSchematic(consoleSender, pr, id, w);
    }

    public static boolean pasteSchematic(WorldGuardRegion region) {
        return WorldGuardUtil.pasteSchematic(region.getRegionWorld(), region.getID());
    }

    public static boolean pasteSchematic(String worldName, String id) {
        return WorldGuardUtil.pasteSchematic((CommandSender)Bukkit.getConsoleSender(), worldName, id);
    }

    public static boolean pasteSchematic(CommandSender sender, ProtectedRegion pr, String schematic, World world) {
        String[] args = new String[]{"load", schematic};
        WorldEditPlugin wep = WorldEditUtil.getWorldEditPlugin();
        WorldEdit we = wep.getWorldEdit();
        ConsolePlayer bcs = new ConsolePlayer(wep, wep.getServerInterface(), sender, world);
        LocalSession session = wep.getWorldEdit().getSession((LocalPlayer)bcs);
        session.setUseInventory(false);
        EditSession editSession = session.createEditSession((LocalPlayer)bcs);
        Vector pos = new Vector((Vector)pr.getMinimumPoint());
        try {
            CommandContext cc = new CommandContext(args);
            return WorldGuardUtil.loadAndPaste(cc, we, session, (LocalPlayer)bcs, editSession, pos);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            return false;
        }
    }

    public static boolean saveSchematic(Player p, String schematicName) {
        WorldEditPlugin wep = WorldEditUtil.getWorldEditPlugin();
        LocalSession session = wep.getSession(p);
        BukkitPlayer lPlayer = wep.wrapPlayer(p);
        EditSession editSession = session.createEditSession((LocalPlayer)lPlayer);
        try {
            Region region = session.getSelection(lPlayer.getWorld());
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            CuboidClipboard clipboard = new CuboidClipboard(max.subtract(min).add(new Vector(1, 1, 1)), min, new Vector(0, 0, 0));
            clipboard.copy(editSession);
            session.setClipboard(clipboard);
            SchematicCommands sc = new SchematicCommands(wep.getWorldEdit());
            String[] args2 = new String[]{"save", "mcedit", schematicName};
            CommandContext cc = new CommandContext(args2);
            sc.save(cc, session, (LocalPlayer)lPlayer, editSession);
            return true;
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            return false;
        }
    }

    public static boolean loadAndPaste(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession, Vector pos) {
        LocalConfiguration config = we.getConfiguration();
        String filename = args.getString(0);
        File dir = we.getWorkingDirectoryFile(config.saveDir);
        try {
            File f = we.getSafeOpenFile(player, dir, filename, "schematic", new String[]{"schematic"});
            String filePath = f.getCanonicalPath();
            String dirPath = dir.getCanonicalPath();
            if (!filePath.substring(0, dirPath.length()).equals(dirPath)) {
                WorldGuardUtil.printError(player, "Schematic could not read or it does not exist.");
                return false;
            }
            SchematicFormat format = SchematicFormat.getFormat((File)f);
            if (format == null) {
                WorldGuardUtil.printError(player, "Unknown schematic format for file" + f);
                return false;
            }
            if (!filePath.substring(0, dirPath.length()).equals(dirPath)) {
                WorldGuardUtil.printError(player, "Schematic could not read or it does not exist.");
            } else {
                session.setClipboard(format.load(f));
            }
            session.getClipboard().paste(editSession, pos, false, true);
        }
        catch (DataException e) {
            WorldGuardUtil.printError(player, "Load error: " + e.getMessage());
        }
        catch (IOException e) {
            WorldGuardUtil.printError(player, "Schematic could not read or it does not exist: " + e.getMessage());
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            WorldGuardUtil.printError(player, "Error : " + e.getMessage());
        }
        return true;
    }

    private static void printError(LocalPlayer player, String msg) {
        if (player == null) {
            Log.err(msg);
        } else {
            player.printError(msg);
        }
    }

    public static boolean contains(Location location, WorldGuardRegion region) {
        ProtectedRegion pr = WorldGuardUtil.getRegion(region.getWorldName(), region.getID());
        return pr != null && pr.contains(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static boolean hasPlayer(String playerName, WorldGuardRegion region) {
        ProtectedRegion pr = WorldGuardUtil.getRegion(region.getWorldName(), region.getID());
        if (pr == null) {
            return true;
        }
        DefaultDomain dd = pr.getMembers();
        if (dd.contains(playerName)) {
            return true;
        }
        dd = pr.getOwners();
        return dd.contains(playerName);
    }

    public static boolean trackRegion(ArenaRegion region) throws RegionNotFound {
        return WorldGuardUtil.trackRegion(region.getWorldName(), region.getID());
    }

    public static boolean trackRegion(String world, String id) throws RegionNotFound {
        ProtectedRegion pr = WorldGuardUtil.getRegion(world, id);
        if (pr == null) {
            throw new RegionNotFound("The region " + id + " not found in world " + world);
        }
        Set<String> regions = trackedRegions.get(world);
        if (regions == null) {
            regions = new CopyOnWriteArraySet<String>();
            trackedRegions.put(world, regions);
        }
        return regions.add(id);
    }

    public static int regionCount() {
        if (trackedRegions.isEmpty()) {
            return 0;
        }
        int count = 0;
        for (String world : trackedRegions.keySet()) {
            Set<String> sets = trackedRegions.get(world);
            if (sets == null) continue;
            count += sets.size();
        }
        return count;
    }

    public static WorldGuardRegion getContainingRegion(Location location) {
        for (String world : trackedRegions.keySet()) {
            World w = Bukkit.getWorld((String)world);
            if (w == null || location.getWorld().getUID() != w.getUID()) continue;
            for (String id : trackedRegions.get(world)) {
                ProtectedRegion pr = WorldGuardUtil.getRegion(w, id);
                if (pr == null || !pr.contains(location.getBlockX(), location.getBlockY(), location.getBlockZ())) continue;
                return new WorldGuardRegion(world, id);
            }
        }
        return null;
    }

    static {
        hasWorldGuard = false;
        trackedRegions = new ConcurrentHashMap<String, Set<String>>();
    }

    public static class ConsolePlayer
    extends BukkitCommandSender {
        LocalWorld world;

        public ConsolePlayer(WorldEditPlugin plugin, ServerInterface server, CommandSender sender, World w) {
            super(plugin, server, sender);
            this.world = BukkitUtil.getLocalWorld((World)w);
        }

        public boolean isPlayer() {
            return true;
        }

        public LocalWorld getWorld() {
            return this.world;
        }
    }
}

