/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.mc.battleplugins.api;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BattlePluginsAPI {
    public static final long version = 1L;
    static final String PROTOCOL = "http";
    protected static String HOST = "battleplugins.com";
    static final String USER_AGENT = "BattlePluginsAPI/v1.0";
    protected String apiKey = "";
    final AtomicBoolean sendStats = new AtomicBoolean(true);
    Integer timer;
    final Map<String, String> pairs = new TreeMap<String, String>();
    final List<Plugin> plugins = new ArrayList<Plugin>();
    protected boolean debug;

    public BattlePluginsAPI() {
    }

    public BattlePluginsAPI(Plugin plugin) {
        this.plugins.add(plugin);
        try {
            if (this.getConfig().getBoolean("SendStatistics", false)) {
                this.sendStats.set(true);
                this.scheduleSendStats(plugin);
            } else {
                this.sendStats.set(false);
            }
        }
        catch (IOException e) {
            plugin.getLogger().severe("BattlePluginsAPI was not able to load. Message: " + e.getMessage());
            plugin.getLogger().log(Level.SEVERE, null, e);
            this.sendStats.set(false);
        }
    }

    private static String urlEncode(String text) throws UnsupportedEncodingException {
        return URLEncoder.encode(text, "UTF-8");
    }

    public String pasteFile(String title, String file) throws IOException {
        FileConfiguration c = this.getConfig();
        this.apiKey = c.getString("API-Key", null);
        if (this.apiKey == null) {
            throw new IOException("API Key was not found. You need to register before sending pastes");
        }
        File f = new File(file);
        this.addPair("title", title);
        this.addPair("content", BattlePluginsAPI.toString(f.getPath()));
        Map<String, Object> result = this.post(new URL("http://" + HOST + "/api/web/paste/create"));
        if (result.containsKey("id")) {
            return "http://" + HOST + "/paste/" + result.get("id");
        }
        return null;
    }

    public void sendStatistics(Plugin plugin) throws IOException {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        plugins.add(plugin);
        this.sendStatistics(plugins);
    }

    public void sendStatistics(List<Plugin> plugins) throws IOException {
        for (Plugin plugin : plugins) {
            this.addPluginInfo(plugin);
        }
        this.addServerInfo();
        this.addSystemInfo();
        this.post(new URL("http://" + HOST + "/statistics/set"));
    }

    public void addPair(String key, String value) throws UnsupportedEncodingException {
        this.pairs.put(key, BattlePluginsAPI.urlEncode(value));
    }

    public void addZippedPair(String key, String value) throws IOException {
        this.pairs.put(key, this.gzip(value));
    }

    public void addPluginInfo(Plugin plugin) throws UnsupportedEncodingException {
        PluginDescriptionFile d = plugin.getDescription();
        this.addPair("p" + d.getName(), d.getVersion());
    }

    public void addServerInfo() throws UnsupportedEncodingException {
        this.addPair("bServerName", Bukkit.getServerName());
        this.addPair("bVersion", Bukkit.getVersion());
        this.addPair("bOnlineMode", String.valueOf(Bukkit.getServer().getOnlineMode()));
        this.addPair("bPlayersOnline", String.valueOf(Bukkit.getServer().getOnlinePlayers().length));
    }

    public void addSystemInfo() throws UnsupportedEncodingException {
        this.addPair("osArch", System.getProperty("os.arch"));
        this.addPair("osName", System.getProperty("os.name"));
        this.addPair("osVersion", System.getProperty("os.version"));
        this.addPair("jVersion", System.getProperty("java.version"));
        this.addPair("nCores", String.valueOf(Runtime.getRuntime().availableProcessors()));
    }

    public List<String> get(URL baseUrl) throws IOException {
        String line;
        URL url = new URL(baseUrl.getProtocol() + "://" + baseUrl.getHost() + baseUrl.getPath() + "?" + this.toString(this.pairs));
        if (this.debug) {
            System.out.println(url);
        }
        URLConnection connection = url.openConnection(Proxy.NO_PROXY);
        connection.addRequestProperty("GET", "/api/web/blog/all HTTP/1.1");
        connection.addRequestProperty("Host", HOST);
        connection.addRequestProperty("X-API-Key", this.apiKey);
        connection.addRequestProperty("User-Agent", USER_AGENT);
        connection.setDoOutput(true);
        OutputStream os = connection.getOutputStream();
        os.flush();
        BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        ArrayList<String> response = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            response.add(line);
        }
        os.close();
        br.close();
        return response;
    }

    public Map<String, Object> post(URL url) throws IOException {
        String line;
        URLConnection connection = url.openConnection(Proxy.NO_PROXY);
        if (this.debug) {
            System.out.println(url + "?" + this.toString(this.pairs));
        }
        byte[] data = this.toString(this.pairs).getBytes();
        connection.addRequestProperty("POST", "/api/web/blog/all HTTP/1.1");
        connection.addRequestProperty("Host", HOST);
        connection.addRequestProperty("X-API-Key", this.apiKey);
        connection.addRequestProperty("User-Agent", USER_AGENT);
        connection.setRequestProperty("Content-length", String.valueOf(data.length));
        connection.setDoOutput(true);
        OutputStream os = connection.getOutputStream();
        os.write(data);
        os.flush();
        BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        os.close();
        br.close();
        return this.stringToMap(sb.toString());
    }

    String gzip(String str) throws IOException {
        GZIPOutputStream out = new GZIPOutputStream(new ByteArrayOutputStream());
        out.write(str.getBytes());
        out.close();
        return out.toString();
    }

    String toString(Map<String, String> pairs) throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> e : pairs.entrySet()) {
            if (!first) {
                sb.append("&");
            } else {
                first = false;
            }
            sb.append(e.getKey()).append("=").append(e.getValue());
        }
        return sb.toString();
    }

    Map<String, Object> stringToMap(String str) {
        String[] kvs;
        HashMap<String, Object> map = new HashMap<String, Object>();
        int f = str.indexOf(123);
        int l = str.lastIndexOf(125);
        if (f == -1 || l == -1 || f >= l || str.length() < 2) {
            return map;
        }
        for (String kv : kvs = str.substring(f + 1, l).split(",")) {
            String[] split = kv.replace('\"', ' ').split(":");
            map.put(split[0].trim(), split[1].trim());
        }
        return map;
    }

    public String toString() {
        return "[BattlePluginsAPI v1]";
    }

    public File getConfigurationFile() throws IOException {
        File pluginFolder = Bukkit.getServer().getUpdateFolderFile().getParentFile();
        File f = new File(pluginFolder, "BattlePluginsAPI");
        if (!f.exists() && !f.mkdirs()) {
            throw new IOException("Couldn't create config directory");
        }
        if (!(f = new File(f, "config.yml")).exists() && f.createNewFile() && !f.exists()) {
            throw new IOException("Couldn't create config file");
        }
        return f;
    }

    public FileConfiguration getConfig() throws IOException {
        File f = this.getConfigurationFile();
        YamlConfiguration c = YamlConfiguration.loadConfiguration((File)f);
        if (c.get("API-Key", null) == null || c.get("SendStatistics", null) == null) {
            c.options().header("Configuration file for BattlePluginsAPI. http://battleplugins.com\nAllows plugins using BattlePluginsAPI to interface with the website\nAPI-Key : unique id for server authentication\nSendStatistics : set to false to not send statistics");
            c.addDefault("API-Key", (Object)"");
            c.addDefault("SendStatistics", (Object)true);
            c.options().copyDefaults(true);
            c.save(f);
        }
        return c;
    }

    public String getAPIKey() {
        try {
            FileConfiguration c = this.getConfig();
            return c.getString("API-Key");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setAPIKey(String newKey) {
        try {
            FileConfiguration c = this.getConfig();
            c.set("API-Key", (Object)newKey);
            c.save(this.getConfigurationFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void scheduleSendStats(final List<Plugin> plugins) {
        if (!this.sendStats.get() || plugins.isEmpty()) {
            return;
        }
        if (this.timer != null) {
            Bukkit.getScheduler().cancelTask(this.timer.intValue());
        }
        this.timer = Bukkit.getScheduler().scheduleAsyncRepeatingTask(plugins.iterator().next(), new Runnable(){

            public void run() {
                if (!BattlePluginsAPI.this.sendStats.get()) {
                    if (BattlePluginsAPI.this.timer != null) {
                        Bukkit.getScheduler().cancelTask(BattlePluginsAPI.this.timer.intValue());
                        BattlePluginsAPI.this.timer = null;
                    }
                } else {
                    try {
                        BattlePluginsAPI.this.sendStatistics(plugins);
                    }
                    catch (UnknownHostException e) {
                    }
                    catch (InterruptedIOException e) {
                        Bukkit.getLogger().warning(e.getMessage());
                        BattlePluginsAPI.this.sendStats.set(false);
                    }
                    catch (SocketException e) {
                        if (e.getMessage() == null || !e.getMessage().contains("unreachable")) {
                            e.printStackTrace();
                            BattlePluginsAPI.this.sendStats.set(false);
                        }
                    }
                    catch (IOException e) {
                        Bukkit.getLogger().warning(e.getMessage());
                        BattlePluginsAPI.this.sendStats.set(false);
                    }
                }
            }
        }, (long)(1200 + new Random().nextInt(2400)), 18000L);
    }

    public void scheduleSendStats(Plugin plugin) {
        this.plugins.add(plugin);
        if (this.timer != null) {
            Bukkit.getScheduler().cancelTask(this.timer.intValue());
            this.timer = null;
        }
        this.scheduleSendStats(this.plugins);
    }

    public void stopSendingStatistics() throws IOException {
        this.setSending(false);
        if (this.timer != null) {
            Bukkit.getScheduler().cancelTask(this.timer.intValue());
            this.timer = null;
        }
    }

    public void stopSendingStatistics(Plugin plugin) throws IOException {
        if (this.plugins.remove(plugin)) {
            this.scheduleSendStats(this.plugins);
        }
    }

    public void startSendingStatistics(Plugin plugin) throws IOException {
        this.setSending(true);
        this.scheduleSendStats(plugin);
    }

    private void setSending(boolean send) throws IOException {
        this.sendStats.set(send);
        FileConfiguration config = this.getConfig();
        if (config.getBoolean("SendStatistics", !send)) {
            config.set("SendStatistics", (Object)send);
            config.save(this.getConfigurationFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toString(String path) throws IOException {
        FileInputStream stream = new FileInputStream(new File(path));
        try {
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            String string = Charset.defaultCharset().decode(bb).toString();
            return string;
        }
        finally {
            stream.close();
        }
    }
}

