/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.mc.updater;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import mc.alk.mc.updater.Version;

public class FileUpdater {
    File oldFile;
    File backupDir;
    Version updateVersion;
    Version oldVersion;
    HashMap<String, Update> updates = new HashMap();
    HashMap<String, String> replaces = new HashMap();

    public FileUpdater(File oldFile, File backupDir, Version newVersion, Version oldVersion) {
        this.oldFile = oldFile.getAbsoluteFile();
        this.backupDir = backupDir.getAbsoluteFile();
        this.updateVersion = newVersion;
        this.oldVersion = oldVersion;
    }

    public void delete(String str) {
        this.updates.put(str, new Update(str, UpdateType.DELETE, SearchType.MATCHES, ""));
    }

    public void addAfter(String str, String ... strings) {
        this.updates.put(str, new Update(str, UpdateType.ADDAFTER, SearchType.MATCHES, strings));
    }

    public void addBefore(String str, String ... strings) {
        this.updates.put(str, new Update(str, UpdateType.ADDBEFORE, SearchType.MATCHES, strings));
    }

    public void replace(String str, String ... strings) {
        this.updates.put(str, new Update(str, UpdateType.REPLACE, SearchType.MATCHES, strings));
    }

    public void deleteAllFrom(String str) {
        this.updates.put(str, new Update(str, UpdateType.DELETEALLFROM, SearchType.MATCHES, ""));
    }

    public void replaceAll(String string, String string2) {
        this.replaces.put(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Version update() throws IOException {
        BufferedWriter fw;
        File tempFile;
        BufferedReader br;
        System.out.println("[Plugin Updater] updating " + this.oldFile.getName() + " from " + this.oldVersion + " to " + this.updateVersion);
        System.out.println("[Plugin Updater] old version backup inside of " + this.backupDir.getAbsolutePath());
        try {
            br = new BufferedReader(new FileReader(this.oldFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        try {
            tempFile = new File(this.backupDir + "/temp-" + new Random().nextInt() + ".yml");
            fw = new BufferedWriter(new FileWriter(tempFile));
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                br.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            return null;
        }
        boolean quit = false;
        String line = null;
        try {
            while ((line = br.readLine()) != null && !quit) {
                boolean foundMatch = false;
                block28: for (Map.Entry<String, Update> entry : this.updates.entrySet()) {
                    Update up = entry.getValue();
                    switch (up.searchType) {
                        case MATCHES: {
                            if (line.matches(up.search)) break;
                            continue block28;
                        }
                        case CONTAINS: {
                            if (line.contains(up.search)) break;
                            continue block28;
                        }
                    }
                    foundMatch = true;
                    if (up.type == UpdateType.DELETEALLFROM) {
                        quit = true;
                        break;
                    }
                    if (up.type == UpdateType.ADDAFTER) {
                        fw.write(line + "\n");
                    }
                    if (up.type != UpdateType.DELETE) {
                        for (String update : up.updates) {
                            fw.write(update + "\n");
                        }
                    }
                    if (up.type != UpdateType.ADDBEFORE) break;
                    fw.write(line + "\n");
                    break;
                }
                if (foundMatch) continue;
                for (Map.Entry<String, Object> entry : this.replaces.entrySet()) {
                    line = line.replaceAll(entry.getKey(), (String)entry.getValue());
                }
                fw.write(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (Exception e) {}
            try {
                fw.close();
            }
            catch (Exception e) {}
        }
        String nameWithoutExt = this.oldFile.getName().replaceFirst("[.][^.]+$", "");
        String ext = this.oldFile.getName().substring(nameWithoutExt.length() + 1);
        if (ext.isEmpty()) {
            ext = ".bk";
        }
        this.copy(this.oldFile, new File(this.backupDir + "/" + nameWithoutExt + "." + this.oldVersion + "." + ext));
        return FileUpdater.renameTo(tempFile, this.oldFile) ? this.updateVersion : null;
    }

    public static boolean renameTo(File file1, File file2) throws IOException {
        if (!file1.exists()) {
            throw new IOException(file1.getAbsolutePath() + " does not exist");
        }
        if (FileUpdater.isWindows()) {
            File temp = new File(file2.getAbsoluteFile() + "." + new Random().nextInt() + ".backup");
            if (temp.exists()) {
                temp.delete();
            }
            if (file2.exists()) {
                file2.renameTo(temp);
                file2.delete();
            }
            if (!file1.renameTo(file2)) {
                throw new IOException(temp.getAbsolutePath() + " could not be renamed to " + file2.getAbsolutePath());
            }
            temp.delete();
        } else if (!file1.renameTo(file2)) {
            throw new IOException(file1.getAbsolutePath() + " could not be renamed to " + file2.getAbsolutePath());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(File file1, File file2) {
        FileInputStream inputStream = null;
        OutputStream out = null;
        try {
            int len;
            if (file2.exists()) {
                file2.delete();
            }
            inputStream = new FileInputStream(file1);
            out = new FileOutputStream(file2);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)inputStream).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (Exception e) {}
            try {
                ((InputStream)inputStream).close();
            }
            catch (Exception e) {}
        }
    }

    public static void deleteIfExists(File file) {
        if (file.exists()) {
            file.delete();
        }
    }

    public static void makeIfNotExists(File file) {
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public static void moveIfExists(File file, File file2) {
        if (file.exists()) {
            try {
                FileUpdater.renameTo(file, file2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            FileUpdater.deleteIfExists(file);
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toUpperCase().contains("WINDOWS");
    }

    public static class Update {
        public final UpdateType type;
        public final String search;
        public final String[] updates;
        public final SearchType searchType;

        public Update(String search, UpdateType type, SearchType searchType, String ... strings) {
            this.type = type;
            this.search = search;
            this.updates = strings;
            this.searchType = searchType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpdateType {
        ADDAFTER,
        REPLACE,
        DELETE,
        DELETEALLFROM,
        ADDBEFORE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchType {
        CONTAINS,
        MATCHES;

    }
}

