/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.mc.updater;

import java.io.File;
import java.util.HashSet;
import mc.alk.mc.updater.Updater;
import mc.alk.mc.updater.Version;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class PluginUpdater {
    public static String getNameAndVersion(Plugin plugin) {
        return plugin.getDescription().getName() + "_v" + plugin.getDescription().getVersion();
    }

    public static void update(final Plugin plugin, final int bukkitId, final File file, final UpdateOption updateOption, final AnnounceUpdateOption announceOption) {
        if (updateOption == null || announceOption == null || updateOption == UpdateOption.NONE && announceOption == AnnounceUpdateOption.NONE) {
            return;
        }
        Thread t = new Thread(new Runnable(){

            public void run() {
                UpdateOption remoteReleaseType;
                UpdateOption update = updateOption;
                Updater up = new Updater(plugin, bukkitId, file, Updater.UpdateType.NO_DOWNLOAD, false);
                String failedMessage = null;
                switch (up.getResult()) {
                    case DISABLED: {
                        update = UpdateOption.NONE;
                    }
                    case SUCCESS: 
                    case UPDATE_AVAILABLE: 
                    case FAIL_NOVERSION: 
                    case NO_UPDATE: {
                        break;
                    }
                    case FAIL_DOWNLOAD: {
                        break;
                    }
                    case FAIL_DBO: {
                        failedMessage = "Couldn't connect to bukkit website";
                        break;
                    }
                    case FAIL_BADID: {
                        failedMessage = "The id provided was invalid or doesn't exist on DBO";
                        break;
                    }
                    case FAIL_APIKEY: {
                        failedMessage = "You have set a bad API key in the configuration";
                    }
                }
                if (failedMessage != null) {
                    PluginUpdater.err("&4[" + PluginUpdater.getNameAndVersion(plugin) + "] &c" + failedMessage);
                    return;
                }
                Version curVersion = new Version(plugin.getDescription().getVersion());
                String name = up.getLatestName();
                String delim = "^v|[\\s_-]v";
                UpdateOption updateOption2 = remoteReleaseType = up.getLatestType() != null ? UpdateOption.fromString(up.getLatestType().name()) : null;
                if (remoteReleaseType == null || name == null || name.split(delim).length != 2) {
                    PluginUpdater.err("&4[" + PluginUpdater.getNameAndVersion(plugin) + "] &ccan't find a version for the plugin result was &f" + (Object)((Object)up.getResult()) + " &creleaseType: " + (Object)((Object)up.getLatestType()));
                    return;
                }
                String strv = name.split(delim)[1];
                Version remoteVersion = new Version(strv);
                if (curVersion.compareTo(remoteVersion) < 0) {
                    if (update.ordinal() >= remoteReleaseType.ordinal()) {
                        PluginUpdater.info("&2[" + PluginUpdater.getNameAndVersion(plugin) + "] &ebeginning download of newer " + up.getLatestType().name() + "version &f" + remoteVersion);
                        up = new Updater(plugin, bukkitId, file, Updater.UpdateType.DEFAULT, false);
                        if (up.getResult() == Updater.UpdateResult.SUCCESS) {
                            PluginUpdater.info("&2[" + PluginUpdater.getNameAndVersion(plugin) + "] &edownloaded &f" + up.getLatestType().name() + " &eversion &f" + up.getLatestName().split(delim)[1]);
                        }
                    } else if (announceOption != AnnounceUpdateOption.NONE) {
                        String[] announce;
                        for (String msg : announce = new String[]{PluginUpdater.colorChat("&2[" + PluginUpdater.getNameAndVersion(plugin) + "] &ehas a newer &f" + up.getLatestType().name() + " &eversion &f" + remoteVersion), PluginUpdater.colorChat("&2[" + PluginUpdater.getNameAndVersion(plugin) + "]&5 " + up.getLatestFileLink())}) {
                            PluginUpdater.info(msg);
                        }
                        if (announceOption == AnnounceUpdateOption.OPS) {
                            new AnnounceOpListener(announce, plugin);
                        }
                    }
                }
            }
        });
        t.start();
    }

    public static String colorChat(String msg) {
        return msg.replace('&', '\u00a7');
    }

    public static void info(String msg) {
        try {
            Bukkit.getConsoleSender().sendMessage(PluginUpdater.colorChat(msg));
        }
        catch (Exception e) {
            System.out.println(PluginUpdater.colorChat(msg));
        }
    }

    public static void warn(String msg) {
        try {
            Bukkit.getConsoleSender().sendMessage(PluginUpdater.colorChat(msg));
        }
        catch (Exception e) {
            System.out.println(PluginUpdater.colorChat(msg));
        }
    }

    public static void err(String msg) {
        try {
            Bukkit.getConsoleSender().sendMessage(PluginUpdater.colorChat(msg));
        }
        catch (Exception e) {
            System.err.println(PluginUpdater.colorChat(msg));
        }
    }

    static class AnnounceOpListener
    implements Listener {
        final String[] announce;
        HashSet<String> alreadyAnnounced = new HashSet();

        AnnounceOpListener(String[] announce, Plugin plugin) {
            this.announce = announce;
            Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
        }

        public void onPlayerJoinEvent(PlayerJoinEvent event) {
            if (event.getPlayer().isOp() && !this.alreadyAnnounced.contains(event.getPlayer().getName())) {
                for (String s : this.announce) {
                    event.getPlayer().sendMessage(s);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AnnounceUpdateOption {
        NONE,
        CONSOLE,
        OPS;


        public static AnnounceUpdateOption fromString(String name) {
            try {
                return AnnounceUpdateOption.valueOf(name.toUpperCase());
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpdateOption {
        NONE,
        RELEASE,
        BETA,
        ALL;


        public static UpdateOption fromString(String name) {
            try {
                return UpdateOption.valueOf(name.toUpperCase());
            }
            catch (Exception e) {
                if (name.equalsIgnoreCase("ALPHA")) {
                    return ALL;
                }
                return null;
            }
        }
    }
}

