/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.scoreboardapi;

import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseExecutor
implements CommandExecutor {
    public static final String version = "2.0.1";
    static final boolean DEBUG = false;
    private HashMap<String, TreeMap<Integer, MethodWrapper>> methods = new HashMap();
    private HashMap<String, Map<String, TreeMap<Integer, MethodWrapper>>> subCmdMethods = new HashMap();
    protected PriorityQueue<MethodWrapper> usage = new PriorityQueue<MethodWrapper>(2, new Comparator<MethodWrapper>(){

        @Override
        public int compare(MethodWrapper mw1, MethodWrapper mw2) {
            MCCommand cmd1 = mw1.getCommand();
            MCCommand cmd2 = mw2.getCommand();
            int c = new Float(mw1.getHelpOrder()).compareTo(Float.valueOf(mw2.getHelpOrder()));
            if (c != 0) {
                return c;
            }
            c = new Integer(cmd1.order()).compareTo(cmd2.order());
            return c != 0 ? c : new Integer(cmd1.hashCode()).compareTo(cmd2.hashCode());
        }
    });
    static final String DEFAULT_CMD = "_dcmd_";
    public static final String ONLY_INGAME = ChatColor.RED + "You need to be in game to use this command";
    static final int LINES_PER_PAGE = 8;

    protected void showHelp(CommandSender sender, Command command) {
        this.showHelp(sender, command, null);
    }

    protected void showHelp(CommandSender sender, Command command, String[] args) {
        this.help(sender, command, args);
    }

    protected BaseExecutor() {
        this.addMethods(this, this.getClass().getMethods());
    }

    protected boolean validCommandSenderClass(Class<?> clazz) {
        return clazz != CommandSender.class || clazz != Player.class;
    }

    public void addMethods(Object obj, Method[] methodArray) {
        for (Method method : methodArray) {
            MCCommand mc = method.getAnnotation(MCCommand.class);
            if (mc == null) continue;
            Class<?>[] types = method.getParameterTypes();
            if (types.length == 0 || !this.validCommandSenderClass(types[0])) {
                System.err.println("MCCommands must start with a CommandSender,Player, or ArenaPlayer");
                continue;
            }
            if (mc.cmds().length == 0) {
                this.addMethod(obj, method, mc, DEFAULT_CMD);
                continue;
            }
            for (String cmd : mc.cmds()) {
                this.addMethod(obj, method, mc, cmd.toLowerCase());
            }
        }
    }

    private void addMethod(Object obj, Method method, MCCommand mc, String cmd) {
        int ml = method.getParameterTypes().length;
        if (mc.subCmds().length == 0) {
            TreeMap<Integer, MethodWrapper> mthds = this.methods.get(cmd);
            if (mthds == null) {
                mthds = new TreeMap();
            }
            int order = (mc.order() != -1 ? mc.order() * 100000 : Integer.MAX_VALUE) - ml * 100 - mthds.size();
            MethodWrapper mw = new MethodWrapper(obj, method);
            mthds.put(order, mw);
            this.methods.put(cmd, mthds);
            this.addUsage(mw, mc);
        } else {
            Map<String, TreeMap<Integer, MethodWrapper>> basemthds = this.subCmdMethods.get(cmd);
            if (basemthds == null) {
                basemthds = new HashMap<String, TreeMap<Integer, MethodWrapper>>();
                this.subCmdMethods.put(cmd, basemthds);
            }
            for (String subcmd : mc.subCmds()) {
                TreeMap<Integer, MethodWrapper> mthds = basemthds.get(subcmd);
                if (mthds == null) {
                    mthds = new TreeMap();
                    basemthds.put(subcmd, mthds);
                }
                int order = (mc.order() != -1 ? mc.order() * 100000 : Integer.MAX_VALUE) - ml * 100 - mthds.size();
                MethodWrapper mw = new MethodWrapper(obj, method);
                if (mc.helpOrder() == 2.1474836E9f) {
                    mw.helpOrder = Float.valueOf(Integer.MAX_VALUE - this.usage.size());
                }
                mthds.put(order, mw);
                this.addUsage(mw, mc);
            }
        }
    }

    private void addUsage(MethodWrapper method, MCCommand mc) {
        method.usage = !mc.usage().isEmpty() ? mc.usage() : this.createUsage(method.method);
        this.usage.add(method);
    }

    private String createUsage(Method method) {
        MCCommand cmd = method.getAnnotation(MCCommand.class);
        StringBuilder sb = new StringBuilder(cmd.cmds().length > 0 ? cmd.cmds()[0] + " " : "");
        int startIndex = 1;
        if (cmd.subCmds().length > 0) {
            sb.append(cmd.subCmds()[0] + " ");
            startIndex = 2;
        }
        Class<?>[] types = method.getParameterTypes();
        for (int i = startIndex; i < types.length; ++i) {
            Class<?> theclass = types[i];
            sb.append(this.getUsageString(theclass));
        }
        return sb.toString();
    }

    protected String getUsageString(Class<?> clazz) {
        if (Player.class == clazz) {
            return "<player> ";
        }
        if (OfflinePlayer.class == clazz) {
            return "<player> ";
        }
        if (String.class == clazz) {
            return "<string> ";
        }
        if (Integer.class == clazz || Integer.TYPE == clazz) {
            return "<int> ";
        }
        if (Float.class == clazz || Float.TYPE == clazz) {
            return "<number> ";
        }
        if (Double.class == clazz || Double.TYPE == clazz) {
            return "<number> ";
        }
        if (Short.class == clazz || Short.TYPE == clazz) {
            return "<int> ";
        }
        if (Boolean.class == clazz || Boolean.TYPE == clazz) {
            return "<true|false> ";
        }
        if (String[].class == clazz || Object[].class == clazz) {
            return "[string ... ] ";
        }
        return "<string> ";
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        TreeMap<Integer, MethodWrapper> methodmap = null;
        if (args.length == 0 && !this.methods.containsKey(DEFAULT_CMD) || args.length > 0 && (args[0].equals("?") || args[0].equals("help"))) {
            this.showHelp(sender, command, args);
            return true;
        }
        int length = args.length;
        String cmd = length > 0 ? args[0].toLowerCase() : null;
        String subcmd = length > 1 ? args[1].toLowerCase() : null;
        int startIndex = 0;
        if (subcmd != null && this.subCmdMethods.containsKey(cmd) && this.subCmdMethods.get(cmd).containsKey(subcmd)) {
            methodmap = this.subCmdMethods.get(cmd).get(subcmd);
            startIndex = 2;
        }
        if (methodmap == null && cmd != null && (methodmap = this.methods.get(cmd)) != null) {
            startIndex = 1;
        }
        if (methodmap == null) {
            methodmap = this.methods.get(DEFAULT_CMD);
        }
        if (methodmap == null || methodmap.isEmpty()) {
            return BaseExecutor.sendMessage(sender, "&cThat command does not exist!&6 /" + command.getLabel() + " help &c for help");
        }
        MCCommand mccmd = null;
        ArrayList<CommandException> errs = null;
        boolean success = false;
        for (MethodWrapper mwrapper : methodmap.values()) {
            boolean isOp;
            mccmd = mwrapper.method.getAnnotation(MCCommand.class);
            boolean bl = isOp = sender == null || sender.isOp() || sender instanceof ConsoleCommandSender;
            if (mccmd.op() && !isOp || mccmd.admin() && !this.hasAdminPerms(sender)) continue;
            Arguments newArgs = null;
            try {
                newArgs = this.verifyArgs(mwrapper, mccmd, sender, command, label, args, startIndex);
                Object completed = mwrapper.method.invoke(mwrapper.obj, newArgs.args);
                if (completed != null && completed instanceof Boolean) {
                    String usage;
                    success = (Boolean)completed;
                    if (success || (usage = mwrapper.usage) == null || usage.isEmpty()) break;
                    BaseExecutor.sendMessage(sender, usage);
                    break;
                }
                success = true;
                break;
            }
            catch (IllegalArgumentException e) {
                if (errs == null) {
                    errs = new ArrayList<CommandException>();
                }
                errs.add(new CommandException(e, mwrapper));
            }
            catch (Exception e) {
                this.logInvocationError(e, mwrapper, newArgs);
            }
        }
        if (!success && errs != null && !errs.isEmpty()) {
            HashSet<String> usages = new HashSet<String>();
            for (CommandException e : errs) {
                usages.add(ChatColor.GOLD + command.getLabel() + " " + e.mw.usage + " &c:" + e.err.getMessage());
            }
            for (String msg : usages) {
                BaseExecutor.sendMessage(sender, msg);
            }
        }
        return true;
    }

    private void logInvocationError(Exception e, MethodWrapper mwrapper, Arguments newArgs) {
        System.err.println("[Error] " + mwrapper.method + " : " + mwrapper.obj + "  : " + newArgs);
        if (newArgs != null && newArgs.args != null) {
            for (Object o : newArgs.args) {
                System.err.println("[Error] object=" + o);
            }
        }
        System.err.println("[Error] Cause=" + e.getCause());
        if (e.getCause() != null) {
            e.getCause().printStackTrace();
        }
        System.err.println("[Error] Trace Continued ");
        e.printStackTrace();
    }

    protected Arguments verifyArgs(MethodWrapper mwrapper, MCCommand cmd, CommandSender sender, Command command, String label, String[] args, int startIndex) throws IllegalArgumentException {
        boolean isOp;
        int paramLength = mwrapper.method.getParameterTypes().length;
        if (!(cmd.perm().isEmpty() || sender.hasPermission(cmd.perm()) || cmd.admin() && this.hasAdminPerms(sender))) {
            throw new IllegalArgumentException("You don't have permission to use this command");
        }
        if (args.length < cmd.min()) {
            throw new IllegalArgumentException("You need at least " + cmd.min() + " arguments");
        }
        if (args.length > cmd.max()) {
            throw new IllegalArgumentException("You need less than " + cmd.max() + " arguments");
        }
        if (cmd.exact() != -1 && args.length != cmd.exact()) {
            throw new IllegalArgumentException("You need exactly " + cmd.exact() + " arguments");
        }
        boolean isPlayer = sender instanceof Player;
        boolean bl = isOp = isPlayer && sender.isOp() || sender == null || sender instanceof ConsoleCommandSender;
        if (cmd.op() && !isOp) {
            throw new IllegalArgumentException("You need to be op to use this command");
        }
        if (cmd.admin() && !isOp && isPlayer && !this.hasAdminPerms(sender)) {
            throw new IllegalArgumentException("You need to be an Admin to use this command");
        }
        Class<?>[] types = mwrapper.method.getParameterTypes();
        if (types[0] == Player.class && !isPlayer) {
            throw new IllegalArgumentException(ONLY_INGAME);
        }
        int strIndex = startIndex;
        int objIndex = 1;
        Arguments newArgs = new Arguments();
        Object[] objs = new Object[paramLength];
        newArgs.args = objs;
        objs[0] = this.verifySender(sender, types[0]);
        AtomicBoolean usedString = new AtomicBoolean();
        for (int i = 1; i < types.length; ++i) {
            Class<?> clazz = types[i];
            usedString.set(false);
            try {
                if (CommandSender.class == clazz) {
                    objs[objIndex] = sender;
                } else if (String[].class == clazz) {
                    objs[objIndex] = args;
                } else if (Object[].class == clazz) {
                    objs[objIndex] = args;
                } else {
                    String str = strIndex < args.length ? args[strIndex] : null;
                    objs[objIndex] = this.verifyArg(clazz, command, str, usedString);
                    if (objs[objIndex] == null) {
                        throw new IllegalArgumentException("Argument " + args[strIndex] + " can not be null");
                    }
                }
                if (usedString.get()) {
                    ++strIndex;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("You didnt supply enough arguments for this method");
            }
            ++objIndex;
        }
        if (cmd.alphanum().length > 0) {
            for (int index : cmd.alphanum()) {
                if (index >= args.length) {
                    throw new IllegalArgumentException("String Index out of range. ");
                }
                if (args[index].matches("[a-zA-Z0-9_]*")) continue;
                throw new IllegalArgumentException("argument '" + args[index] + "' can only be alphanumeric with underscores");
            }
        }
        return newArgs;
    }

    protected Object verifySender(CommandSender sender, Class<?> clazz) {
        if (!clazz.isAssignableFrom(sender.getClass())) {
            throw new IllegalArgumentException("sender must be a " + clazz.getSimpleName());
        }
        return sender;
    }

    protected Object verifyArg(Class<?> clazz, Command command, String string, AtomicBoolean usedString) {
        if (Command.class == clazz) {
            usedString.set(false);
            return command;
        }
        if (string == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        usedString.set(true);
        if (Player.class == clazz) {
            return this.verifyPlayer(string);
        }
        if (OfflinePlayer.class == clazz) {
            return this.verifyOfflinePlayer(string);
        }
        if (String.class == clazz) {
            return string;
        }
        if (Integer.class == clazz || Integer.TYPE == clazz) {
            return this.verifyInteger(string);
        }
        if (Boolean.class == clazz || Boolean.TYPE == clazz) {
            return Boolean.parseBoolean(string);
        }
        if (Object.class == clazz) {
            return string;
        }
        if (Float.class == clazz || Float.TYPE == clazz) {
            return this.verifyFloat(string);
        }
        if (Double.class == clazz || Double.TYPE == clazz) {
            return this.verifyDouble(string);
        }
        return null;
    }

    private OfflinePlayer verifyOfflinePlayer(String name) throws IllegalArgumentException {
        OfflinePlayer p = BaseExecutor.findOfflinePlayer(name);
        if (p == null) {
            throw new IllegalArgumentException("Player " + name + " can not be found");
        }
        return p;
    }

    private Player verifyPlayer(String name) throws IllegalArgumentException {
        Player p = BaseExecutor.findPlayer(name);
        if (p == null || !p.isOnline()) {
            throw new IllegalArgumentException(name + " is not online ");
        }
        return p;
    }

    private Integer verifyInteger(Object object) throws IllegalArgumentException {
        try {
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(ChatColor.RED + (String)object + " is not a valid integer.");
        }
    }

    private Float verifyFloat(Object object) throws IllegalArgumentException {
        try {
            return Float.valueOf(Float.parseFloat(object.toString()));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(ChatColor.RED + (String)object + " is not a valid float.");
        }
    }

    private Double verifyDouble(Object object) throws IllegalArgumentException {
        try {
            return Double.parseDouble(object.toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(ChatColor.RED + (String)object + " is not a valid double.");
        }
    }

    protected boolean hasAdminPerms(CommandSender sender) {
        return sender.isOp();
    }

    public void help(CommandSender sender, Command command, String[] args) {
        Integer page = 1;
        if (args != null && args.length > 1) {
            try {
                page = Integer.valueOf(args[1]);
            }
            catch (Exception e) {
                BaseExecutor.sendMessage(sender, ChatColor.RED + " " + args[1] + " is not a number, showing help for page 1.");
            }
        }
        ArrayList<String> available = new ArrayList<String>();
        ArrayList<String> unavailable = new ArrayList<String>();
        ArrayList onlyop = new ArrayList();
        for (MethodWrapper mw : this.usage) {
            MCCommand cmd = mw.getCommand();
            String use = "&6/" + command.getName() + " " + mw.usage;
            if (cmd.op() && !sender.isOp() || cmd.admin() && !this.hasAdminPerms(sender)) continue;
            if (!cmd.perm().isEmpty() && !sender.hasPermission(cmd.perm())) {
                unavailable.add(use);
                continue;
            }
            available.add(use);
        }
        int npages = available.size() + unavailable.size();
        if (sender.isOp()) {
            npages += onlyop.size();
        }
        npages = (int)Math.ceil((float)npages / 8.0f);
        if (page > npages || page <= 0) {
            if (npages <= 0) {
                BaseExecutor.sendMessage(sender, "&4There are no methods for this command");
            } else {
                BaseExecutor.sendMessage(sender, "&4That page doesnt exist, try 1-" + npages);
            }
            return;
        }
        if (command != null && command.getAliases() != null && !command.getAliases().isEmpty()) {
            String aliases = StringUtils.join((Collection)command.getAliases(), (String)", ");
            BaseExecutor.sendMessage(sender, "&eShowing page &6" + page + "/" + npages + "&6 : /" + command.getName() + " help <page number>");
            BaseExecutor.sendMessage(sender, "&e    command &6" + command.getName() + "&e has aliases: &6" + aliases);
        } else {
            BaseExecutor.sendMessage(sender, "&eShowing page &6" + page + "/" + npages + "&6 : /cmd help <page number>");
        }
        int i = 0;
        for (String use : available) {
            if (++i < (page - 1) * 8 || i >= page * 8) continue;
            BaseExecutor.sendMessage(sender, use);
        }
        for (String use : unavailable) {
            if (++i < (page - 1) * 8 || i >= page * 8) continue;
            BaseExecutor.sendMessage(sender, ChatColor.RED + "[Insufficient Perms] " + use);
        }
        if (sender.isOp()) {
            for (String use : onlyop) {
                if (++i < (page - 1) * 8 || i >= page * 8) continue;
                BaseExecutor.sendMessage(sender, ChatColor.AQUA + "[OP only] &6" + use);
            }
        }
    }

    public static boolean sendMessage(CommandSender p, String message) {
        if (message == null || message.isEmpty()) {
            return true;
        }
        if (message.contains("\n")) {
            return BaseExecutor.sendMultilineMessage(p, message);
        }
        if (p instanceof Player) {
            if (((Player)p).isOnline()) {
                p.sendMessage(BaseExecutor.colorChat(message));
            }
        } else {
            p.sendMessage(BaseExecutor.colorChat(message));
        }
        return true;
    }

    public static boolean sendMultilineMessage(CommandSender p, String message) {
        String[] msgs;
        if (message == null || message.isEmpty()) {
            return true;
        }
        for (String msg : msgs = message.split("\n")) {
            if (p instanceof Player) {
                if (!((Player)p).isOnline()) continue;
                p.sendMessage(BaseExecutor.colorChat(msg));
                continue;
            }
            p.sendMessage(BaseExecutor.colorChat(msg));
        }
        return true;
    }

    public static String colorChat(String msg) {
        return msg.replace('&', '\u00a7');
    }

    public static Player findPlayer(String name) {
        Player[] online;
        if (name == null) {
            return null;
        }
        Player foundPlayer = Bukkit.getPlayer((String)name);
        if (foundPlayer != null) {
            return foundPlayer;
        }
        for (Player player : online = Bukkit.getOnlinePlayers()) {
            String playerName = player.getName();
            if (playerName.equalsIgnoreCase(name)) {
                foundPlayer = player;
                break;
            }
            if (playerName.toLowerCase().indexOf(name.toLowerCase()) == -1) continue;
            if (foundPlayer != null) {
                return null;
            }
            foundPlayer = player;
        }
        return foundPlayer;
    }

    public static OfflinePlayer findOfflinePlayer(String name) {
        Player p = BaseExecutor.findPlayer(name);
        if (p != null) {
            return p;
        }
        for (World w : Bukkit.getWorlds()) {
            File f = new File(w.getName() + "/players/" + name + ".dat");
            if (!f.exists()) continue;
            return Bukkit.getOfflinePlayer((String)name);
        }
        return null;
    }

    public class CommandException {
        final IllegalArgumentException err;
        final MethodWrapper mw;

        public CommandException(IllegalArgumentException err, MethodWrapper mw) {
            this.err = err;
            this.mw = mw;
        }
    }

    protected static class MethodWrapper {
        public Object obj;
        public Method method;
        public String usage;
        Float helpOrder = null;

        public MethodWrapper(Object obj, Method method) {
            this.obj = obj;
            this.method = method;
        }

        public MCCommand getCommand() {
            return this.method.getAnnotation(MCCommand.class);
        }

        public float getHelpOrder() {
            return this.helpOrder != null ? this.helpOrder.floatValue() : this.method.getAnnotation(MCCommand.class).helpOrder();
        }
    }

    public static class Arguments {
        public Object[] args;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MCCommand {
        public String[] cmds() default {};

        public String[] subCmds() default {};

        public int min() default 0;

        public int max() default 0x7FFFFFFF;

        public int exact() default -1;

        public int order() default -1;

        public float helpOrder() default 2.1474836E9f;

        public boolean admin() default false;

        public boolean op() default false;

        public boolean inGame() default false;

        public String usage() default "";

        public String usageNode() default "";

        public String perm() default "";

        public int[] alphanum() default {};

        public boolean selection() default false;

        public int[] arenas() default {};
    }
}

