/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.scoreboardapi;

import mc.alk.scoreboardapi.BaseExecutor;
import mc.alk.scoreboardapi.ScoreboardAPI;
import mc.alk.scoreboardapi.ScoreboardHandler;
import mc.alk.scoreboardapi.api.SAPIFactory;
import mc.alk.scoreboardapi.api.SEntry;
import mc.alk.scoreboardapi.api.SObjective;
import mc.alk.scoreboardapi.api.SScoreboard;
import mc.alk.scoreboardapi.api.STeam;
import mc.alk.scoreboardapi.scoreboard.SAPIDisplaySlot;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ScoreboardAPIExecutor
extends BaseExecutor {
    ScoreboardHandler sh = new ScoreboardHandler();

    @BaseExecutor.MCCommand(cmds={"createScoreboard", "cs"}, op=true)
    public boolean createScoreboard(CommandSender sender, String scoreboardName) {
        if (this.sh.bs == null) {
            SScoreboard s = SAPIFactory.createScoreboard((Plugin)ScoreboardAPI.getSelf(), scoreboardName);
            this.sh.addScoreboard(s);
        }
        return ScoreboardAPIExecutor.sendMessage(sender, "Added scoreboard");
    }

    @BaseExecutor.MCCommand(cmds={"createObjective", "co"}, op=true)
    public boolean createObjective(CommandSender sender, String objectiveName, String slot, String criteria, String displayName) {
        SObjective o = this.sh.bs.getObjective(objectiveName);
        if (o != null) {
            return ScoreboardAPIExecutor.sendMessage(sender, "&cobjective " + o.getID() + " already exists");
        }
        if (displayName.contains("\\\"")) {
            displayName = displayName.replaceAll("\\\"", "");
        }
        SAPIDisplaySlot s = SAPIDisplaySlot.fromValue(slot);
        o = this.sh.bs.registerNewObjective(objectiveName, criteria, displayName, s);
        return ScoreboardAPIExecutor.sendMessage(sender, "Added objective " + o.getDisplayName());
    }

    @BaseExecutor.MCCommand(cmds={"addEntry", "ae"}, op=true)
    public boolean addEntry(CommandSender sender, String objective, String id, String display, int points) {
        SObjective o = this.sh.bs.getObjective(objective);
        if (o == null) {
            return ScoreboardAPIExecutor.sendMessage(sender, "&cobjective " + objective + " doesnt exist");
        }
        this.sh.bs.createEntry(id, display);
        o.addEntry(id, points);
        return true;
    }

    @BaseExecutor.MCCommand(cmds={"addExistingEntry"}, op=true)
    public boolean addExistingEntry(CommandSender sender, String objective, String id, int points) {
        SObjective o = this.sh.bs.getObjective(objective);
        if (o == null) {
            return ScoreboardAPIExecutor.sendMessage(sender, "&cobjective " + objective + " doesnt exist");
        }
        SEntry e = this.sh.bs.getEntry(id);
        if (e == null) {
            return ScoreboardAPIExecutor.sendMessage(sender, "&cEntry " + id + " doesnt exist");
        }
        o.addEntry(e, points);
        return true;
    }

    @BaseExecutor.MCCommand(cmds={"addPlayerEntry", "ape"}, op=true)
    public boolean addPlayerEntry(CommandSender sender, String objective, Player p, String display, int points) {
        SObjective o = this.sh.bs.getObjective(objective);
        if (o == null) {
            return ScoreboardAPIExecutor.sendMessage(sender, "&cobjective " + objective + " doesnt exist");
        }
        if (display.contains("\\\"")) {
            display = display.replaceAll("\\\"", "");
        }
        this.sh.bs.createEntry((OfflinePlayer)p, display);
        o.addEntry((OfflinePlayer)p, points);
        return true;
    }

    @BaseExecutor.MCCommand(cmds={"addTeam", "at"}, op=true)
    public boolean addTeam(CommandSender sender, String id, String display, String prefix) {
        STeam t = this.sh.bs.createTeamEntry(id, display);
        t.setPrefix(prefix);
        return true;
    }

    @BaseExecutor.MCCommand(cmds={"setDisplayPlayers"}, op=true)
    public boolean setDisplayPlayers(CommandSender sender, String objective, boolean b) {
        SObjective o = this.sh.bs.getObjective(objective);
        if (o == null) {
            return ScoreboardAPIExecutor.sendMessage(sender, "&cobjective " + objective + " doesnt exist");
        }
        o.setDisplayPlayers(b);
        return ScoreboardAPIExecutor.sendMessage(sender, "&2objective " + objective + " setDisplayPlayers " + b);
    }

    @BaseExecutor.MCCommand(cmds={"setDisplayTeams"}, op=true)
    public boolean setDisplayTeams(CommandSender sender, String objective, boolean b) {
        SObjective o = this.sh.bs.getObjective(objective);
        if (o == null) {
            return ScoreboardAPIExecutor.sendMessage(sender, "&cobjective " + objective + " doesnt exist");
        }
        o.setDisplayTeams(b);
        return ScoreboardAPIExecutor.sendMessage(sender, "&2objective " + objective + " setDisplayTeams " + b);
    }

    @BaseExecutor.MCCommand(cmds={"clearBoard"}, op=true)
    public boolean clearBoard(CommandSender sender) {
        this.sh.bs.clear();
        return ScoreboardAPIExecutor.sendMessage(sender, "&2 " + this.sh.bs.getName() + " cleared");
    }

    @BaseExecutor.MCCommand(cmds={"addToTeam", "att"}, op=true)
    public boolean addToTeam(CommandSender sender, String teamName, Player p) {
        STeam t = this.sh.bs.getTeam(teamName);
        if (t == null) {
            return ScoreboardAPIExecutor.sendMessage(sender, "&team " + teamName + " doesnt exist");
        }
        if (p == null) {
            return ScoreboardAPIExecutor.sendMessage(sender, "&player " + p + " doesnt exist");
        }
        t.addPlayer((OfflinePlayer)p);
        return ScoreboardAPIExecutor.sendMessage(sender, "&added " + p.getName() + " to " + t.getDisplayName());
    }

    @BaseExecutor.MCCommand(cmds={"removeFromTeam", "rft"}, op=true)
    public boolean removeFromTeam(CommandSender sender, String teamName, Player p) {
        STeam t = this.sh.bs.getTeam(teamName);
        if (t == null) {
            return ScoreboardAPIExecutor.sendMessage(sender, "&team " + teamName + " doesnt exist");
        }
        t.removePlayer((OfflinePlayer)p);
        return ScoreboardAPIExecutor.sendMessage(sender, "&2removed " + p.getName() + " from " + t.getDisplayName());
    }

    @BaseExecutor.MCCommand(cmds={"changeEntry", "ce"}, op=true)
    public boolean changeEntry(CommandSender sender, String objective, String id, int points) {
        SObjective o = this.sh.bs.getObjective(objective);
        o.setPoints(id, points);
        return true;
    }

    @BaseExecutor.MCCommand(cmds={"giveScoreboard", "gs"}, op=true)
    public boolean giveScoreboard(CommandSender sender, Player p) {
        this.sh.bs.setScoreboard(p);
        return ScoreboardAPIExecutor.sendMessage(sender, "&2Gave " + p.getName() + " scoreboard");
    }

    @BaseExecutor.MCCommand(cmds={"removeEntry", "re"}, op=true)
    public boolean removeEntry(CommandSender sender, String id) {
        this.sh.bs.removeEntry(this.sh.bs.getEntry(id));
        return true;
    }

    @BaseExecutor.MCCommand(cmds={"removeteam", "rt"}, op=true)
    public boolean removeTeam(CommandSender sender, String teamid) {
        STeam t = this.sh.bs.getTeam(teamid);
        if (t == null) {
            return ScoreboardAPIExecutor.sendMessage(sender, "&team " + teamid + " doesnt exist");
        }
        this.sh.bs.removeEntry(t);
        return true;
    }

    @BaseExecutor.MCCommand(cmds={"setObjectiveName", "son"}, op=true)
    public boolean setDisplayName(CommandSender sender, String objective, String newDisplayName) {
        SObjective o = this.sh.bs.getObjective(objective);
        o.setDisplayName(newDisplayName);
        return true;
    }

    @BaseExecutor.MCCommand(cmds={"setObjectiveSlot", "sol"}, op=true)
    public boolean setObjectiveSlot(CommandSender sender, String objective, String slot) {
        SObjective o = this.sh.bs.getObjective(objective);
        o.setDisplaySlot(SAPIDisplaySlot.fromValue(slot));
        return ScoreboardAPIExecutor.sendMessage(sender, "&6setObjectiveSlot " + o.getDisplayName() + " " + slot);
    }

    @BaseExecutor.MCCommand(cmds={"setEntryDisplayName", "sen"}, op=true)
    public boolean setEntryName(CommandSender sender, String id, String newDisplayName) {
        if (newDisplayName.contains("\\\"")) {
            newDisplayName = newDisplayName.replaceAll("\\\"", "");
        }
        this.sh.bs.setEntryDisplayName(id, newDisplayName);
        return ScoreboardAPIExecutor.sendMessage(sender, "&6setEntryName " + newDisplayName + " " + this.sh.bs.getEntry(id).getDisplayName());
    }

    @BaseExecutor.MCCommand(cmds={"setEntryPrefix", "sen"}, op=true)
    public boolean setEntryPrefix(CommandSender sender, String id, String prefix) {
        if (prefix.contains("\\\"")) {
            prefix = prefix.replaceAll("\\\"", "");
        }
        this.sh.bs.setEntryNamePrefix(id, prefix);
        return ScoreboardAPIExecutor.sendMessage(sender, "&6setEntryPrefix " + prefix + " " + this.sh.bs.getEntry(id).getDisplayName());
    }

    @BaseExecutor.MCCommand(cmds={"setScore", "ss"}, op=true)
    public boolean setScore(CommandSender sender, String objective, String id, int score) {
        SObjective o = this.sh.bs.getObjective(objective);
        if (o == null) {
            return ScoreboardAPIExecutor.sendMessage(sender, "&cobjective " + objective + " doesnt exist");
        }
        SEntry e = this.sh.bs.getEntry(id);
        if (e == null) {
            return ScoreboardAPIExecutor.sendMessage(sender, "&centry " + id + " doesnt exist");
        }
        o.setPoints(e, score);
        return ScoreboardAPIExecutor.sendMessage(sender, "&2setScore " + id + " " + score);
    }

    @BaseExecutor.MCCommand(cmds={"printScoreboard", "ps"}, op=true)
    public boolean printScoreboard(CommandSender sender) {
        if (this.sh.bs != null) {
            return ScoreboardAPIExecutor.sendMessage(sender, "&c" + this.sh.bs.getPrintString());
        }
        if (sender instanceof Player) {
            Player p = (Player)sender;
            p.getScoreboard();
            return ScoreboardAPIExecutor.sendMessage(sender, "&cYou need to be in game");
        }
        return ScoreboardAPIExecutor.sendMessage(sender, "&cYou need to be in game");
    }

    @BaseExecutor.MCCommand(cmds={"setTeamScore", "ss"}, op=true)
    public boolean setTeamScore(CommandSender sender, String objective, String teamName, int points) {
        STeam t = this.sh.bs.getTeam(teamName);
        if (t == null) {
            return ScoreboardAPIExecutor.sendMessage(sender, "&team " + teamName + " doesnt exist");
        }
        SObjective o = this.sh.bs.getObjective(objective);
        if (o == null) {
            return ScoreboardAPIExecutor.sendMessage(sender, "&cobjective " + objective + " doesnt exist");
        }
        o.setTeamPoints(t, points);
        return true;
    }
}

