/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.scoreboardapi.api;

import mc.alk.scoreboardapi.api.SScoreboard;
import mc.alk.scoreboardapi.scoreboard.SAPIDisplaySlot;
import mc.alk.scoreboardapi.scoreboard.SAPIObjective;
import mc.alk.scoreboardapi.scoreboard.SAPIScoreboard;
import mc.alk.scoreboardapi.scoreboard.bukkit.BObjective;
import mc.alk.scoreboardapi.scoreboard.bukkit.BScoreboard;
import org.bukkit.plugin.Plugin;

public class SAPIFactory {
    private static boolean hasBukkitScoreboard = false;

    public static SAPIObjective createObjective(String id, String displayName, String criteria, SAPIDisplaySlot slot, int priority) {
        SAPIObjective o = hasBukkitScoreboard ? new BObjective(id, displayName, criteria, priority) : new SAPIObjective(id, displayName, criteria, priority);
        o.setDisplaySlot(slot);
        return o;
    }

    public static SAPIObjective createSAPIObjective(String id, String displayName, String criteria, SAPIDisplaySlot slot, int priority) {
        SAPIObjective o = new SAPIObjective(id, displayName, criteria, priority);
        o.setDisplaySlot(slot);
        return o;
    }

    public static SScoreboard createScoreboard(Plugin plugin, String name) {
        return hasBukkitScoreboard ? new BScoreboard(plugin, name) : new SAPIScoreboard(plugin, name);
    }

    public static SScoreboard createSAPIScoreboard(Plugin plugin, String name) {
        return new SAPIScoreboard(plugin, name);
    }

    public static boolean hasBukkitScoreboard() {
        return hasBukkitScoreboard;
    }

    public static void transferOldScoreboards(SScoreboard oldScoreboard, SScoreboard newScoreboard) {
        if (!hasBukkitScoreboard) {
            return;
        }
        if (!(oldScoreboard instanceof BScoreboard) || !(newScoreboard instanceof BScoreboard)) {
            return;
        }
        ((BScoreboard)newScoreboard).transferOldScoreboards((BScoreboard)oldScoreboard);
    }

    static {
        try {
            Class.forName("org.bukkit.scoreboard.Scoreboard");
            hasBukkitScoreboard = true;
        }
        catch (ClassNotFoundException e) {
            hasBukkitScoreboard = false;
        }
    }
}

