/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.scoreboardapi.scoreboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import mc.alk.scoreboardapi.api.SEntry;
import mc.alk.scoreboardapi.api.STeam;
import mc.alk.scoreboardapi.scoreboard.SAPIEntry;
import mc.alk.scoreboardapi.scoreboard.SAPIPlayerEntry;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler {
    static int ids = 0;
    HashMap<Integer, SEntry> row = new HashMap();
    HashMap<String, Integer> idmap = new HashMap();

    public SEntry getOrCreateEntry(OfflinePlayer p) {
        return this.getOrCreateEntry(p, p.getName());
    }

    public SEntry getOrCreateEntry(OfflinePlayer p, String displayName) {
        if (!this.contains(p.getName())) {
            Integer realid = ids++;
            this.idmap.put(p.getName(), realid);
            SAPIPlayerEntry l = new SAPIPlayerEntry(p, displayName);
            this.row.put(realid, l);
            return l;
        }
        return this.getEntry(p.getName());
    }

    public void registerEntry(SEntry entry) {
        if (!this.contains(entry.getID())) {
            Integer realid = ids++;
            this.idmap.put(entry.getID(), realid);
            this.row.put(realid, entry);
        }
    }

    public SEntry getOrCreateEntry(String id, String displayName) {
        if (!this.contains(id)) {
            Integer realid = ids++;
            this.idmap.put(id, realid);
            Player p = Bukkit.getPlayerExact((String)id);
            SEntry l = p == null ? new SAPIEntry(id, displayName) : new SAPIPlayerEntry((OfflinePlayer)p, displayName);
            this.row.put(realid, l);
            return l;
        }
        return this.getEntry(id);
    }

    public SEntry removeEntry(SEntry e) {
        Integer id = this.idmap.remove(e.getID());
        if (id != null) {
            return this.row.remove(id);
        }
        return null;
    }

    public SEntry removeEntry(Player p) {
        Integer id = this.idmap.remove(p.getName());
        if (id != null) {
            return this.row.remove(id);
        }
        return null;
    }

    public STeam getTeamEntry(String id) {
        SEntry e = this.getEntry(id);
        return e == null || !(e instanceof STeam) ? null : (STeam)e;
    }

    public boolean contains(String id) {
        return this.idmap.containsKey(id) && this.row.containsKey(this.idmap.get(id));
    }

    public boolean contains(OfflinePlayer p) {
        return this.idmap.containsKey(p.getName()) && this.row.containsKey(this.idmap.get(p.getName()));
    }

    public SEntry getEntry(OfflinePlayer p) {
        return !this.idmap.containsKey(p.getName()) ? null : this.row.get(this.idmap.get(p.getName()));
    }

    public SEntry getEntry(String id) {
        return !this.idmap.containsKey(id) ? null : this.row.get(this.idmap.get(id));
    }

    public Collection<SEntry> getEntries() {
        return new ArrayList<SEntry>(this.row.values());
    }
}

