/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.scoreboardapi.scoreboard;

import java.util.TreeMap;
import mc.alk.scoreboardapi.SAPIUtil;
import mc.alk.scoreboardapi.api.SEntry;
import mc.alk.scoreboardapi.api.SObjective;
import mc.alk.scoreboardapi.api.SScoreboard;
import mc.alk.scoreboardapi.api.STeam;
import mc.alk.scoreboardapi.scoreboard.SAPIDisplaySlot;
import mc.alk.scoreboardapi.scoreboard.SAPIScore;
import org.bukkit.OfflinePlayer;

public class SAPIObjective
implements SObjective {
    protected final String id;
    protected String criteria;
    protected String combinedDisplayName;
    protected String displayName;
    protected String displayNameSuffix;
    protected String displayNamePrefix;
    protected SAPIDisplaySlot slot;
    protected SScoreboard scoreboard;
    protected boolean displayPlayers;
    protected boolean displayTeams;
    int priority;
    protected TreeMap<SEntry, SAPIScore> entries = new TreeMap();

    public SAPIObjective(String id, String displayName, String criteria) {
        this(id, displayName, criteria, 50);
    }

    public SAPIObjective(String id, String displayName, String criteria, int priority) {
        this.id = id;
        this.criteria = SAPIObjective.colorChat(criteria);
        this.priority = priority;
        this.setDisplayName(displayName);
        this.displayPlayers = true;
        this.displayTeams = true;
        this.slot = SAPIDisplaySlot.NONE;
    }

    public SScoreboard getScoreboard() {
        return this.scoreboard;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getID() {
        return this.id;
    }

    public String getCriteria() {
        return this.criteria;
    }

    public String getBaseDisplayName() {
        return this.displayName;
    }

    public String getDisplayName() {
        return this.combinedDisplayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = SAPIObjective.colorChat(displayName);
        this._setDisplayName();
    }

    public String getDisplayNameSuffix() {
        return this.displayNameSuffix;
    }

    public void setDisplayNameSuffix(String suffix) {
        this.displayNameSuffix = SAPIObjective.colorChat(suffix);
        this._setDisplayName();
    }

    public String getDisplayNamePrefix() {
        return this.displayNamePrefix;
    }

    public void setDisplayNamePrefix(String prefix) {
        this.displayNamePrefix = SAPIObjective.colorChat(prefix);
        this._setDisplayName();
    }

    public void setDisplaySlot(SAPIDisplaySlot slot) {
        this.slot = slot;
        if (this.scoreboard != null) {
            this.scoreboard.setDisplaySlot(slot, this, true);
        }
    }

    public SAPIDisplaySlot getDisplaySlot() {
        return this.slot;
    }

    public void setDisplayPlayers(boolean display) {
        this.displayPlayers = display;
    }

    public void setDisplayTeams(boolean display) {
        this.displayTeams = display;
    }

    public boolean isDisplayPlayers() {
        return this.displayPlayers;
    }

    public void setScoreBoard(SScoreboard sapiScoreboard) {
        this.scoreboard = sapiScoreboard;
    }

    public boolean setPoints(SEntry e, int points) {
        boolean has = this.entries.containsKey(e);
        this.setPoints(this.getOrCreateSAPIScore(e), points);
        return has;
    }

    protected boolean setPoints(SAPIScore o, int points) {
        boolean change;
        boolean bl = change = o.getScore() != points;
        if (change) {
            o.setScore(points);
            return true;
        }
        return false;
    }

    public boolean setTeamPoints(STeam team, int points) {
        if (this.displayTeams) {
            this.setPoints(team, points);
        }
        if (this.displayPlayers) {
            for (OfflinePlayer offlinePlayer : team.getPlayers()) {
                SEntry e = this.scoreboard.getOrCreateEntry(offlinePlayer);
                this.setPoints(e, points);
            }
        }
        return true;
    }

    public boolean setPoints(String id, int points) {
        if (this.scoreboard == null) {
            return false;
        }
        SEntry l = this.scoreboard.getEntry(id);
        if (l == null) {
            return false;
        }
        this.setPoints(l, points);
        return true;
    }

    public int getPoints(String id) {
        SEntry l = this.scoreboard.getEntry(id);
        if (l == null) {
            return -1;
        }
        return this.getPoints(l);
    }

    public int getPoints(SEntry e) {
        return this.entries.containsKey(e) ? this.entries.get(e).getScore() : -1;
    }

    public static String colorChat(String msg) {
        return msg.replace('&', '\u00a7');
    }

    public SEntry addEntry(OfflinePlayer p, int points) {
        return this.addEntry(p.getName(), points);
    }

    public SEntry addEntry(String id, int points) {
        SEntry e = this.scoreboard.getEntry(id);
        if (e == null) {
            if (this.getScoreboard() != null) {
                e = this.scoreboard.createEntry(id, id);
            } else {
                throw new IllegalStateException("You cannot add an entry that hasnt already been created " + id);
            }
        }
        this.addEntry(e, points);
        return e;
    }

    final SAPIScore getOrCreateSAPIScore(SEntry e) {
        return this.getOrCreateSAPIScore(e, 0);
    }

    final SAPIScore getOrCreateSAPIScore(SEntry e, int points) {
        if (this.entries.containsKey(e)) {
            return this.entries.get(e);
        }
        SAPIScore o = new SAPIScore(e, points);
        this.entries.put(e, o);
        this.setPoints(o, points);
        return o;
    }

    public boolean addEntry(SEntry entry, int points) {
        if (entry instanceof STeam) {
            return this.addTeam((STeam)entry, points);
        }
        boolean has = this.entries.containsKey(entry);
        if (!has) {
            this.getOrCreateSAPIScore(entry, points);
        } else {
            this.setPoints(this.getOrCreateSAPIScore(entry), points);
        }
        return has;
    }

    public SEntry removeEntry(OfflinePlayer player) {
        SEntry e = this.scoreboard.getEntry(player);
        if (e == null) {
            return null;
        }
        return this.removeEntry(e);
    }

    public SEntry removeEntry(String id) {
        SEntry e = this.scoreboard.getEntry(id);
        if (e == null) {
            return null;
        }
        return this.removeEntry(e);
    }

    public SEntry removeEntry(SEntry entry) {
        return this.entries.remove(entry) != null ? entry : null;
    }

    public STeam addTeam(String id, int points) {
        STeam t = this.scoreboard.getTeam(id);
        if (t != null) {
            this.addTeam(t, points);
        }
        return t;
    }

    public boolean addTeam(STeam entry, int points) {
        boolean has = this.entries.containsKey(entry);
        SAPIScore sc = this.getOrCreateSAPIScore(entry);
        this.setPoints(sc, points);
        if (this.isDisplayTeams()) {
            this.setPoints(sc, points);
        }
        for (OfflinePlayer offlinePlayer : entry.getPlayers()) {
            sc = this.getOrCreateSAPIScore(this.scoreboard.getOrCreateEntry(offlinePlayer));
            if (!this.isDisplayPlayers()) continue;
            this.setPoints(sc, points);
        }
        return has;
    }

    public boolean isDisplayTeams() {
        return this.displayTeams;
    }

    public boolean contains(SEntry e) {
        return this.entries.containsKey(e);
    }

    protected void _setDisplayName() {
        this.combinedDisplayName = SAPIUtil.createLimitedString(this.displayNamePrefix, this.displayName, this.displayNameSuffix, 32);
    }
}

