/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.scoreboardapi.scoreboard;

import mc.alk.scoreboardapi.api.SEntry;
import mc.alk.scoreboardapi.scoreboard.SAPIObjective;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAPIPlayerEntry
implements SEntry,
Comparable<SEntry> {
    OfflinePlayer p;
    private String displayName;
    private String displayNameSuffix;
    private String displayNamePrefix;
    private String combinedDisplayName;

    public SAPIPlayerEntry(OfflinePlayer p) {
        this.p = p;
        this.setDisplayName(p.getName());
    }

    public SAPIPlayerEntry(OfflinePlayer p, String display) {
        this.p = p;
        this.setDisplayName(display);
    }

    @Override
    public OfflinePlayer getOfflinePlayer() {
        return Bukkit.getOfflinePlayer((String)this.combinedDisplayName);
    }

    @Override
    public String getID() {
        return this.p.getName();
    }

    @Override
    public String getDisplayName() {
        return this.combinedDisplayName;
    }

    @Override
    public String getBaseDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = SAPIObjective.colorChat(displayName);
        this._setDisplayName();
    }

    @Override
    public void setDisplayNameSuffix(String suffix) {
        this.displayNameSuffix = SAPIObjective.colorChat(suffix);
        if (this.displayNameSuffix.length() > 8) {
            this.displayNameSuffix = this.displayNameSuffix.substring(0, 9);
        }
        this._setDisplayName();
    }

    @Override
    public String getDisplayNameSuffix() {
        return this.displayNameSuffix;
    }

    @Override
    public void setDisplayNamePrefix(String suffix) {
        this.displayNamePrefix = SAPIObjective.colorChat(suffix);
        if (this.displayNamePrefix.length() > 8) {
            this.displayNamePrefix = this.displayNamePrefix.substring(0, 9);
        }
        this._setDisplayName();
    }

    @Override
    public String getDisplayNamePrefix() {
        return this.displayNamePrefix;
    }

    private void _setDisplayName() {
        if ((this.displayNamePrefix != null ? this.displayNamePrefix.length() : 0) + this.displayName.length() + (this.displayNameSuffix != null ? this.displayNameSuffix.length() : 0) > 15) {
            int size = (this.displayNamePrefix != null ? this.displayNamePrefix.length() : 0) + (this.displayNameSuffix != null ? this.displayNameSuffix.length() : 0);
            this.combinedDisplayName = (this.displayNamePrefix != null ? this.displayNamePrefix : "") + this.displayName.substring(0, 16 - size) + (this.displayNameSuffix != null ? this.displayNameSuffix : "");
        } else {
            this.combinedDisplayName = (this.displayNamePrefix != null ? this.displayNamePrefix : "") + this.displayName + (this.displayNameSuffix != null ? this.displayNameSuffix : "");
        }
    }

    @Override
    public int compareTo(SEntry o) {
        return this.getID().compareTo(o.getID());
    }
}

