/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.scoreboardapi.scoreboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mc.alk.scoreboardapi.api.SEntry;
import mc.alk.scoreboardapi.api.SObjective;
import mc.alk.scoreboardapi.api.SScoreboard;
import mc.alk.scoreboardapi.api.STeam;
import mc.alk.scoreboardapi.scoreboard.Handler;
import mc.alk.scoreboardapi.scoreboard.SAPIDisplaySlot;
import mc.alk.scoreboardapi.scoreboard.SAPIObjective;
import mc.alk.scoreboardapi.scoreboard.SAPITeam;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAPIScoreboard
implements SScoreboard {
    protected Map<String, SObjective> objectives = new HashMap<String, SObjective>();
    protected HashMap<SAPIDisplaySlot, SObjective> slots = new HashMap();
    protected final String name;
    protected Handler handler = new Handler();
    protected final Plugin plugin;

    public SAPIScoreboard(Plugin plugin, String name) {
        this.name = name;
        this.plugin = plugin;
    }

    @Override
    public void clear() {
        this.objectives.clear();
    }

    @Override
    public SObjective registerNewObjective(SObjective obj) {
        this.objectives.put(obj.getID().toUpperCase(), obj);
        if (obj.getScoreboard() == null || !obj.getScoreboard().equals(this)) {
            obj.setScoreBoard(this);
        }
        if (obj.getDisplaySlot() != null) {
            this.setDisplaySlot(obj.getDisplaySlot(), obj, false, true);
        }
        return obj;
    }

    @Override
    public SObjective registerNewObjective(String id, String displayName, String criteria, SAPIDisplaySlot slot) {
        SAPIObjective o = new SAPIObjective(id, displayName, criteria);
        o.setDisplayName(displayName);
        o.setDisplaySlot(slot);
        this.registerNewObjective(o);
        return o;
    }

    @Override
    public void setDisplaySlot(SAPIDisplaySlot slot, SObjective objective) {
        this.setDisplaySlot(slot, objective, false);
    }

    @Override
    public void setDisplaySlot(SAPIDisplaySlot slot, SObjective objective, boolean fromObjective) {
        this.setDisplaySlot(slot, objective, fromObjective, true);
    }

    private void _setDisplaySlot(SAPIDisplaySlot slot, SObjective objective, boolean fromObjective) {
        this.slots.put(slot, objective);
        if (!fromObjective) {
            objective.setDisplaySlot(slot);
        }
    }

    boolean setDisplaySlot(SAPIDisplaySlot slot, SObjective objective, boolean fromObjective, boolean swap) {
        if (!this.slots.containsKey((Object)slot)) {
            this._setDisplaySlot(slot, objective, fromObjective);
            return true;
        }
        int opriority = this.slots.get((Object)slot).getPriority();
        if (objective.getPriority() <= opriority) {
            SAPIDisplaySlot swapSlot = slot.swap();
            SObjective movingObjective = this.slots.get((Object)slot);
            if (!this.slots.containsKey((Object)swapSlot) || opriority <= this.slots.get((Object)swapSlot).getPriority()) {
                this._setDisplaySlot(swapSlot, movingObjective, fromObjective);
            }
            this._setDisplaySlot(slot, objective, fromObjective);
            return true;
        }
        return false;
    }

    @Override
    public SObjective getObjective(SAPIDisplaySlot slot) {
        return this.slots.get((Object)slot);
    }

    @Override
    public SObjective getObjective(String id) {
        return this.objectives.get(id.toUpperCase());
    }

    @Override
    public String getPrintString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<SAPIDisplaySlot, SObjective> entry : this.slots.entrySet()) {
            sb.append("&5").append((Object)entry.getKey()).append(" : ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public SEntry createEntry(OfflinePlayer p) {
        return this.createEntry(p, p.getName());
    }

    @Override
    public SEntry createEntry(OfflinePlayer p, String displayName) {
        return this.handler.getOrCreateEntry(p, displayName);
    }

    @Override
    public SEntry createEntry(String id, String displayName) {
        return this.handler.getOrCreateEntry(id, displayName);
    }

    @Override
    public STeam createTeamEntry(String id, String displayName) {
        SAPITeam st = new SAPITeam(this, id, displayName);
        this.handler.registerEntry(st);
        return st;
    }

    @Override
    public SEntry removeEntry(OfflinePlayer p) {
        SEntry sb = this.handler.getEntry(p);
        if (sb != null) {
            return this.removeEntry(sb);
        }
        return null;
    }

    @Override
    public SEntry removeEntry(SEntry e) {
        if ((e = this.handler.removeEntry(e)) != null) {
            for (SObjective o : this.getObjectives()) {
                o.removeEntry(e);
            }
        }
        return e;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SEntry getEntry(String id) {
        return this.handler.getEntry(id);
    }

    @Override
    public SEntry getEntry(OfflinePlayer player) {
        return this.handler.getEntry(player);
    }

    @Override
    public STeam getTeam(String id) {
        return this.handler.getTeamEntry(id);
    }

    @Override
    public SEntry getOrCreateEntry(OfflinePlayer p) {
        return this.handler.getOrCreateEntry(p);
    }

    @Override
    public Collection<SEntry> getEntries() {
        return this.handler.getEntries();
    }

    @Override
    public void removeScoreboard(Player player) {
    }

    @Override
    public void setScoreboard(Player p) {
    }

    @Override
    public List<SObjective> getObjectives() {
        return new ArrayList<SObjective>(this.objectives.values());
    }

    @Override
    public boolean setEntryDisplayName(String id, String name) {
        SEntry e = this.handler.getEntry(id);
        if (e == null) {
            return false;
        }
        this.setEntryDisplayName(e, name);
        return true;
    }

    @Override
    public void setEntryDisplayName(SEntry entry, String name) {
        entry.setDisplayName(name);
    }

    @Override
    public boolean setEntryNamePrefix(String id, String name) {
        SEntry e = this.handler.getEntry(id);
        if (e == null) {
            return false;
        }
        this.setEntryNamePrefix(e, name);
        return true;
    }

    @Override
    public void setEntryNamePrefix(SEntry entry, String name) {
        entry.setDisplayNamePrefix(name);
    }

    @Override
    public boolean setEntryNameSuffix(String id, String name) {
        SEntry e = this.handler.getEntry(id);
        if (e == null) {
            return false;
        }
        this.setEntryNameSuffix(e, name);
        return true;
    }

    @Override
    public void setEntryNameSuffix(SEntry entry, String name) {
        entry.setDisplayNameSuffix(name);
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public boolean hasThisScoreboard(Player player) {
        return this.handler.contains((OfflinePlayer)player);
    }
}

