/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.scoreboardapi.scoreboard.bukkit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import mc.alk.scoreboardapi.SAPIUtil;
import mc.alk.scoreboardapi.api.SEntry;
import mc.alk.scoreboardapi.api.SScoreboard;
import mc.alk.scoreboardapi.api.STeam;
import mc.alk.scoreboardapi.scoreboard.SAPIDisplaySlot;
import mc.alk.scoreboardapi.scoreboard.SAPIObjective;
import mc.alk.scoreboardapi.scoreboard.SAPIPlayerEntry;
import mc.alk.scoreboardapi.scoreboard.SAPIScore;
import mc.alk.scoreboardapi.scoreboard.bukkit.BScoreboard;
import mc.alk.scoreboardapi.scoreboard.bukkit.BukkitTeam;
import mc.alk.scoreboardapi.scoreboard.bukkit.compat.IScoreboardHandler;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;

public class BObjective
extends SAPIObjective {
    Objective o;
    TreeSet<SAPIScore> scores;
    Set<SEntry> cur15 = new HashSet<SEntry>();
    int worst = Integer.MAX_VALUE;
    static IScoreboardHandler handler;

    public BObjective(SScoreboard board, String id, String displayName, String criteria) {
        this(board, id, displayName, criteria, 50);
    }

    public BObjective(String id, String displayName, String criteria, int priority) {
        this(null, id, displayName, criteria, priority);
    }

    public BObjective(SScoreboard board, String id, String displayName, String criteria, int priority) {
        super(id, displayName, criteria, priority);
        if (board != null) {
            this.setScoreBoard(board);
        }
        this.scores = new TreeSet<SAPIScore>(new Comparator<SAPIScore>(){

            @Override
            public int compare(SAPIScore o1, SAPIScore o2) {
                int c = o2.getScore() - o1.getScore();
                if (c != 0) {
                    return c;
                }
                return o1.getEntry().getID().compareTo(o2.getEntry().getID());
            }
        });
    }

    public void setDisplayName(String displayName) {
        super.setDisplayName(displayName);
        if (this.o == null) {
            return;
        }
        this._setDisplayName();
    }

    public void setDisplayNameSuffix(String suffix) {
        super.setDisplayNameSuffix(suffix);
        if (this.o == null) {
            return;
        }
        this._setDisplayName();
    }

    public void setDisplayNamePrefix(String prefix) {
        super.setDisplayNameSuffix(prefix);
        if (this.o == null) {
            return;
        }
        this._setDisplayName();
    }

    protected void _setDisplayName() {
        super._setDisplayName();
        if (this.o == null) {
            return;
        }
        this.o.setDisplayName(this.getDisplayName());
    }

    public void setScoreBoard(SScoreboard board) {
        if (!(board instanceof BScoreboard)) {
            throw new IllegalStateException("To use BukkitObjectives you must use BukkitScoreboards");
        }
        super.setScoreBoard(board);
        this.o = ((BScoreboard)board).board.getObjective(this.id);
        if (this.o == null) {
            this.o = ((BScoreboard)board).board.registerNewObjective(this.id, this.criteria);
        }
        this.setDisplayName(this.getDisplayName());
    }

    protected boolean setPoints(SAPIScore o, int points) {
        if (o.getEntry() instanceof STeam && this.isDisplayTeams() || o.getEntry() instanceof SAPIPlayerEntry && this.isDisplayPlayers() || !(o.getEntry() instanceof SAPIPlayerEntry) && !(o.getEntry() instanceof STeam)) {
            this.addScore(o, points);
        } else {
            super.setPoints(o, points);
        }
        return true;
    }

    private void addScore(SAPIScore e, int points) {
        this.scores.remove(e);
        e.setScore(points);
        this.scores.add(e);
        if (this.scores.size() <= 15) {
            this._setScore(e.getEntry(), points);
            this.cur15.add(e.getEntry());
            this.worst = Math.min(points, this.worst);
        } else {
            HashSet<SEntry> now15 = new HashSet<SEntry>(15);
            ArrayList<SAPIScore> added = new ArrayList<SAPIScore>(2);
            Iterator<SAPIScore> iter = this.scores.iterator();
            for (int i = 0; i < 15 && iter.hasNext(); ++i) {
                SAPIScore sAPIScore = iter.next();
                now15.add(sAPIScore.getEntry());
                if (this.cur15.contains(sAPIScore.getEntry())) continue;
                added.add(sAPIScore);
            }
            this.cur15.removeAll(now15);
            for (SEntry sEntry : this.cur15) {
                this.o.getScoreboard().resetScores(sEntry.getOfflinePlayer());
            }
            this.cur15 = now15;
            if (added.isEmpty()) {
                if (this.cur15.contains(e.getEntry())) {
                    this._setScore(e.getEntry(), points);
                }
            } else {
                for (SAPIScore sAPIScore : added) {
                    this._setScore(sAPIScore.getEntry(), sAPIScore.getScore());
                }
            }
        }
    }

    private void _setScore(SEntry e, int points) {
        Score sc = this.o.getScore(e.getOfflinePlayer());
        if (points != 0) {
            sc.setScore(points);
        } else {
            sc.setScore(1);
            sc.setScore(0);
        }
    }

    public int getPoints(SEntry l) {
        OfflinePlayer p = l.getOfflinePlayer();
        return this.o.getScore(p).getScore();
    }

    public void setDisplaySlot(SAPIDisplaySlot slot) {
        super.setDisplaySlot(slot);
        if (this.scoreboard == null) {
            return;
        }
        if (this.o != null && this.scoreboard.getObjective(slot) == this) {
            this.o.setDisplaySlot(BObjective.toBukkitDisplaySlot(slot));
        }
    }

    public void setDisplayPlayers(boolean display) {
        if (display == this.isDisplayPlayers()) {
            return;
        }
        this.displayPlayers = display;
        this.setDisplay();
    }

    public void setDisplayTeams(boolean display) {
        if (display == this.isDisplayTeams()) {
            return;
        }
        this.displayTeams = display;
        this.setDisplay();
    }

    private void setDisplay() {
        this.scores.clear();
        this.cur15.clear();
        if (this.scoreboard != null) {
            for (SEntry entry : this.scoreboard.getEntries()) {
                if (!this.contains(entry)) continue;
                if (this.displayPlayers && entry instanceof SAPIPlayerEntry || this.displayTeams && entry instanceof STeam || !(entry instanceof SAPIPlayerEntry) && !(entry instanceof STeam)) {
                    SAPIScore sc = (SAPIScore)this.entries.get(entry);
                    this.addScore(sc, sc.getScore());
                    continue;
                }
                this.o.getScoreboard().resetScores(entry.getOfflinePlayer());
            }
        }
    }

    public static DisplaySlot toBukkitDisplaySlot(SAPIDisplaySlot slot) {
        switch (slot) {
            case BELOW_NAME: {
                return DisplaySlot.BELOW_NAME;
            }
            case PLAYER_LIST: {
                return DisplaySlot.PLAYER_LIST;
            }
            case SIDEBAR: {
                return DisplaySlot.SIDEBAR;
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("&6 --- ").append(this.id).append(" : ").append(this.getDisplayName()).append("&4 : ").append(this.getPriority()).append("\n");
        if (this.scoreboard == null) {
            sb.append("&4 Bukkit scoreboard still not set!!");
            return sb.toString();
        }
        Collection<SEntry> es = this.scoreboard.getEntries();
        if (this.o == null) {
            sb.append("&4 Bukkit Objective still not set!!");
            return sb.toString();
        }
        ArrayList<SEntry> zeroes = new ArrayList<SEntry>();
        ArrayList<SEntry> skipped = new ArrayList<SEntry>();
        for (SEntry e : es) {
            if (!this.contains(e)) {
                skipped.add(e);
                continue;
            }
            Set scores = this.o.getScoreboard().getScores(e.getOfflinePlayer());
            for (Score score : scores) {
                if (!score.getObjective().equals(this.o)) continue;
                if (score.getScore() != 0) {
                    if (e instanceof BukkitTeam) {
                        BukkitTeam bt = (BukkitTeam)e;
                        sb.append("&e ").append(e.getID()).append(" : ").append(e.getDisplayName()).append(" = ").append(score.getScore()).append("  &eteamMembers=\n");
                        for (OfflinePlayer p : bt.getPlayers()) {
                            SEntry ep = this.getScoreboard().getOrCreateEntry(p);
                            String c = this.contains(ep) ? "&e" : "&8";
                            sb.append("  ").append(c).append("- &f").append(bt.getPrefix()).append(p.getName()).append(bt.getSuffix()).append(c).append(" = ").append(this.o.getScore(p).getScore()).append("\n");
                        }
                        continue;
                    }
                    sb.append("&6 ").append(e.getID()).append(" : ").append(e.getDisplayName()).append(" = ").append(score.getScore()).append("\n");
                    continue;
                }
                zeroes.add(e);
            }
        }
        if (!skipped.isEmpty()) {
            sb.append(" &cSkipped Entries: ");
            for (SEntry e : skipped) {
                sb.append("&6 ").append(e.getID()).append(":").append(e.getDisplayName()).append("&e,");
            }
            sb.append("\n");
        }
        if (!zeroes.isEmpty()) {
            sb.append(" &eZero Entries: ");
            for (SEntry e : zeroes) {
                sb.append("&6 '").append(e.getID()).append("':'").append(e.getDisplayName()).append("'&e,");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setDisplayName(String displayNamePrefix, String displayName, String displayNameSuffix, STeam team) {
        String display = SAPIUtil.createLimitedString(displayNamePrefix, displayName, displayNameSuffix, 32);
        handler.setDisplayName(this.o, team, display);
    }

    static {
        try {
            String pkg = Bukkit.getServer().getClass().getPackage().getName();
            String version = pkg.substring(pkg.lastIndexOf(46) + 1);
            if (version.equalsIgnoreCase("craftbukkit")) {
                handler = IScoreboardHandler.BLANK_HANDLER;
            } else {
                Class<?> clazz = Class.forName("mc.alk.scoreboardapi.scoreboard.bukkit.compat." + version + ".ScoreboardHandler");
                Class[] args = new Class[]{};
                handler = (IScoreboardHandler)clazz.getConstructor(args).newInstance(args);
            }
        }
        catch (Exception e) {
            handler = IScoreboardHandler.BLANK_HANDLER;
        }
    }
}

