/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.scoreboardapi.scoreboard.bukkit;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mc.alk.scoreboardapi.api.SEntry;
import mc.alk.scoreboardapi.api.SObjective;
import mc.alk.scoreboardapi.scoreboard.SAPIDisplaySlot;
import mc.alk.scoreboardapi.scoreboard.SAPIObjective;
import mc.alk.scoreboardapi.scoreboard.SAPIScoreboard;
import mc.alk.scoreboardapi.scoreboard.SAPITeam;
import mc.alk.scoreboardapi.scoreboard.bukkit.BObjective;
import mc.alk.scoreboardapi.scoreboard.bukkit.BukkitTeam;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;

public class BScoreboard
extends SAPIScoreboard {
    protected Scoreboard board;
    HashMap<String, Scoreboard> oldBoards = new HashMap();

    public BScoreboard(Plugin plugin, String name) {
        super(plugin, name);
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        this.board = manager.getNewScoreboard();
    }

    public SAPIObjective registerNewObjective(String id, String displayName, String criteria, SAPIDisplaySlot slot) {
        BObjective o = new BObjective(this, id, displayName, criteria);
        o.setDisplayName(displayName);
        o.setDisplaySlot(slot);
        this.registerNewObjective(o);
        return o;
    }

    public void setScoreboard(final Player p) {
        if (p.getScoreboard() != null && !this.oldBoards.containsKey(p.getName())) {
            this.oldBoards.put(p.getName(), p.getScoreboard());
        }
        new BukkitRunnable(){

            public void run() {
                if (BScoreboard.this.oldBoards.containsKey(p.getName())) {
                    p.setScoreboard(BScoreboard.this.board);
                }
            }
        }.runTask(this.plugin);
    }

    public void removeScoreboard(Player player) {
        try {
            Scoreboard b = this.oldBoards.remove(player.getName());
            if (b != null) {
                player.setScoreboard(b);
            } else {
                player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void transferOldScoreboards(BScoreboard oldScoreboard) {
        this.oldBoards.putAll(oldScoreboard.oldBoards);
    }

    private BoardUpdate clearBoard(SEntry e) {
        HashMap<Objective, Integer> oldScores = new HashMap<Objective, Integer>();
        Set scores = this.board.getScores(e.getOfflinePlayer());
        for (Score score : scores) {
            oldScores.put(score.getObjective(), score.getScore());
        }
        this.board.resetScores(e.getOfflinePlayer());
        Team t = this.board.getPlayerTeam(e.getOfflinePlayer());
        if (t != null) {
            t.removePlayer(e.getOfflinePlayer());
        }
        return new BoardUpdate(oldScores, t);
    }

    private void updateBoard(SEntry e, BoardUpdate bu) {
        if (bu.team != null) {
            bu.team.addPlayer(e.getOfflinePlayer());
        }
        for (Map.Entry<Objective, Integer> entry : bu.scores.entrySet()) {
            if (entry.getValue() == 0) {
                entry.getKey().getScore(e.getOfflinePlayer()).setScore(1);
            }
            entry.getKey().getScore(e.getOfflinePlayer()).setScore(entry.getValue().intValue());
        }
    }

    public void setEntryDisplayName(SEntry e, String name) {
        BoardUpdate bu = this.clearBoard(e);
        super.setEntryDisplayName(e, name);
        this.updateBoard(e, bu);
    }

    public void setEntryNamePrefix(SEntry e, String name) {
        BoardUpdate bu = this.clearBoard(e);
        super.setEntryNamePrefix(e, name);
        this.updateBoard(e, bu);
    }

    public void setEntryNameSuffix(SEntry e, String name) {
        BoardUpdate bu = this.clearBoard(e);
        super.setEntryNameSuffix(e, name);
        this.updateBoard(e, bu);
    }

    public SEntry removeEntry(SEntry e) {
        this.board.resetScores(e.getOfflinePlayer());
        Team t = this.board.getPlayerTeam(e.getOfflinePlayer());
        if (t != null) {
            t.removePlayer(e.getOfflinePlayer());
        }
        return super.removeEntry(e);
    }

    public Scoreboard getBukkitScoreboard() {
        return this.board;
    }

    public SAPITeam createTeamEntry(String id, String displayName) {
        SAPITeam st = this.getTeam(id);
        if (st != null) {
            return st;
        }
        Team t = this.board.getTeam(id);
        if (t == null) {
            t = this.board.registerNewTeam(id);
        }
        t.setDisplayName(displayName);
        BukkitTeam bt = new BukkitTeam(this, t);
        this.handler.registerEntry(bt);
        return bt;
    }

    public SAPITeam getTeam(String id) {
        SEntry e = this.handler.getEntry(id);
        return e == null || !(e instanceof SAPITeam) ? null : (SAPITeam)e;
    }

    public void addAllEntries(SObjective objective) {
        for (SEntry entry : this.handler.getEntries()) {
            objective.addEntry(entry, 0);
        }
    }

    public boolean hasThisScoreboard(Player player) {
        return this.board != null && player.getScoreboard() != null && player.getScoreboard().equals(this.board);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BoardUpdate {
        HashMap<Objective, Integer> scores;
        Team team;

        BoardUpdate(HashMap<Objective, Integer> scores, Team team) {
            this.scores = scores;
            this.team = team;
        }
    }
}

