/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.scoreboardapi.scoreboard.bukkit;

import java.util.Collection;
import java.util.Set;
import mc.alk.scoreboardapi.api.SEntry;
import mc.alk.scoreboardapi.api.SObjective;
import mc.alk.scoreboardapi.scoreboard.SAPIObjective;
import mc.alk.scoreboardapi.scoreboard.SAPITeam;
import mc.alk.scoreboardapi.scoreboard.bukkit.BScoreboard;
import org.bukkit.OfflinePlayer;
import org.bukkit.scoreboard.Team;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BukkitTeam
extends SAPITeam {
    Team team;

    public BukkitTeam(BScoreboard board, Team team) {
        super(board, team.getName(), team.getDisplayName());
        this.team = team;
    }

    @Override
    public void addPlayers(Collection<? extends OfflinePlayer> players) {
        for (OfflinePlayer offlinePlayer : players) {
            this.team.addPlayer(offlinePlayer);
        }
        if (this.board != null) {
            for (SObjective sObjective : this.board.getObjectives()) {
                if (!sObjective.isDisplayPlayers() || !sObjective.contains(this)) continue;
                for (OfflinePlayer player : this.team.getPlayers()) {
                    SEntry e = sObjective.getScoreboard().getEntry(player);
                    if (sObjective.getPoints(e) != -1) continue;
                    sObjective.addEntry(player, 0);
                }
            }
        }
    }

    @Override
    public void addPlayer(OfflinePlayer p) {
        super.addPlayer(p);
        this.team.addPlayer(p);
        if (this.board != null) {
            for (SObjective o : this.board.getObjectives()) {
                SEntry e;
                if (!o.isDisplayPlayers() || !o.contains(this) || o.getPoints(e = o.getScoreboard().getEntry(p)) != -1) continue;
                o.addEntry(p, 0);
            }
        }
    }

    @Override
    public void removePlayer(OfflinePlayer p) {
        super.removePlayer(p);
        this.team.removePlayer(p);
    }

    @Override
    public Set<OfflinePlayer> getPlayers() {
        return this.team.getPlayers();
    }

    @Override
    public void setPrefix(String prefix) {
        prefix = SAPIObjective.colorChat(prefix);
        super.setPrefix(prefix);
        this.team.setPrefix(prefix);
    }

    @Override
    public void setSuffix(String suffix) {
        suffix = SAPIObjective.colorChat(suffix);
        super.setSuffix(suffix);
        this.team.setSuffix(suffix);
    }

    @Override
    public String getPrefix() {
        return this.team.getPrefix();
    }

    @Override
    public String getSuffix() {
        return this.team.getSuffix();
    }

    @Override
    public int size() {
        return this.team.getSize();
    }
}

