package net.cheatingessentials.util;

import net.minecraft.block.Block;

public class BlockFilter {

	public static String idToBlockName(int id){
		 for (Block block : Block.blocksList) {
			   if (block == null) {
				   continue;
			   }
			   if (block.blockID == id) {
				   return block.getLocalizedName();
			   }
		 }
		 
		 return "";
	}
	
	public static int blockNametoID(String name){
		for (Block block : Block.blocksList) {
			   if (block == null) {
				   continue;
			   }
			   
			   String s = block.getLocalizedName().replaceAll(" ", "").toLowerCase();
			   if(name.equalsIgnoreCase(s)){
				   return block.blockID;
			   }
		 }
		 
		 return 90000;
	}
}
