/*
 * Decompiled with CFR 0.152.
 */
package com.mrinspector.plugin;

import com.ricbyte.api.API;
import java.io.IOException;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.mcstats.Metrics;

public class MPK
extends JavaPlugin
implements Listener {
    public static Economy eco = null;

    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
        try {
            Metrics metrics = new Metrics((Plugin)this);
            metrics.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.setupEconomy()) {
            this.getLogger().severe(String.format("[%s] - Disabled due to no Vault dependency found!", this.getDescription().getName()));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        eco = (Economy)rsp.getProvider();
        return eco != null;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Player p = (Player)sender;
        if (cmd.getName().equalsIgnoreCase("mpkreload")) {
            super.reloadConfig();
            p.sendMessage(ChatColor.GOLD + "[MPK] " + ChatColor.GRAY + "You have reloaded config.");
        }
        return false;
    }

    @EventHandler
    public void onQuit(PlayerJoinEvent e) {
        e.getPlayer().sendMessage(ChatColor.GOLD + "[MPK] " + ChatColor.GREEN + "Running MPK version 3.1.0 by" + ChatColor.GRAY + "MrInspector.");
    }

    @EventHandler
    public void onPvE(PlayerDeathEvent e) {
        if (e.getEntity() instanceof Animals && e.getEntity().getKiller() instanceof Player) {
            String entitykillmsg = super.getConfig().getString("EntityKillMessage").replace("{killersname}", e.getEntity().getPlayer().getKiller().getName().replace("{mob}", e.getEntity().getType().toString()));
            double amountonentitykill = super.getConfig().getDouble("AmountOnEntityKill");
            eco.depositPlayer(e.getEntity().getKiller().getName(), amountonentitykill);
            e.getEntity().getKiller().sendMessage(entitykillmsg);
        }
    }

    @EventHandler
    public void onMaxHealth(PlayerDeathEvent e) {
        API.setHealth(e.getEntity().getPlayer(), 20);
    }

    @EventHandler
    public void onKillAndDeath(PlayerDeathEvent e) {
        if (e.getEntity().getPlayer().getKiller().hasPermission("mpk.recievefunds")) {
            String messageonkill = super.getConfig().getString("MessageOnKill").replace("{killersname}", e.getEntity().getPlayer().getKiller().getName()).replace("{name}", e.getEntity().getPlayer().getName());
            String messageondeath = super.getConfig().getString("MessageOnDeath").replace("%player%", e.getEntity().getPlayer().getName());
            double amountonkill = super.getConfig().getDouble("AmountOnKill");
            double amountondeath = super.getConfig().getDouble("AmountOnDeath");
            double healthonkill = super.getConfig().getDouble("HealthOnKill");
            double maxhealthonkill = super.getConfig().getDouble("MaxHealthOnKill");
            e.getEntity().getPlayer().getKiller().sendMessage(messageonkill);
            e.getEntity().getPlayer().sendMessage(messageondeath);
            API.addHealth(e.getEntity().getPlayer().getKiller(), (int)healthonkill);
            API.setMaxHealth(e.getEntity().getPlayer().getKiller(), (int)maxhealthonkill);
            eco.depositPlayer(e.getEntity().getPlayer().getKiller().getName(), amountonkill);
            eco.withdrawPlayer(e.getEntity().getPlayer().getName(), amountondeath);
            if (e.getEntity().getPlayer().getKiller().hasPermission("mpk.receivevipfunds")) {
                String vipmessageonkill = super.getConfig().getString("VIPMessageOnKill").replace("{killersname}", e.getEntity().getPlayer().getKiller().getName()).replace("{name}", e.getEntity().getPlayer().getName());
                String vipmessageondeath = super.getConfig().getString("VIPMessageOnDeath").replace("%player%", e.getEntity().getPlayer().getName());
                double vipamountonkill = super.getConfig().getDouble("VIPAmountOnKill");
                double vipamountondeath = super.getConfig().getDouble("VIPAmountOnDeath");
                double viphealthonkill = super.getConfig().getDouble("VIPHealthOnKill");
                double vipmaxhealthonkill = super.getConfig().getDouble("VIPMaxHealthOnKill");
                API.addHealth(e.getEntity().getPlayer().getKiller(), (int)viphealthonkill);
                API.setMaxHealth(e.getEntity().getPlayer().getKiller(), (int)vipmaxhealthonkill);
                e.getEntity().getPlayer().getKiller().sendMessage(vipmessageonkill);
                e.getEntity().getPlayer().sendMessage(vipmessageondeath);
                eco.depositPlayer(e.getEntity().getPlayer().getKiller().getName(), vipamountonkill);
                eco.withdrawPlayer(e.getEntity().getPlayer().getName(), vipamountondeath);
            }
        }
    }
}

