/**
* ShowCaseStandalone
* Copyright (C) 2012 Kellerkindt <copyright at kellerkindt.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
package com.kellerkindt.scs.commands;

import java.util.UUID;

import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;

import com.kellerkindt.scs.Properties;
import com.kellerkindt.scs.ShowCaseStandalone;
import com.kellerkindt.scs.exceptions.InsufficientPermissionException;
import com.kellerkindt.scs.exceptions.MissingOrIncorrectArgumentException;
import com.kellerkindt.scs.internals.Todo;
import com.kellerkindt.scs.internals.Todo.Type;
import com.kellerkindt.scs.shops.ExchangeShop;
import com.kellerkindt.scs.utilities.Term;
import com.kellerkindt.scs.utilities.Utilities;

public class ExchangeCmd extends GenericCmd {

	public ExchangeCmd (ShowCaseStandalone scs, CommandSender sender, String args[]){
        super(scs, sender, args);
        this.permission = Properties.permCreateExchange; 
	}
	
	@Override
	public boolean execute() throws MissingOrIncorrectArgumentException, InsufficientPermissionException {
		if (errorCheck()) {
			return true;
		}

		if(scs.getConfiguration().getWorldsBlacklisted().contains(player.getWorld().getName())) {
            throw new InsufficientPermissionException( Term.BLACKLIST_WORLD.get() );
        }
		
		//Default values:
        int 		amount 		= 0;
        boolean		unlimited	= false;
        int 		price 		= 1;
        ItemStack 	is 			= null;
        ItemStack	ex			= null;
        
        /* Using keyword "this" will attempt to sell whats in your hand.  
         *      ie. default values for material and amount are what's in your hand.
         * 
         * Otherwise default value for amount is 1.
         * 
         * Valid forms of command:
         * 1: scs exchange [item/"this"] [item/"this"]
         * 2: scs exchange [item/"this"] [item/"this"] [amount]
         * 3: scs exchange [item/"this"] [item/"this"] [amount] [price]
         */
        
        
        //We have optional number of arguments.  Lets parse through them.
        try {
            switch (args.length){
                case 0:
                case 1:
                case 2:
                	throw new MissingOrIncorrectArgumentException();
                	
                case 3:
                	is = Utilities.getItemStack(player, args[1]);
                    ex = Utilities.getItemStack(player, args[2]);
                    break;
                    
                case 4:
                    is = Utilities.getItemStack(player, args[1]);
                    ex = Utilities.getItemStack(player, args[2]);
                    if (args[3].equalsIgnoreCase("unlimited"))
                        unlimited = true;
                    else 
                        amount = Integer.parseInt(args[3]);
                    break;
                    
                case 5:
                	is = Utilities.getItemStack(player, args[1]);
                    ex = Utilities.getItemStack(player, args[2]);
                    if (args[3].equalsIgnoreCase("unlimited"))
                        unlimited = true;
                    else 
                        amount = Integer.parseInt(args[3]);
                    price	= Integer.parseInt(args[4]);
                    
                    if (price <= 0)
                    	throw new MissingOrIncorrectArgumentException();
                    break;
            }
            
        } catch (Exception e) {
            throw new MissingOrIncorrectArgumentException ();
        }
		
        if (is == null || is.getTypeId() == 0 || ex == null || ex.getTypeId() == 0) {
        	throw new MissingOrIncorrectArgumentException (Term.ITEM_MISSING.get()+",is="+is+",ex="+ex);
        }
        

        // if the id already exists, the ShopHandler will set a new one
        ExchangeShop	shop	= new ExchangeShop(UUID.randomUUID(), player.getUniqueId(), null, is.clone(), ex.clone());
        
        shop.setAmount		(amount);
        shop.setUnlimited	(unlimited);
        shop.setPrice		(price);

        scs.msgPlayer(player, next);
        scs.addTodo(player, new Todo (player, Type.CREATE, shop, 0, null));

        return true;
	}
	
}
