/**
* ShowCaseStandalone
* Copyright (C) 2012 Kellerkindt <copyright at kellerkindt.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
package com.kellerkindt.scs.commands;

import java.util.ArrayList;
import java.util.List;

import org.bukkit.command.CommandSender;

import com.kellerkindt.scs.Properties;
import com.kellerkindt.scs.ShowCaseStandalone;
import com.kellerkindt.scs.exceptions.InsufficientPermissionException;
import com.kellerkindt.scs.exceptions.MissingOrIncorrectArgumentException;
import com.kellerkindt.scs.shops.Shop;
import com.kellerkindt.scs.utilities.Messaging;
import com.kellerkindt.scs.utilities.Term;

public class ListCmd extends GenericCmd {
	
	private static final String SEPERATOR	= ",";
	
	public ListCmd(ShowCaseStandalone scs, CommandSender cs, String args[]){
		super(scs, cs, args);
		this.mustBePlayer	= false;
		this.permission		= Properties.permAdmin;
		this.minArg			= 2;
	}

	@Override
	public boolean execute() throws MissingOrIncorrectArgumentException, InsufficientPermissionException {
		if (errorCheck())
			return true;
		
		String 			player		= args[1];
		int				ownerOf		= 0;
		int				memberOf	= 0;
		List<String>	worlds		= new ArrayList<String>();
		StringBuilder	sWorlds		= new StringBuilder();
		
		for (Shop p : scs.getShopHandler()) {
			boolean addWorld	= false;
			
			// check for owner
			if (p.isOwner(scs.getPlayerUUID(player))) {
				ownerOf++;
				addWorld	= true;
			}
			
			// check for member
			else if (p.isMember(scs.getPlayerUUID(player))) {
				memberOf++;
				addWorld	= true;
			}
			
			// get world name
			String	world	= p.getLocation().getWorld().getName();
			
			// add world name
			if (addWorld && !worlds.contains(world)) {
				worlds.add(world);
			}
		}
		
		
		boolean seperator = false;
		for (String s : worlds) {
			if (seperator)
				sWorlds.append(SEPERATOR);
			
			sWorlds.append(s);
			
			seperator = true;
		}
		
		Messaging.send(this.cs, Term.MESSAGE_LIST.get(player, ""+ownerOf, ""+memberOf, sWorlds.toString()));
		
		return true;
	}

}