/**
* ShowCaseStandalone
* Copyright (C) 2012 Kellerkindt <copyright at kellerkindt.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
package com.kellerkindt.scs.commands;

import org.bukkit.command.CommandSender;

import com.kellerkindt.scs.Properties;
import com.kellerkindt.scs.ShowCaseStandalone;
import com.kellerkindt.scs.exceptions.InsufficientPermissionException;
import com.kellerkindt.scs.exceptions.MissingOrIncorrectArgumentException;
import com.kellerkindt.scs.internals.Todo;
import com.kellerkindt.scs.internals.Todo.Type;
import com.kellerkindt.scs.utilities.Messaging;
import com.kellerkindt.scs.utilities.Term;

public class MemberCmd extends GenericCmd {
	
	public MemberCmd(ShowCaseStandalone scs, CommandSender cs, String args[]){
		super(scs, cs, args);
		this.mustBePlayer	= true;
		this.permission		= Properties.permManage;
		this.minArg			= 3;
	}

	@Override
	public boolean execute() throws MissingOrIncorrectArgumentException, InsufficientPermissionException {
		if (errorCheck())
			return true;
		
		Type	type	= null;
		
		if (this.args[1].equalsIgnoreCase("add"))
			type = Type.ADD_MEMBER;
		
		if (this.args[1].toLowerCase().startsWith("rem"))
			type = Type.REMOVE_MEMBER;
		
		if (type == null)
			throw new MissingOrIncorrectArgumentException();
		
		Todo	todo	= new Todo(player, type, null, 0, args[2]);
		scs.addTodo(this.player, todo);
		
		Messaging.send(player, Term.NEXT.get());
		
		return true;
	}

}
