/**
* ShowCaseStandalone
* Copyright (C) 2012 Kellerkindt <copyright at kellerkindt.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
package com.kellerkindt.scs.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.bukkit.command.CommandSender;

import com.kellerkindt.scs.Properties;
import com.kellerkindt.scs.ShowCaseStandalone;
import com.kellerkindt.scs.exceptions.InsufficientPermissionException;
import com.kellerkindt.scs.exceptions.MissingOrIncorrectArgumentException;
import com.kellerkindt.scs.shops.Shop;
import com.kellerkindt.scs.utilities.Messaging;
import com.kellerkindt.scs.utilities.Term;

public class PurgeCmd extends GenericCmd {
	
	public static final String WILDCARD		= "*";
	public static final String PREFIX_WORLD	= "w:";
	public static final String PREFIX_UUID	= "u:";
	
	// <playername of shops, shops>
	private static HashMap<String, List<Shop>>	toDelete	= new HashMap<String, List<Shop>>();
	
	public PurgeCmd(ShowCaseStandalone scs, CommandSender cs, String args[]){
		super(scs, cs, args);
		this.mustBePlayer	= false;
		this.permission		= Properties.permAdmin;
		this.minArg			= 2;
	}

	@Override
	public boolean execute() throws MissingOrIncorrectArgumentException, InsufficientPermissionException {
		if (errorCheck())
			return true;
		
		String			name		= args[1];
		String			world		= null;
		boolean			ignoreWorld	= false;
		boolean			isUUID		= false;
		boolean			isPlayer	= true;
		
		// delete whole world?
		if (name.startsWith(PREFIX_WORLD)) {
			name 		= name.substring(PREFIX_WORLD.length());
			isPlayer	= false;
		}
		
		// by uuid?
		else if (name.startsWith(PREFIX_UUID)) {
			name		= name.substring(PREFIX_UUID.length());
			isPlayer	= false;
			isUUID		= true;
		}
		
		// load if already searched for
		List<Shop>		toRemove	= toDelete.get(name);
		
		// world was given
		if (args.length > 2) {
			world	= args[2];
		}
		
//		// console and no world was given
//		if (this.player == null && world == null && toRemove == null) {
//			Messaging.send(cs, Term.ERROR_MISSING_ARGUMENT_WORLD.get());
//			return true;
//		}
		
		// player and no world was given -> current world
		if (world == null && toRemove == null && this.player != null)
			world = this.player.getWorld().getName();
		
		// wildcard?
		if (world == null || WILDCARD.equals(world)) {
			ignoreWorld = true;
		}
		
		// first call: find the shops
		if (toRemove == null) {
			toRemove	= new ArrayList<Shop>();
			
			for (Shop p : scs.getShopHandler()) {
				
				// get the world name safely
				String worldMatcher = !isUUID && p.getWorld() != null
						? p.getWorld().getName()
						: isUUID
							? p.getWorldUUID().toString()
							: null;
			
				if ( isPlayer && p.isOwner( scs.getPlayerUUID(name) ) && (ignoreWorld || world.equals(worldMatcher) )) {
					toRemove.add(p);
				
				} else if ( !isPlayer && world.equals(worldMatcher) ) {
					toRemove.add(p);
				}
				
			}
				
			
			if (toRemove.size() > 0)  {
				Messaging.send(cs, Term.MESSAGE_PURGE_FOUND.get(""+toRemove.size()));
				toDelete.put(name, toRemove);
			
			} else
				Messaging.send(cs, Term.ERROR_PURGE_ZERO_SHOPS.get());
			
		// second call: remove the shops
		} else {
			
			// delete them
			for (Shop p : toRemove)
				scs.getShopHandler().removeShop(p);
			
			// cleanup
			toDelete.put(name, null);
			
			Messaging.send(cs, Term.MESSAGE_PURGE_DELETED.get(""+toRemove.size(), name));
			
		}
		
		return true;
	}

}