/**
* ShowCaseStandalone
* Copyright (C) 2014 Kellerkindt <copyright at kellerkindt.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
package com.kellerkindt.scs.commands;

import org.bukkit.Material;
import org.bukkit.command.CommandSender;

import com.kellerkindt.scs.Properties;
import com.kellerkindt.scs.ShowCaseStandalone;
import com.kellerkindt.scs.exceptions.InsufficientPermissionException;
import com.kellerkindt.scs.exceptions.MissingOrIncorrectArgumentException;
import com.kellerkindt.scs.interfaces.PriceRangeHandler;
import com.kellerkindt.scs.utilities.Messaging;
import com.kellerkindt.scs.utilities.Term;

/**
 *
 * @author michael <michael at kellerkindt.com>
 */
public class RangeCmd extends GenericCmd {
	
	public RangeCmd(ShowCaseStandalone scs, CommandSender cs, String args[]){
        super(scs, cs, args);

        this.mustBePlayer	= false;
        this.permission 	= Properties.permAdmin;
        this.minArg			= 2;
    }

	@Override
	public boolean execute() throws MissingOrIncorrectArgumentException, InsufficientPermissionException {
		
		if (errorCheck()) {
			return true;
		}
		
		
		// try to get the material?
		Material material = Material.getMaterial(args[1].toUpperCase());
		
		// failed? because global is requested?
		if (material == null && !"global".equalsIgnoreCase(args[1]) && !"remove".equalsIgnoreCase(args[1])) {
			throw new MissingOrIncorrectArgumentException();
		}
		
		PriceRangeHandler 	handler = scs.getPriceRangeHandler();
		boolean				global	= material == null && "global".equalsIgnoreCase(args[1]);
		boolean				remove	= material == null && "remove".equalsIgnoreCase(args[1]);
		double				min		= 0;
		double				max		= Double.MAX_VALUE;
		

		String message = null;
		
		if (!remove) {
			try {
				// the first one is the min value
				if (args.length > 2) {
					min	= Double.parseDouble(args[2]);
				}
				
				// the (optional) second one ist the max value
				if (args.length > 3) {
					max = Double.parseDouble(args[3]);
				}
				
			} catch (Throwable t) {
				throw new MissingOrIncorrectArgumentException();
			}
			
			
			
			
			// update
			if (args.length > 2) {
				if (global) {
					handler.setGlobalMin(min);
					
					if (args.length > 3) {
						handler.setGlobalMax(max);
					} else {
						max = handler.getGlobalMax();
					}
					
					if (max == Double.MAX_VALUE) {
						max = Double.POSITIVE_INFINITY;
					}
					message = Term.MESSAGE_PRICERANGE_UPDATED_GLOBAL.get(Double.toString(min), Double.toString(max));
					
				} else {
					handler.setMin(material, min);
					
					if (args.length > 3) {
						handler.setMax(material, max);
					} else {
						max = handler.getMax(material);
					}
					
					if (max == Double.MAX_VALUE) {
						max = Double.POSITIVE_INFINITY;
					}
					
					message = Term.MESSAGE_PRICERANGE_UPDATED.get(material.toString(), Double.toString(min), Double.toString(max));
				}
				
				
			} else {
				min = handler.getMin(material);
				max = handler.getMax(material);
				
				if (max == Double.MAX_VALUE) {
					max = Double.POSITIVE_INFINITY;
				}
				
				if (global) {
					message = Term.MESSAGE_PRICERANGE_GLOBAL.get(Double.toString(min), Double.toString(max));
				} else {
					message = Term.MESSAGE_PRICERANGE.get(material.toString(), Double.toString(min), Double.toString(max));
				}
				
			}
			
			
			
			
			
		} else {
			// remove
			if (args.length < 3) {
				throw new MissingOrIncorrectArgumentException();
			}
			
			material = Material.getMaterial(args[2].toUpperCase());
			
			if (material == null) {
				throw new MissingOrIncorrectArgumentException();
			}
			
			handler.remove(material);
			message = Term.MESSAGE_PRICERANGE_REMOVED.get(material.toString());
		}
		
		
		// aaaaaand finally, send it to the sender
		// --- ever told you how I fucking hate writing commands?
		Messaging.send(cs, message);
		
		
		return true;
	}

}
