/**
* ShowCaseStandalone
* Copyright (C) 2012 Kellerkindt <copyright at kellerkindt.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
package com.kellerkindt.scs.commands;

import java.util.HashSet;
import java.util.Set;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;

import com.kellerkindt.scs.Properties;
import com.kellerkindt.scs.ShowCaseStandalone;
import com.kellerkindt.scs.exceptions.InsufficientPermissionException;
import com.kellerkindt.scs.exceptions.MissingOrIncorrectArgumentException;
import com.kellerkindt.scs.shops.Shop;
import com.kellerkindt.scs.utilities.Messaging;
import com.kellerkindt.scs.utilities.Term;

public class RepairCmd extends GenericCmd {
    
    public RepairCmd(ShowCaseStandalone scs, CommandSender cs, String args[]){
        super(scs, cs, args);
        this.mustBePlayer	= false;
        this.permission 	= Properties.permRepair;
    }

    @Override
    public boolean execute() throws MissingOrIncorrectArgumentException, InsufficientPermissionException {
    	if ( errorCheck() ) {
    		return true;
    	}
    	
    	Set<Shop> restoreable 	= new HashSet<Shop>();
    	Set<Shop> deleteable 	= new HashSet<Shop>();
    	
    	//prepare
    	for ( Shop shop : this.scs.getShopHandler() ) {
    		//get blocks
	    	Block shopBlock = shop.getBlock();
	    	Block itemBlock = shopBlock.getWorld().getBlockAt( shopBlock.getX(), shopBlock.getY() + 1, shopBlock.getZ() );
    		
	    	//decide what to do with a shop
        	if ( shopBlock.getTypeId() == 0 && itemBlock.getTypeId() != 0 ) {
    			deleteable.add( shop );
    		} else if ( shopBlock.getTypeId() == 0 ) {
    			restoreable.add( shop );
    		} else if ( itemBlock.getTypeId() != 0 ) {
    			deleteable.add( shop );
    		}
    		
    	}
    	
    	if ( args.length == 1 ) {
    		//output
    		Messaging.send( cs, Term.REPAIR_INFO	.get( restoreable.size() + restoreable.size() + deleteable.size() + "" ) );
    		Messaging.send( cs, Term.REPAIR_HELP_1	.get( restoreable.size() + "" ) );
    		Messaging.send( cs, Term.REPAIR_HELP_2	.get( deleteable.size()  + "" ) );
    		return true;
    	}
    	
    	else if ( args[1].equalsIgnoreCase( "restore" ) ) {
    		//output
    		Messaging.send( cs, Term.REPAIR_INFO	.get( restoreable.size() + "" ) );
    		Messaging.send( cs, Term.RESTORE_START	.get() );
    		
    		//restore
    		for ( Shop shop : restoreable ) {
    			shop.getBlock().setType( Material.BEDROCK );
    		}
    		
    		// items may moved after block was set
    		scs.getShopHandler().hideAll();
    		scs.getShopHandler().showAll();
    		
    		//output
    		Messaging.send( cs, Term.RESTORE_END	.get( restoreable.size() + "" ) );
    		
    		return true;
    	} else if ( args[1].equalsIgnoreCase( "delete" ) ) {
    		//output
    		Messaging.send( cs, Term.REPAIR_INFO	.get( deleteable.size() + "" ) );
    		Messaging.send( cs, Term.DELETE_START	.get() );
    		
    		//delete
    		for ( Shop shop : deleteable ) {

//    			shop.hide();	// done in remove
    			this.scs.getShopHandler().removeShop( shop );
    		}
    		
    		//output
    		Messaging.send( cs, Term.DELETE_END		.get( deleteable.size() + "" ) );
    		
    		return true;    		
    	}
    	
    	return false;
    	
//        if(errorCheck())
//            return true;
//        
//        scs.removeTodo(player);
//        Messaging.send(player, Term.ABORT.get());
////        Messaging.send(player, Localization.get("abort")); //Messages: abort
////        Messaging.send(player, "`yShowcase operation aborted."); //Messages: abort
//        
//        return true;
    }
}
