/**
* ShowCaseStandalone
* Copyright (C) 2012 Kellerkindt <copyright at kellerkindt.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
package com.kellerkindt.scs.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

import com.kellerkindt.scs.Properties;
import com.kellerkindt.scs.ShowCaseStandalone;
import com.kellerkindt.scs.exceptions.InsufficientPermissionException;
import com.kellerkindt.scs.exceptions.MissingOrIncorrectArgumentException;
import com.kellerkindt.scs.utilities.Messaging;
import com.kellerkindt.scs.utilities.Term;

public class ReportCmd extends GenericCmd {
	
	private static final SimpleDateFormat	DATE_FORMATTER		= new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
	private static final String				DATE_SPLITTER		= ":";
	private static final String				DATE_SPLITTER_FILE	= "-";
	private static final String				SUFFIX				= "_report.txt";
	
	public ReportCmd (ShowCaseStandalone scs, CommandSender cs, String args[]){
        super(scs, cs, args);
        this.mustBePlayer	= false;
        this.permission 	= Properties.permAdmin;
    }

	@Override
	public boolean execute() throws MissingOrIncorrectArgumentException, InsufficientPermissionException {
		if (errorCheck())
			return true;
		
		
		try {
			
			String	date 		= DATE_FORMATTER.format(new Date());
			String	dateFile	= date.replace(DATE_SPLITTER, DATE_SPLITTER_FILE);	
			File	file 		= new File(scs.getDataFolder(), dateFile+SUFFIX);
			
			FileOutputStream	fos	= new FileOutputStream(file);
			PrintStream			ps	= new PrintStream(fos);
			
			ps.println("---- SCS report, created at     " + date + " ----");
			ps.println(" - Current SCS version:          "+Properties.buildNumber);
			ps.println(" - Current storage version:      "+Properties.VERSION_STORAGE);
			ps.println(" - Current Bukkit version:       "+scs.getServer().getVersion());
			ps.println(" - Startup:                      "+DATE_FORMATTER.format(ShowCaseStandalone.getStartup()));
			ps.println(" - Total warnings since startup: "+ShowCaseStandalone.getTotalWarnings());
			
			for (Date d : ShowCaseStandalone.getWarnings().keySet())
				ps.println("   "+DATE_FORMATTER.format(d) + ": "+ShowCaseStandalone.getWarnings().get(d));
			
			ps.println(" - Plugin list:");
			
			for (Plugin p : scs.getServer().getPluginManager().getPlugins())
				ps.println("   "+p.getName() + " " + p.getDescription().getVersion());
			
			ps.println("---- SCS report, end ----");
			
			ps.flush();
			fos.flush();
			
			ps.close();
			fos.close();
			
			
			Messaging.send(cs, "Saved to: "+file.getAbsolutePath());
		} catch (Exception e) {
			Messaging.send(cs, Term.ERROR.get()+e.getMessage());
			e.printStackTrace();
		}
		
		
		
		return true;
	}

}
