/**
* ShowCaseStandalone
* Copyright (C) 2012 Kellerkindt <copyright at kellerkindt.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
package com.kellerkindt.scs.commands;

import java.util.UUID;

import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;

import com.kellerkindt.scs.Properties;
import com.kellerkindt.scs.ShowCaseStandalone;
import com.kellerkindt.scs.exceptions.InsufficientPermissionException;
import com.kellerkindt.scs.exceptions.MissingOrIncorrectArgumentException;
import com.kellerkindt.scs.internals.Todo;
import com.kellerkindt.scs.internals.Todo.Type;
import com.kellerkindt.scs.shops.SellShop;
import com.kellerkindt.scs.utilities.Term;
import com.kellerkindt.scs.utilities.Utilities;


/**
 * @author Sorklin <sorklin at gmail.com>
 */
public class SellCmd extends GenericCmd {
    
    public SellCmd(ShowCaseStandalone scs, CommandSender cs, String args[]){
        super(scs, cs, args);
        this.permission = Properties.permCreateSell;
    }

    @Override
    public boolean execute() throws MissingOrIncorrectArgumentException, InsufficientPermissionException {
        if(errorCheck()) {
            return true;
        }
        
        if(scs.getConfiguration().getWorldsBlacklisted().contains(player.getWorld().getName())) {
            throw new InsufficientPermissionException( Term.BLACKLIST_WORLD.get() );
        }
                
        //Default values:
        int 		amount 		= 0;
        boolean		unlimited	= false;
        double 		price 		= 1.0;
        ItemStack 	is 			= null;

        /* Using keyword "this" will attempt to sell whats in your hand.  
         *      ie. default values for material and amount are what's in your hand.
         * 
         * Otherwise default value for amount is everything in your inventory.
         * 
         * Valid forms of command:
         * 1: scs sell  -- [assumes "this"] -- item in hand, amount in hand, price = 1.0
         * 2: scs sell [item/"this"] -- item in hand or specified item, amount in hand or evrything in inventory, price = 1.0
         * 3: scs sell [item/"this"] [price] -- item in hand, amount in hand, price
         * 4: scs sell [item/"this"] [amount] [price]
         */
        
        //BUG: sell (no this) takes entire stack, but only sells one
        
        
        // set to 0 or integer max in creative
        if (player.getGameMode() == GameMode.CREATIVE && !scs.getConfiguration().isMaxAmountOnCreative()) {
        	amount = 0;
        }
        
        
        //We have optional number of arguments.  Lets parse through them.
        try {
        
            switch (args.length){
                case 0:
                case 1:
                    is = Utilities.getItemStack(player, "this");
                    amount = is.getAmount();
                    break;
                    
                case 2:
                    is = Utilities.getItemStack(player, args[1]);
                    if(args[1].equalsIgnoreCase("this"))
                        amount = is.getAmount();
                    break;
                    
                case 3:
                    is = Utilities.getItemStack(player, args[1]);
                    if(args[1].equalsIgnoreCase("this"))
                        amount = is.getAmount();
                    price = Double.parseDouble(args[2]);
                    break;
                    
                case 4:
                    is = Utilities.getItemStack(player, args[1]);
                    if (args[2].equalsIgnoreCase("unlimited"))
                        unlimited = true;
                    else 
                        amount = Integer.parseInt(args[2]);
                    price = Double.parseDouble(args[3]);
                    break;
            }
            
        } catch (Exception e) {
            throw new MissingOrIncorrectArgumentException ();
        }
        if (is == null || is.getTypeId() == 0) {
        	throw new MissingOrIncorrectArgumentException (Term.ITEM_MISSING.get());
        }

        // if the id already exists, the ShopHandler will set a new one
        SellShop	shop	= new SellShop(UUID.randomUUID(), player.getUniqueId(), null, is.clone());
        
        shop.setAmount		(amount);
        shop.setUnlimited	(unlimited);
        shop.setPrice		(price);

        scs.msgPlayer(player, next);
        scs.addTodo(player, new Todo (player, Type.CREATE, shop, amount, null));
        
        return true;
    }
}
