/**
* ShowCaseStandalone
* Copyright (C) 2012 Kellerkindt <copyright at kellerkindt.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
package com.kellerkindt.scs.commands;

import java.util.logging.Level;

import org.bukkit.command.CommandSender;

import com.kellerkindt.scs.Properties;
import com.kellerkindt.scs.ShowCaseStandalone;
import com.kellerkindt.scs.exceptions.InsufficientPermissionException;
import com.kellerkindt.scs.exceptions.MissingOrIncorrectArgumentException;

/**
 * @author Sorklin <sorklin at gmail.com>
 */
public class UndoCmd extends GenericCmd {
    
    public UndoCmd(ShowCaseStandalone scs, CommandSender cs, String args[]){
        super(scs, cs, args);
        this.permission = Properties.permUse;
    }

    @Override
    public boolean execute() throws MissingOrIncorrectArgumentException, InsufficientPermissionException {
        if(errorCheck())
            return true;
        
//        Transaction t = ShowCaseStandalone.pv.getLastTransaction(player);
//        if(t == null)
//            Messaging.send(player, Term.ERROR_UNDO_NO_AVAILABLE.get());
//        else {
//            if(!t.undo())
//                Messaging.send(player, t.returnMessage);
//        }
        
        scs.log(Level.INFO, "Somone performed '/scs undo' which isn't implemented yet", false);
        
        return false;	// TODO
    }
}
