/**
* ShowCaseStandalone
* Copyright (C) 2012 Kellerkindt <copyright at kellerkindt.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
package com.kellerkindt.scs.listeners;

import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

import com.kellerkindt.scs.ShowCaseStandalone;
import com.kellerkindt.scs.commands.AbortCmd;
import com.kellerkindt.scs.commands.AboutCmd;
import com.kellerkindt.scs.commands.AddCmd;
import com.kellerkindt.scs.commands.AmountCmd;
import com.kellerkindt.scs.commands.BuyCmd;
import com.kellerkindt.scs.commands.ClearCmd;
import com.kellerkindt.scs.commands.DebugCmd;
import com.kellerkindt.scs.commands.DestroyCmd;
import com.kellerkindt.scs.commands.DisableCmd;
import com.kellerkindt.scs.commands.DisplayCmd;
import com.kellerkindt.scs.commands.ExchangeCmd;
import com.kellerkindt.scs.commands.GetCmd;
import com.kellerkindt.scs.commands.HelpCmd;
import com.kellerkindt.scs.commands.LastCmd;
import com.kellerkindt.scs.commands.ListCmd;
import com.kellerkindt.scs.commands.MemberCmd;
import com.kellerkindt.scs.commands.MessageCmd;
import com.kellerkindt.scs.commands.OwnerCmd;
import com.kellerkindt.scs.commands.PriceCmd;
import com.kellerkindt.scs.commands.PruneCmd;
import com.kellerkindt.scs.commands.PurgeCmd;
import com.kellerkindt.scs.commands.RangeCmd;
import com.kellerkindt.scs.commands.ReloadCmd;
import com.kellerkindt.scs.commands.RemoveCmd;
import com.kellerkindt.scs.commands.RepairCmd;
import com.kellerkindt.scs.commands.ReportCmd;
import com.kellerkindt.scs.commands.SellCmd;
import com.kellerkindt.scs.commands.UndoCmd;
import com.kellerkindt.scs.commands.UnitCmd;
import com.kellerkindt.scs.commands.VersionCmd;
import com.kellerkindt.scs.exceptions.InsufficientPermissionException;
import com.kellerkindt.scs.exceptions.MissingOrIncorrectArgumentException;
import com.kellerkindt.scs.interfaces.Cmd;
import com.kellerkindt.scs.utilities.Messaging;
import com.kellerkindt.scs.utilities.Term;

public class CommandExecutorListener implements CommandExecutor {
	
	private ShowCaseStandalone 	scs;	
	private Cmd					cmd;
	
	public CommandExecutorListener (ShowCaseStandalone scs) {
		this.scs = scs;
	}
	
	@Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
		
            String mainArg;
            
            if(args.length < 1)
                mainArg = "help";
            else
                mainArg = args[0];
            
            try {
                
                //General commands
                if (mainArg.equalsIgnoreCase("abort"))
                    this.cmd = new AbortCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("help"))
                    this.cmd = new HelpCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("about"))
                	this.cmd = new AboutCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("version"))
                	this.cmd = new VersionCmd(scs, sender, args);
                
                //Customer commands
                else if (mainArg.equalsIgnoreCase("last"))
                    this.cmd = new LastCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("undo"))
                    this.cmd = new UndoCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("unit"))
                    this.cmd = new UnitCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("message") || mainArg.equalsIgnoreCase("messages"))
                    this.cmd = new MessageCmd(scs, sender, args);
                
                //Creation/deletion commands
                else if (mainArg.equalsIgnoreCase("buy"))
                    this.cmd = new BuyCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("display"))
                    this.cmd = new DisplayCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("remove"))
                    this.cmd = new RemoveCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("sell"))
                    this.cmd = new SellCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("exchange"))
                	this.cmd = new ExchangeCmd(scs, sender, args);
                
                //Management commands
                else if (mainArg.equalsIgnoreCase("add"))
                    this.cmd = new AddCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("get"))
                    this.cmd = new GetCmd(scs, sender, args);
                else if(mainArg.equalsIgnoreCase("owner"))
                    this.cmd = new OwnerCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("price"))
                    this.cmd = new PriceCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("amount")) //Was "limit"
                    this.cmd = new AmountCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("member"))
                	this.cmd = new MemberCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("list"))
                	this.cmd = new ListCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("purge"))
                	this.cmd = new PurgeCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("range"))
                	this.cmd = new RangeCmd(scs, sender, args);
                
                //Admin commands
                else if (mainArg.equalsIgnoreCase("destroy"))
                	this.cmd = new DestroyCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("debug"))
                    this.cmd = new DebugCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("clear"))
                    this.cmd = new ClearCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("reload"))
                    this.cmd = new ReloadCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("disable"))
                    this.cmd = new DisableCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("enable")) //Alias for reload
                    this.cmd = new ReloadCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("prune") || mainArg.equalsIgnoreCase("cleanup"))
                    this.cmd = new PruneCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("report"))
                	this.cmd = new ReportCmd(scs, sender, args);
                else if (mainArg.equalsIgnoreCase("repair"))
                	this.cmd = new RepairCmd(scs, sender, args);
                
                
                //Unknown
                else
                    throw new MissingOrIncorrectArgumentException(Term.ERROR_COMMAND_UNKNOWN.get());
                
                return cmd.execute();
                
            } catch (MissingOrIncorrectArgumentException miae) {
                Messaging.send(sender, "`r" + miae.getMessage());
                return true;
            } catch (InsufficientPermissionException nperm) {
                Messaging.send(sender, "`r" + nperm.getMessage());
                return true;
            }
        }
}