/**
* ShowCaseStandalone
* Copyright (C) 2012 Kellerkindt <copyright at kellerkindt.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
package com.kellerkindt.scs.listeners;

import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;

import com.kellerkindt.scs.ShowCaseStandalone;
import com.kellerkindt.scs.events.ShowCaseCreateEvent;
import com.kellerkindt.scs.events.ShowCaseEvent;
import com.kellerkindt.scs.events.ShowCaseInfoEvent;
import com.kellerkindt.scs.events.ShowCaseInteractEvent;
import com.kellerkindt.scs.internals.Todo;
import com.kellerkindt.scs.internals.Todo.Type;
import com.kellerkindt.scs.shops.Shop;
import com.kellerkindt.scs.utilities.Term;

public class PlayerListener implements Listener {
	
	private ShowCaseStandalone scs;

	public PlayerListener(ShowCaseStandalone instance) {
		scs = instance;
	}
	
        /*
	 * Cancel pickup of a Item if the item is a shop Item
	 */
	@EventHandler(priority = EventPriority.HIGHEST)
	public void onPlayerPickupItem (PlayerPickupItemEvent pe) {
		if ( scs.getShopHandler().isShopItem(pe.getItem()) ) {
			pe.setCancelled(true);				
		}
	}
	
	/*
	 * Let the player Interact with the shop
     * Lets keep the priority low, so we don't get cancelled when we're not doing anything.
	 */
	@SuppressWarnings("deprecation")
	@EventHandler(priority = EventPriority.LOW, ignoreCancelled=true)
	public void onPlayerInteract (PlayerInteractEvent pie) {
		
		// Abort if action does not fit - saves power :)
		if (!pie.getAction().equals(Action.RIGHT_CLICK_BLOCK) && !pie.getAction().equals(Action.LEFT_CLICK_BLOCK)) {
			return;
		}
		
		Action			action		= pie.getAction();
		Player			player		= pie.getPlayer();
		Block			block 		= pie.getClickedBlock();

		Todo			todo		= scs.removeTodo(player);
		Shop 			shopEvent	= scs.getShopHandler().getShop(pie.getClickedBlock());
		Shop			shopTodo	= todo != null ? todo.Shop : null;
		ShowCaseEvent	event		= null;
		String			msgSuccess	= null;
		
		if (shopEvent != null && action == Action.RIGHT_CLICK_BLOCK) {
			// interaction event
			event = new ShowCaseInteractEvent(player, shopEvent, todo, pie.getAction() == Action.RIGHT_CLICK_BLOCK);
		
			
		} else if (shopEvent != null && action == Action.LEFT_CLICK_BLOCK) {
			// info event
			event = new ShowCaseInfoEvent(player, shopEvent);
			
			
		} else if (todo != null && todo.Type == Type.CREATE && shopTodo != null) {
			// create event
			shopTodo.setLocation(block.getLocation());
			event 		= new ShowCaseCreateEvent(player, shopTodo);
			msgSuccess	= Term.MESSAGE_SUCCESSFULL_CREATED.get();
			
			
		} else if (todo != null) {
			scs.msgPlayer(player, Term.ERROR_NOT_A_SHOP.get());
		}
		
		
		
		if (event != null) {			
			// dispatch event
			scs.callShowCaseEvent(event);
			
			// have to
			player.updateInventory();
			
			// send the error message
			if (event.isCancelled() && event.getCause() != null) {
				// an error occurred
				scs.msgPlayer(player, event.getCause().getMessage());

				
			} else if (!event.isCancelled() && msgSuccess != null) {
				// successfully
				scs.msgPlayer(player, msgSuccess);
			}
			
			
			/*
			 *  cancel the current event so nothing else does work with the interaction,
			 *  if the ShowCaseEvent was not cancelled
			 */
			if (!event.isCancelled()) {
				pie.setCancelled(true);
			}
		}
	}
	
//		
//		// Collect information
//		Player		sender		= pie.getPlayer();
//		Block		block		= pie.getClickedBlock();
//		Action		action		= pie.getAction();
//		ItemStack	itemStack	= pie.getItem();
//		Todo		todo		= this.todo.get(sender);
//		Shop		shop		= scs.getShopHandler().getShop(block);
//		
//		
//		if (todo == null && shop == null)
//			return; 	// nothing to do here 
//
//		// Collect more information
//		boolean	isAdmin		= scs.hasPermission(sender, Properties.permAdmin	);
//		boolean canManage	= scs.hasPermission(sender, Properties.permManage	);
//		boolean canRemove	= scs.hasPermission(sender, Properties.permRemove	);
//		boolean canUse		= scs.hasPermission(sender, Properties.permUse		);
//		int		amount		= 1;
//		
//		if (sender.isSneaking())
//			amount = ShowCaseStandalone.pv.getPlayerTransactionAmount(sender);
//		
//		try {
//		
//			if (todo == null && shop != null) {
//				
//				if (action == Action.RIGHT_CLICK_BLOCK && !(isItemToAttach(itemStack) && shop.isOwnerOrMember(sender.getName())))
//					shop.onInteract(isAdmin, canUse, sender, amount);
//					
//				else if (action == Action.LEFT_CLICK_BLOCK)
//					shop.onSeeInfo(isAdmin, canUse, sender);
//				
//			} else if (todo != null) {
//				
//				switch (todo.type) {
//					case ADD_ITEMS:
//						onAddItems(shop, sender, isAdmin, canManage, (int)todo.amount);
//						break;
//						
//					case ADD_MEMBER:
//						onAddMember(shop, sender, isAdmin, canManage, todo.string);
//						break;
//						
//					case CREATE:
//						onCreate(todo.shop, sender, isAdmin, block);
//						break;
//						
//					case DESTROY:
//						onDestroy(shop, sender, isAdmin);
//						break;
//						
//					case GET_ITEMS:
//						onGetItems(shop, sender, isAdmin, canManage, (int)todo.amount);
//						break;
//						
//					case LIMIT:
//						onLimit(shop, sender, isAdmin, canManage, (int)todo.amount);
//						break;
//						
//					case REMOVE:
//						onRemove(shop, sender, isAdmin, canRemove);
//						break;
//						
//					case REMOVE_MEMBER:
//						onRemoveMember(shop, sender, isAdmin, canManage, todo.string);
//						break;
//						
//					case SET_OWNER:
//						onSetOwner(shop, sender, isAdmin, canManage, todo.string);
//						break;
//						
//					case SET_PRICE:
//						onSetPrice(shop, sender, isAdmin, canManage, todo.amount);
//						break;
//						
//					default:
//						break;
//				}
//				
//				
//				
//			}
//		} catch (InsufficientPermissionException ipe) {
//			
//			Messaging.send(sender, ipe.getMessage());
//			
//		} finally {
//			if (!(isItemToAttach(itemStack) && shop != null && shop.isOwnerOrMember(sender.getName())))
//				pie.setCancelled(true);
//			this.todo.remove(sender);
//			sender.updateInventory();
//		}
//		
//		
////		
////		
////            /*
////             * This whole routine needs optimization.  Currently it takes far more time 
////             * then it should.
////             */
////            
////            BenchMark bm = null;
////            if(Properties.interactDebug){
////                bm = new BenchMark("onPlayerInteract");
////                bm.start("init");
////            }
////                
////                
////		// Abort if action does not fit - saves power :)
////		if (!pie.getAction().equals(Action.RIGHT_CLICK_BLOCK) && !pie.getAction().equals(Action.LEFT_CLICK_BLOCK))
////			return;
////		
////		// Collects information
////		Player 		player 		= pie.getPlayer();
////		Block	 	block		= pie.getClickedBlock();
////
////                if(Properties.interactDebug)
////                    bm.mark();
////                
////		try {
////			// Interact
////			if (pie.getAction().equals(Action.RIGHT_CLICK_BLOCK))
////			{
////                //Lets check for attachables in player's hand.  IF found, abort this. 
////                //This will allow players to attach signs, paintings, torches etc. to showcases.
////                //I have to find type ids for signs and paintings, since they don't respond to 
////                //any instanceof's i could find.
////                if(pie.hasItem() && !todo.containsKey(player))
////                    if((pie.getItem().getData() instanceof Attachable) ||
////                        (pie.getItem().getTypeId() == 323) ||
////                        (pie.getItem().getTypeId() == 321) )
////                            return;
////                            
////				if (todo.containsKey(player)) {
////
////					 
////					
////					if (todo.get(player).type.equals(Type.CREATE)){
////                        if(Properties.interactDebug)
////                            bm.mark("Rightclickblock");
////                                                
////						if(cantInteract(player, block))
////                            throw new InsufficientPermissionException(Term.ERROR_AREA_PROTECTED.get());
////                        else
////							this.create(player, block);
////					}
////	                                
////					else if (todo.get(player).type.equals(Type.REMOVE))
////						this.remove(player, block);
////					
////					else if (todo.get(player).type.equals(Type.ADD))
////						;
//////						this.add(player, block, (int)todo.get(player).amount);
////					
////					
////					else if (todo.get(player).type.equals(Type.GET))
////						;
//////						this.get(player, block, (int)todo.get(player).amount);
////					
////					else if (todo.get(player).type.equals(Type.LIMIT))
////						this.limit (player, block, (int)todo.get(player).amount);
////					
////					else if (todo.get(player).type.equals(Type.SET_OWNER))
////						this.setOwner (player, block);
////					
////					else if (todo.get(player).type.equals(Type.SET_PRICE))
////						this.price (player, block, todo.get(player).amount);
////					
////					else if (todo.get(player).type.equals(Type.DESTROY))
////						this.destroy(player, block);
////					
////                    if(Properties.interactDebug)
////                        bm.mark("end if block");
////                                        
////
////					pie.setCancelled(true);
////					player.updateInventory();	// Have to :(
////
////                    if (todo.containsKey(player))
////                            todo.remove(player);
////
////                    
////                    if(Properties.interactDebug){
////                        bm.mark("end rightclick");
////                        bm.end();
////                    }
////					
////					
////				} else {
////					Shop p = scs.getShopHandler().getShopForBlock(pie.getClickedBlock());
////                                        
////					
////					if (p.getOwner().equals(player.getName()) && !p.isUnlimited() && p.getActivity() != Activity.DISPLAY) {
////						
//////						scs.getServer().getPluginManager().callEvent(new InventoryEvent(new ShopInventoryView(p, player)));
////						
//////						player.openInventory(new ShopInventoryView(p, player));
//////						player.openInventory(new ShopInventory(p, player));
//////						
//////						Inventory inventory = scs.getServer().createInventory(player, 6*9);//.createInventory(new DoubleChest(null), InventoryType.CHEST);
//////						
//////						ItemStack	is	= p.getItemStack().clone();
//////									is.setAmount(p.getAmount());
//////						
//////						inventory.addItem(is);
////						
//////						inventory.setContents(new ItemStack[27]);
////						pie.setCancelled		(true);
////						player.openInventory	(p.getInventory());
////						
////						
////						
//////						scs.log(Level.INFO, inventory.toString());
////						
////					} else {
////                        if(Properties.interactDebug)
////                            bm.mark("interact shopforblck");
////	                                        
////						if (p != null && scs.hasPermission(player, Properties.permUse)) {
////		                    if(Properties.interactDebug)
////		                        bm.mark("hasPermission");
////	                                            
////							pie.setCancelled(true);
////	                        if(player.isSneaking()){
////                            //	p.interact(player, scs.pv.getPlayerTransactionAmount(player));  -- This went around the shop handler, which actually is the thing that updates the save file.  Bad.
////                                scs.getShopHandler().interact(block, player, ShowCaseStandalone.pv.getPlayerTransactionAmount(player));
////                            } else { 
////                            	scs.getShopHandler().interact(block, player, 1);
////                            }
////	                            
////	                            if(Properties.interactDebug)
////	                                bm.mark("afterinteract");
////	                                                 
////							player.updateInventory();	// Have to :(
////	                                                
////	                        if(Properties.interactDebug){
////	                            bm.mark("updateInventory");
////	                            bm.end();
////	                        }
////	                                                
////						} else if (p != null && !scs.hasPermission(player, Properties.permUse))
////							throw new InsufficientPermissionException();
////					}
////				}
////			}
////			
////			// Show info
////			else if (pie.getAction().equals(Action.LEFT_CLICK_BLOCK) ) {
////                if(Properties.interactDebug)
////                    bm.mark("leftclick");
////                                
////				Shop p = scs.getShopHandler().getShopForBlock(pie.getClickedBlock());
////                                
////                if(Properties.interactDebug)
////                    bm.mark("interact shopforblck");
////                                
////				if (p != null && scs.hasPermission(player, Properties.permUse)) {             
////		            if(Properties.interactDebug)
////		                bm.mark("hasPermission");
////	                                    
////					pie.setCancelled(true);
////					p.info(player);
////				} else if (p != null && !scs.hasPermission(player, Properties.permUse))
////					throw new InsufficientPermissionException();
////                                
////                if(Properties.interactDebug)
////                    bm.end();
////			}
////		} catch (ShopNotFoundException snfe) {
////			// No problem, if the selected block is no shop, nothing needs to be done.
////			/// Just give a little feedback
////			if (todo.containsKey(player))
////				Messaging.send(player, Term.ERROR_NOT_A_SHOP);
////		} catch (InsufficientPermissionException ipe) {
////            Messaging.send(player, "`r" + ipe.getMessage());
////            pie.setCancelled(true);
////            
////            
////        } finally {
//////        	if (todo.containsKey(player))
////                todo.remove(player);
////        }
//	}
//	
//	/**
//	 * Checks if the given item is can be attached to the shop 
//	 * @param itemStack
//	 * @return
//	 */
//	private boolean isItemToAttach (ItemStack itemStack) {
//		if (itemStack == null)
//			return false;
//		
//		return (itemStack.getData() instanceof Attachable
//			 || itemStack.getTypeId()	== 323
//			 || itemStack.getTypeId() 	== 321
//			 || itemStack.getType() == Material.ITEM_FRAME);
//	}
//
//	/*
//	 * Remove any player-set unit size.
//	 */
//	@EventHandler(priority = EventPriority.MONITOR)
//	public void onPlayerQuit(PlayerQuitEvent event) {
//		Player p = event.getPlayer();
//		ShowCaseStandalone.pv.clearPlayerTransactionAmount(p);
//		ShowCaseStandalone.pv.clearLastTransaction(p);
//	}
//        
//        
//	/*
//	 * Adds given Todo-Object to HashMap
//	 */
//	public void addTodo (Player player, Todo t) {
//		todo.put(player, t);
//	}
//	
//	/*
//	 * Removes Todo-Object with given player as key
//	 */
//	public Todo removeTodo (Player player) {
//			return todo.remove(player);
//	}
//	
//	/**
//	 * Throws an exception if the shop is null
//	 * @param shop
//	 * @throws InsufficientPermissionException
//	 */
//	private void checkShop (Shop shop) throws InsufficientPermissionException {
//		if (shop == null)
//			throw new InsufficientPermissionException(Term.ERROR_NOT_A_SHOP.get());
//	}
//	
//	/**
//	 * Performs the ShowCaseCreateEvent, and checks if it was canceled
//	 * @param shop		Shop to check for
//	 * @param player	Player that want to create the shop
//	 * @throws InsufficientPermissionException
//	 * 
//	 */
//	private void checkShowCaseCreateEvent (Location location, Player player) throws InsufficientPermissionException {
//		
//		// TODO to be fully implemented soon
//		ShowCaseCreateEvent event = new ShowCaseCreateEvent(player, location, null, false, 0, null);
//		
//		if (scs.callShowCaseEvent(event)) {
//			if (event.getCause() instanceof InsufficientPermissionException) {
//				throw (InsufficientPermissionException)event.getCause();
//				
//			} else if (event.getCause() != null) {
//				throw new InsufficientPermissionException(event.getCause().getMessage());
//			} else {
//				throw new InsufficientPermissionException("Unknown issue, probably: " + Term.ERROR_AREA_PROTECTED.get());
//			}
//		}
//	}
//	
//	/**
//	 * Checks if the MaterialData is listed on the black or whitelist
//	 * @param data
//	 * @throws InsufficientPermissionException
//	 */
//	private void checkBlackWhiteList (MaterialData data) throws InsufficientPermissionException {
//		if (Properties.blackList && Properties.blockList.contains(data)
//		 ||!Properties.blackList &&!Properties.blockList.contains(data))
//			throw new InsufficientPermissionException(Term.BLACKLIST_BLOCK.get());
//	}
//	
//	
//	
//	/**
//	 * Adds Items from a Player to the shop
//	 * @param shop
//	 * @param sender
//	 * @param isAdmin
//	 * @param canManage
//	 * @param amount
//	 * @throws InsufficientPermissionException
//	 * @throws ShopNotFoundException
//	 */
//	private void onAddItems (Shop shop, Player sender, boolean isAdmin, boolean canManage, int amount) throws InsufficientPermissionException {
//		checkShop(shop);
//		
//		amount = shop.onAddItems(isAdmin, canManage, sender, amount);
//		Messaging.send(sender, Term.INVENTORY_UPDATE.get(""+amount, ""+shop.getAmount()));
//	}
//	
//	
//	/**
//	 * Gets Items from a shop and adds them to a player
//	 * @param shop
//	 * @param sender
//	 * @param isAdmin
//	 * @param canManage
//	 * @param amount
//	 * @throws InsufficientPermissionException
//	 * @throws ShopNotFoundException
//	 */
//	private void onGetItems (Shop shop, Player sender, boolean isAdmin, boolean canManage, int amount) throws InsufficientPermissionException {
//		checkShop(shop);
//		
//		amount = shop.onGetItems(isAdmin, canManage, sender, amount);
//		Messaging.send(sender, Term.INVENTORY_CURRENT.get(""+shop.getAmount()));
//	}
//	
//	/**
//	 * Adds the given member to a shop
//	 * @param shop
//	 * @param sender
//	 * @param isAdmin
//	 * @param canManage
//	 * @param member
//	 * @throws InsufficientPermissionException
//	 * @throws ShopNotFoundException
//	 */
//	private void onAddMember (Shop shop, Player sender, boolean isAdmin, boolean canManage, String member) throws InsufficientPermissionException {
//		checkShop(shop);
//		
//		shop.onAddMember(isAdmin, canManage, sender, member);
//		Messaging.send(sender, Term.MESSAGE_SUCCESSFULL_ADDED_MEMBER.get());
//	}
//	
//	/**
//	 * Removes a member from a shop
//	 * @param shop
//	 * @param sender
//	 * @param isAdmin
//	 * @param canManage
//	 * @param member
//	 * @throws InsufficientPermissionException
//	 * @throws ShopNotFoundException
//	 */
//	private void onRemoveMember (Shop shop, Player sender, boolean isAdmin, boolean canManage, String member) throws InsufficientPermissionException {
//		checkShop(shop);
//		
//		shop.onRemMember(isAdmin, canManage, sender, member);
//		Messaging.send(sender, Term.MESSAGE_SUCCESSFULL_REMOVED_MEMBER.get());
//	}
//	
//	/**
//	 * Creates a shop
//	 * @param shop
//	 * @param sender
//	 * @param isAdmin
//	 * @param canManage
//	 * @param block
//	 * @throws InsufficientPermissionException
//	 * @throws ShopNotFoundException
//	 */
//	private void onCreate (Shop shop, Player sender, boolean isAdmin, Block block) throws InsufficientPermissionException {
//		checkShop(shop);
//		
//		double 	price		= 0;
//		boolean	canCreate	= false;
//		
//		switch (shop.getActivity()) {
//		case BUY:
//			price		= Properties.buyShopCreatePrice;
//			canCreate	= scs.hasPermission(sender, Properties.permCreateBuy);
//			break;
//		case DISPLAY:
//			price		= Properties.displayCreatePrice;
//			canCreate	= scs.hasPermission(sender, Properties.permCreateDisplay);
//			break;
//		case EXCHANGE:
//			price		= Properties.exchangeCreatePrice;
//			canCreate	= scs.hasPermission(sender, Properties.permCreateExchange);
//			break;
//		case SELL:
//			price		= Properties.sellShopCreatePrice;
//			canCreate	= scs.hasPermission(sender, Properties.permCreateSell);
//			break;
//		default:
//			break;
//		}
//	
//		if (!canCreate && !isAdmin)
//			throw new InsufficientPermissionException(Term.ERROR_INSUFFICIENT_PERMISSION.get());
//		
//		if (price > 0 && !scs.getBalanceHandler().hasEnough(sender.getName(), price))
//			throw new InsufficientPermissionException(Term.ERROR_INSUFFICIENT_MONEY_CREATE.get());
//		
//		if (scs.getShopHandler().isShopBlock(block))
//			throw new InsufficientPermissionException(Term.ERROR_ALREADY_SHOWCASE.get());
//		
//		if ( Properties.maxShopAmountPerPlayer >= 0 && !sender.hasPermission( Properties.permMaxShopPerPlayerOverride ) && scs.getShopHandler().getShopAmount( sender.getName() ) >= Properties.maxShopAmountPerPlayer ) {
//			throw new InsufficientPermissionException(Term.ERROR_SHOP_LIMIT_EXCEEDED.get());
//		}
//		
//		// Black- Whitelist check
//		checkBlackWhiteList		(new MaterialData(block.getTypeId(), block.getData()));
//		checkShowCaseCreateEvent(block.getLocation(), sender);
//		
//		// get the promised items - ignore if in creative mode
//		if ((shop.getActivity() == Activity.SELL || shop.getActivity() == Activity.EXCHANGE) && shop.getAmount() > 0 && !shop.isUnlimited() && !GameMode.CREATIVE.equals(sender.getGameMode())) {
//			int removed	= ItemStackUtilities.removeFromInventory(sender.getInventory(), shop.getItemStack(), shop.getAmount(), shop.needsEqualNBTTag());
//			if (removed <= 0)
//				throw new InsufficientPermissionException(Term.ERROR_INSUFFICIENT_ITEMS_CREATE.get());
//			shop.setAmount(removed);
//		}
//		
//		//Try to replace with a unique hash, otherwise keep the random hash.
////        try {shop.setSHA1(Utilities.sha1(block.toString()));} catch (IOException ioe) {}
//		shop.setBlock	(block	);
//		shop.setVisible	(true	);
//		
//		scs.getShopHandler().addShop(shop);
//		scs.getBalanceHandler().sub(sender, price);
//		
//		
//		Messaging.send(sender, Term.MESSAGE_SUCCESSFULL_CREATED.get());
//		
//		if (shop.getActivity() != Activity.DISPLAY && !shop.isUnlimited())
//			Messaging.send(sender, Term.INVENTORY_CURRENT.get(""+shop.getAmount()));
//		
//		else if (shop.getActivity() != Activity.DISPLAY && shop.isUnlimited())
//			Messaging.send(sender, Term.INVENTORY_CURRENT.get(Term.INFO_UNLIMITED.get()));
//	}
//	
//	/**
//	 * Destroys the given shop
//	 * @param shop
//	 * @param sender
//	 * @param isAdmin
//	 * @throws InsufficientPermissionException
//	 * @throws ShopNotFoundException
//	 */
//	private void onDestroy (Shop shop, Player sender, boolean isAdmin) throws InsufficientPermissionException {
//		checkShop(shop);
//		
//		if (!isAdmin)
//			throw new InsufficientPermissionException(Term.ERROR_INSUFFICIENT_PERMISSION_DESTROY.get());
//		
//		scs.getShopHandler().removeShop(shop);
////		scs.getShopHandler().hide(shop); // done in remove
////		shop.hide();
//		Messaging.send(sender, Term.MESSAGE_SUCCESSFULL_DESTROYED.get());
//		
//		// informs other listeners that this shop is now removed
//		
//		// TODO
////		scs.callShowCaseRemovedEvent(shop, sender);
//	}
//	
//	/**
//	 * Sets the limit of a shop
//	 * @param shop
//	 * @param sender
//	 * @param isAdmin
//	 * @param canManage
//	 * @param limit
//	 * @throws InsufficientPermissionException
//	 * @throws ShopNotFoundException
//	 */
//	private void onLimit (Shop shop, Player sender, boolean isAdmin, boolean canManage, int limit) throws InsufficientPermissionException {
//		checkShop(shop);
//		
//		shop.onSetLimit(isAdmin, canManage, sender, limit);
//		Messaging.send(sender, Term.MESSAGE_BUY_LIMIT.get(""+limit));
//	}
//	
//	/**
//	 * Removes a shop
//	 * @param shop
//	 * @param sender
//	 * @param isAdmin
//	 * @param canRemove
//	 * @throws InsufficientPermissionException
//	 * @throws ShopNotFoundException
//	 */
//	private void onRemove (Shop shop, Player sender, boolean isAdmin, boolean canRemove) throws InsufficientPermissionException {
//		checkShop(shop);
//		
//		if (!isAdmin && !(shop.isOwner(sender.getName()) && canRemove))
//			throw new InsufficientPermissionException(Term.ERROR_INSUFFICIENT_PERMISSION_REM_SHOWCASE.get());
//		
//		int amount = 0;
//		
//		if (!shop.isUnlimited()) {
//			// remove items
//			amount  = ItemStackUtilities.addToInventory(sender.getInventory(), shop.getItemStack(), shop.getAmount());
//			
//			// set new amount
//			shop.setAmount(shop.getAmount() - amount);
//			
//			// get rest amount
//			amount = shop.getAmount();
//		}
//		
//		// check for ExcahngeShop
//		if (shop instanceof ExchangeShop && !shop.isUnlimited()) {
//			ExchangeShop exShop = (ExchangeShop)shop;
//			// remove items
//			int exAmount = ItemStackUtilities.addToInventory(sender.getInventory(), exShop.getExchangeItemStack(), exShop.getExchangeAmount());
//			
//			// set new amount
//			exShop.setExchangeAmount(exShop.getExchangeAmount() - exAmount);
//			
//			// add to amount
//			amount += exShop.getExchangeAmount();
//		}
//		
//		if (amount > 0)
//			throw new InsufficientPermissionException(Term.INVENTORY_FULL.get());
//		
//		scs.getShopHandler().removeShop(shop);
////		scs.getShopHandler().hide(shop);	// done in remove
////		shop.hide();
//		Messaging.send(sender, Term.MESSAGE_SUCCESSFULL_REMOVED.get());
//		
//		// informs other listeners that this shop is now removed
////		scs.callShowCaseRemovedEvent(shop, sender); // TODO
//	}
//	
//	/**
//	 * Sets the owner of a shop
//	 * @param shop
//	 * @param sender
//	 * @param isAdmin
//	 * @param canManage
//	 * @param owner
//	 * @throws InsufficientPermissionException
//	 * @throws ShopNotFoundException
//	 */
//	private void onSetOwner (Shop shop, Player sender, boolean isAdmin, boolean canManage, String owner) throws InsufficientPermissionException {
//		checkShop(shop);
//		
//		shop.onSetOwner(isAdmin, canManage, sender, owner);
//		Messaging.send(sender, Term.MESSAGE_SET_OWNER.get(owner));
//	}
//	
//	/**
//	 * Sets the price of a shop
//	 * @param shop
//	 * @param sender
//	 * @param isAdmin
//	 * @param canManage
//	 * @param price
//	 * @throws InsufficientPermissionException
//	 * @throws ShopNotFoundException
//	 */
//	private void onSetPrice (Shop shop, Player sender, boolean isAdmin, boolean canManage, double price) throws InsufficientPermissionException {
//		checkShop(shop);
//		
//		shop.onSetPrice(isAdmin, canManage, sender, price);
//		Messaging.send(sender, Term.MESSAGE_SET_PRICE.get(""+price));
//	}
//	
	
	
//	
//	/**
//	 * Destroys the given shop
//	 * @param player
//	 * @param b
//	 * @throws ShopNotFoundException
//	 * @throws InsufficientPermissionException
//	 */
//	private void destroy (Player player, Block b) throws ShopNotFoundException, InsufficientPermissionException {
//		Shop	shop	= scs.getShopHandler().getShopForBlock(b);
//		
//		if (shop == null)
//			throw new ShopNotFoundException();
//		
//		if (!scs.hasPermission(player, Properties.permAdmin))
//			throw new InsufficientPermissionException(Term.ERROR_INSUFFICIENT_PERMISSION_DESTROY.get());
//		
//		
//		// destroy the shop
//		scs.getShopHandler().removeShop(shop);
//		Messaging.send(player, Term.MESSAGE_SUCCESSFULL_DESTROYED);
//	}
//
//	/*
//	 * Changes price of a shop
//	 */
//	private void price (Player player, Block b, double price) throws ShopNotFoundException, InsufficientPermissionException {
//		Shop shop = scs.getShopHandler().getShopForBlock(b);
//
//		if (shop == null)
//                        throw new ShopNotFoundException();
//
//		if (shop.getActivity().equals(Activity.DISPLAY)) {
//			Messaging.send(player, Term.ERROR_SET_PRICE_DISPLAY.get());
//			return;
//		}
//                
//        if (!player.getName().equals(shop.getOwner()) && !scs.hasPermission(player, Properties.permAdmin))
//                throw new InsufficientPermissionException(Term.ERROR_INSUFFICIENT_PERMISSION_SET_PRICE.get());
//		
//                
//		// Set the shop price
//		shop.setPrice(price); 
//		Messaging.send(player, Term.MESSAGE_SET_PRICE.get() + scs.formatCurrency(shop.getPrice()));
//
//		// Saving changes
//		this.saveShop(shop, player);
//	}
//
//
//	/*
//	 * Changes maxAmount of a BUY showcase
//	 */
//	private void limit (Player player, Block b, int limit) throws ShopNotFoundException, InsufficientPermissionException {
//		Shop shop = scs.getShopHandler().getShopForBlock(b);
//
//		if (shop == null) 
//                        throw new ShopNotFoundException();
//
//		if(!shop.getActivity().equals(Activity.BUY)) {
//			Messaging.send(player, Term.ERROR_BUY_LIMIT.get());
//			return;
//		}
//                
//        if (!player.getName().equals(shop.getOwner()) && !scs.hasPermission(player, Properties.permAdmin)) 
//                throw new InsufficientPermissionException(Term.ERROR_INSUFFICIENT_PERMISSION_SET_LIMIT.get());
//
//		// Set the shop limit
//		shop.setMaxAmount(limit);
//		Messaging.send(player, Term.MESSAGE_BUY_LIMIT.get() + shop.getMaxAmount());
//
//		// Saving changes
//		this.saveShop(shop, player);
//	}
//
//
////	/*
////	 * Add Items to a shop
////	 */
////	private void add (Player player, Block b, int amount) throws ShopNotFoundException, InsufficientPermissionException {
////		Shop shop = scs.getShopHandler().getShopForBlock(b);
////
////		if (shop == null)
////        	throw new ShopNotFoundException();
////		
////		if (shop.getActivity().equals(Activity.DISPLAY)) {
////			Messaging.send(player, Term.ERROR_ADD_ITEMS_DISPlAY.get());
////			return;
////		}
////		
////		if (shop.isUnlimited()) {
////			Messaging.send(player, Term.ERROR_ADD_ITEMS_UNLIMITED.get());
////			return;
////		}
////		
////		int workingAmount = shop.getItemsFromPlayer(player, amount, scs.hasPermission(player, Properties.permAdmin));
////		saveShop(shop, player);
////		
////		Messaging.send(player, Term.INVENTORY_UPDATE.get(String.valueOf(workingAmount),
////				String.valueOf(shop.getAmount())));
////		
////		ShowCaseStandalone.tlog(player.getName(), player.getName(), "add",
////				workingAmount, 0, shop.getMaterial(), shop.getSHA1(), shop.getAmount());
////		
//////		
//////		
//////
//////
//////		if (shop.getActivity().equals(Activity.DISPLAY)) {
//////			Messaging.send(player, Term.ERROR_ADD_ITEMS_DISPlAY.get());
//////			return;
//////		}
//////                
//////        if (!player.getName().equals(shop.getOwner()) && !scs.hasPermission(player, Properties.permAdmin)) 
//////                throw new InsufficientPermissionException(Term.ERROR_INSUFFICIENT_PERMISSION_ADD_ITEM.get()); 
//////
//////		if (shop.isUnlimited()) {
//////			Messaging.send(player, Term.ERROR_ADD_ITEMS_UNLIMITED.get());
//////			return;
//////		}
//////                
//////		int workingAmount = ItemStackHandler.removeFromInventory(player.getInventory(), shop.getItemStack(), amount, shop.needsEqualNBTTag());
////////        int workingAmount = shop.safeRemoveItems(player, amount);
//////        shop.setAmount(shop.getAmount() + workingAmount);
//////        Messaging.send(player, Term.INVENTORY_UPDATE.get(String.valueOf(workingAmount), String.valueOf(shop.getAmount())));
//////
//////            // Saving changes
//////     	this.saveShop(shop, player);
//////                    
//////        ShowCaseStandalone.tlog(player.getName(), player.getName(), "add", workingAmount, 0, shop.getMaterial(), shop.getSHA1(), shop.getAmount());
////	}
//
//
////	/*
////	 * Get Item from shop
////	 */
////	private void get (Player player, Block b, int amount) throws ShopNotFoundException, InsufficientPermissionException {
////		Shop shop = scs.getShopHandler().getShopForBlock(b);
////
////		if (shop == null)
////			throw new ShopNotFoundException();
////
////		if (shop.getActivity().equals(Activity.DISPLAY)) {
////			Messaging.send(player, Term.ERROR_GET_DISPLAY.get());
////			return;
////		}
////		
////		int workingAmount = shop.addItemsToPlayer(player, amount, scs.hasPermission(player, Properties.permAdmin));
////		saveShop(shop, player);
////		
////		Messaging.send(player, Term.MESSAGE_RECEIVED_ITEMS.get(String.valueOf(workingAmount)) + 
////              ((workingAmount == 0) ? Term.ERROR_INSUFFICIENT_ROOM.get() : ""));
////
////        ShowCaseStandalone.tlog(player.getName(), player.getName(), "get", 
////              workingAmount, 0, shop.getMaterial(), shop.getSHA1(), shop.getAmount());
////		
////		
//////                
//////        if (!player.getName().equals(shop.getOwner()) && !scs.hasPermission(player, Properties.permAdmin)) 
//////                throw new InsufficientPermissionException(Term.ERROR_INSUFFICIENT_PERMISSION_GET_ITEM.get());
//////                
//////		if (shop.getAmount() < 0)
//////			Messaging.send(player, Term.ERROR_REM_ITEMS_UNLIMITED.get());
//////		
//////            if (amount == 0 || amount > shop.getAmount())
//////                    amount = shop.getAmount();
//////                        
//////            //Remove as many of the item, up to the amount specified, and store
//////            //how much was actually removed.
//////            int workingAmount	= ItemStackHandler.addToInventory(player.getInventory(), shop.getItemStack(), amount);
////////            int workingAmount = shop.safeAddItems(player, amount);
//////            shop.setAmount(shop.getAmount() - workingAmount);
//////            Messaging.send(player, Term.MESSAGE_RECEIVED_ITEMS.get(String.valueOf(workingAmount)) + 
//////                ((workingAmount == 0) ? Term.ERROR_INSUFFICIENT_ROOM.get() : ""));
//////
//////            ShowCaseStandalone.tlog(player.getName(), player.getName(), "get", 
//////                workingAmount, 0, shop.getMaterial(), shop.getSHA1(), shop.getAmount());
//////		
//////            // Saving changes
//////            this.saveShop(shop, player);
////	}
//
//
//	/*
//	 * Removes a shop
//	 */
//	private void remove (Player player, Block b) throws ShopNotFoundException, InsufficientPermissionException {
//		Shop shop = scs.getShopHandler().getShopForBlock(b);
//
//		if (shop == null)
//			throw new ShopNotFoundException();
//
//		if (!player.getName().equals(shop.getOwner()) && !scs.hasPermission(player, Properties.permAdmin))
//			throw new InsufficientPermissionException(Term.ERROR_INSUFFICIENT_PERMISSION_REM_SHOWCASE.get());
//
//		if (!shop.getActivity().equals(Activity.DISPLAY)) {
//			//Remove as many items as I can.
//			int workingAmount = ItemStackHandler.addToInventory(player.getInventory(), shop.getItemStack(), shop.getAmount());
//			shop.setAmount(shop.getAmount() - workingAmount);
//			Messaging.send(player, Term.MESSAGE_RECEIVED_ITEMS.get(String.valueOf(workingAmount)));
//
//			ShowCaseStandalone.tlog(player.getName(), player.getName(), "remove", workingAmount, 0, shop.getMaterial(), shop.getSHA1(), shop.getAmount());
//
//            if(shop.getAmount() > 0){
//				Messaging.send(player, Term.INVENTORY_FULL.get());
//				Messaging.send(player, Term.ITEM_LEFT.get() + shop.getAmount());
//				this.saveShop(shop, player);
//				return;
//            }
//		}
//
//                // Remove the showcase
//		scs.getShopHandler().removeShop(shop);
//		Messaging.send(player, Term.MESSAGE_SUCCESSFULL_REMOVED.get());
//	}
//
//	/*
//	 * Create a shop
//	 */
//	private void create (Player player, Block b) throws ShopNotFoundException, InsufficientPermissionException {
//		Shop p				= this.removeTodo(player).shop;
//		int removed = 0;
//
//		double createPrice = 0;
//		switch (p.getActivity()) {
//		case SELL:
//			createPrice = Properties.sellShopCreatePrice;
//			break;
//		case BUY:
//			createPrice = Properties.buyShopCreatePrice;
//			break;
//		case DISPLAY:
//			createPrice = Properties.displayCreatePrice;
//			break;
//		case EXCHANGE:
//			createPrice	= Properties.exchangeCreatePrice;
//		}
//
//		if(!scs.getBalanceHandler().hasEnough(player.getName(), createPrice)){
//			Messaging.send(player, Term.ERROR_INSUFFICIENT_MONEY_CREATE.get());
//			return;
//		}   
//
//		if (scs.getShopHandler().isShopBlock(b)) {
//			Messaging.send(player, Term.ERROR_ALREADY_SHOWCASE.get()); 
//			return;
//		}
//                
//        //Check for blacklisted/whitelisted shop block
//        // I hate fucking workarounds.  Fucking bukkit.
//        MaterialData md = new MaterialData(b.getTypeId(), b.getData());
//        if  (Properties.blackList && Properties.blockList.contains(md)
//                ||
//            (!Properties.blackList && !Properties.blockList.contains(md)))
//                throw new InsufficientPermissionException(Term.BLACKLIST_BLOCK.get());
//        
//                
//		if ((p.getActivity() == Activity.SELL || p.getActivity() == Activity.EXCHANGE) && p.getAmount() > 0 && !p.isUnlimited()) {
//			//Just try to remove the items and see how many I actually can remove (up to the specified amount).
//			removed = ItemStackHandler.removeFromInventory(player.getInventory(), p.getItemStack(), p.getAmount(), p.needsEqualNBTTag());
//			if(removed == 0) {
//				Messaging.send(player, Term.ERROR_INSUFFICIENT_ITEMS_CREATE.get());
//				return;
//			}
//		}
//        //Try to replace with a unique hash, otherwise keep the random hash.
//        try {p.setSHA1(Utilities.sha1(b.toString()));} catch (IOException ioe) {}
//		p.setAmount     (removed);
//		p.setBlock		(b);
//		p.setVisible	(true);
//
//		scs.getShopHandler().addShop(p);
//		this.saveShop(p, player);	// Saving the shop
//
//		scs.getBalanceHandler().sub(player, createPrice);
//
//		Messaging.send(player, Term.MESSAGE_SUCCESSFULL_CREATED.get());
//		
//		if (!p.getActivity().equals(Activity.DISPLAY)) {
//			Messaging.send(player, Term.INVENTORY_CURRENT.get() + p.getAmount()); 
//			ShowCaseStandalone.tlog(player.getName(), player.getName(), "create", removed, createPrice, p.getMaterial(), p.getSHA1(), p.getAmount());
//		}
//	}
//
//
//	/*
//	 *  Set Owner of a shop
//	 */
//	private void setOwner (Player player, Block b) throws ShopNotFoundException, InsufficientPermissionException {
//		Todo t = this.removeTodo(player);
//
//		Shop 	p 		= scs.getShopHandler().getShopForBlock(b);
//		String	owner	= t.string;
//                
//		if (p == null) 
//			throw new ShopNotFoundException();
//                
//	    if (!player.getName().equals(p.getOwner()) && !scs.hasPermission(player, Properties.permAdmin))
//            throw new InsufficientPermissionException(Term.ERROR_INSUFFICIENT_PERMISSION_SET_OWNER.get());
//                
//		p.setOwner(owner);     
//		Messaging.send(player, Term.MESSAGE_SET_OWNER.get(owner));
//
//		// Saving changes
//		this.saveShop(p, player);
//	}

//	private void saveShop (Shop p, Player player) {
//		try {
//			scs.getShopHandler().save(p);
//		} catch (IOException ioe) {
//			scs.log(Level.WARNING, ioe+" while saving a shop.");
//			Messaging.send(player, Term.ERROR_ON_SAVE.get());
//		}
//	}
//        
//        /**
//         * Checks for ability of player to do something where the showcase will be.  Default is
//         * to check for building rights (BlockPlaceEvent), but can be other.
//         * @param p Player
//         * @param b Block
//         * @return 
//         */
//        private boolean cantInteract(Player p, Block b) {
//            //Right now, block place is the only interact I can think of supported by bukkit.
//            BlockPlaceEvent 		bpe 	= new BlockPlaceEvent(b, b.getState(), b.getRelative(BlockFace.DOWN), p.getItemInHand(), p, true);
//            ShowCaseCreateEvent		scce	= new ShowCaseCreateEvent(b.getLocation(), p);
//            
//            Bukkit.getServer().getPluginManager().callEvent(scce);
//            Bukkit.getServer().getPluginManager().callEvent(bpe);
//            
//            return bpe.isCancelled() || scce.isCancelled();
//        }
}
