/**
* ShowCaseStandalone
* Copyright (C) 2012 Kellerkindt <copyright at kellerkindt.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
package com.kellerkindt.scs.listeners;

import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;

import com.kellerkindt.scs.ShowCaseStandalone;

public class WorldListener implements Listener {
	private ShowCaseStandalone scs;
	
	public WorldListener (ShowCaseStandalone scs) {
		this.scs	= scs;
	}
	
	
	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled=true)
	public void onChunkLoad(ChunkLoadEvent event) {
		scs.getShopHandler().loadChunk(event.getChunk());
	}
	
	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled=true)
	public void onChunkUnload(ChunkUnloadEvent event) {
		scs.getShopHandler().unloadChunk(event.getChunk());
	}
}
