/*
 * Decompiled with CFR 0.152.
 */
package de.howaner.FramePicture;

import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import de.howaner.FramePicture.FrameManager;
import de.howaner.FramePicture.util.Lang;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class FramePicturePlugin
extends JavaPlugin {
    public static Logger log;
    private static FrameManager manager;
    private static FramePicturePlugin instance;
    private static Economy economy;
    private boolean invalidBukkit = false;

    private void checkBukkitVersion() {
        try {
            Class.forName("net.minecraft.server.v1_7_R3.Packet");
            this.invalidBukkit = false;
        }
        catch (Exception e) {
            this.invalidBukkit = true;
            return;
        }
    }

    public void onLoad() {
        log = this.getLogger();
        instance = this;
        this.checkBukkitVersion();
        if (!this.invalidBukkit) {
            manager = new FrameManager(this);
        }
    }

    public void onEnable() {
        if (log == null) {
            log = this.getLogger();
        }
        if (instance == null) {
            instance = this;
        }
        if (this.invalidBukkit) {
            log.severe("You use a not-supported bukkit version!");
            log.severe("This FramePicture version is for Bukkit 1.7.8/1.7.9!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (manager == null) {
            manager = new FrameManager(this);
        }
        this.setupEconomy();
        manager.onEnable();
        log.info(Lang.PLUGIN_ENABLED.getText());
    }

    public void onDisable() {
        if (manager != null) {
            manager.onDisable();
        }
        log.info(Lang.PLUGIN_DISABLED.getText());
    }

    public void setupEconomy() {
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            return;
        }
        RegisteredServiceProvider economyProvider = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            economy = (Economy)economyProvider.getProvider();
        }
    }

    public static Economy getEconomy() {
        return economy;
    }

    public static WorldGuardPlugin getWorldGuard() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("WorldGuard");
        if (plugin != null && plugin instanceof WorldGuardPlugin) {
            return (WorldGuardPlugin)plugin;
        }
        return null;
    }

    public static FramePicturePlugin getPlugin() {
        return instance;
    }

    public static FrameManager getManager() {
        return manager;
    }

    static {
        manager = null;
        economy = null;
    }
}

