/*
 * Decompiled with CFR 0.152.
 */
package de.howaner.FramePicture.command;

import de.howaner.FramePicture.FrameManager;
import de.howaner.FramePicture.FramePicturePlugin;
import de.howaner.FramePicture.util.Cache;
import de.howaner.FramePicture.util.Config;
import de.howaner.FramePicture.util.Lang;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FramePictureCommand
implements CommandExecutor {
    private FrameManager manager;

    public FramePictureCommand(FrameManager manager) {
        this.manager = manager;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (args.length == 0) {
            return this.sendHelp(sender);
        }
        String aufgabe = args[0];
        if (aufgabe.equalsIgnoreCase("set")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(Lang.PREFIX.getText() + Lang.NO_PLAYER.getText());
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("FramePicture.set")) {
                player.sendMessage(Lang.PREFIX.getText() + Lang.NO_PERMISSION.getText());
                return true;
            }
            if (args.length == 1 && Cache.hasCacheCreating(player)) {
                Cache.removeCacheCreating(player);
                player.sendMessage(Lang.PREFIX.getText() + Lang.CREATING_CANCELLED.getText());
                return true;
            }
            if (args.length < 2) {
                return this.sendHelp(sender);
            }
            if (Cache.hasCacheCreating(player)) {
                player.sendMessage(Lang.PREFIX.getText() + Lang.ALREADY_SELECTION.getText());
                return true;
            }
            if (Config.MONEY_ENABLED && !FramePicturePlugin.getEconomy().has(player.getName(), Config.CREATE_PRICE)) {
                player.sendMessage(Lang.NOT_ENOUGH_MONEY.getText());
                return true;
            }
            StringBuilder pathBuilder = new StringBuilder();
            for (int i = 1; i < args.length; ++i) {
                if (i != 1) {
                    pathBuilder.append(" ");
                }
                pathBuilder.append(args[i]);
            }
            String path = pathBuilder.toString();
            Cache.setCacheCreating(player, path);
            player.sendMessage(Lang.PREFIX.getText() + Lang.CLICK_FRAME.getText());
            return true;
        }
        if (aufgabe.equalsIgnoreCase("multiset")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(Lang.PREFIX.getText() + Lang.NO_PLAYER.getText());
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("FramePicture.multiset")) {
                player.sendMessage(Lang.PREFIX.getText() + Lang.NO_PERMISSION.getText());
                return true;
            }
            if (args.length == 1 && Cache.hasCacheMultiCreating(player)) {
                Cache.removeCacheMultiCreating(player);
                player.sendMessage(Lang.PREFIX.getText() + Lang.CREATING_CANCELLED.getText());
                return true;
            }
            if (args.length < 2) {
                return this.sendHelp(sender);
            }
            if (Cache.hasCacheMultiCreating(player)) {
                player.sendMessage(Lang.PREFIX.getText() + Lang.ALREADY_SELECTION.getText());
                return true;
            }
            if (Config.MONEY_ENABLED && !FramePicturePlugin.getEconomy().has(player.getName(), Config.CREATE_PRICE)) {
                player.sendMessage(Lang.NOT_ENOUGH_MONEY.getText());
                return true;
            }
            StringBuilder pathBuilder = new StringBuilder();
            for (int i = 1; i < args.length; ++i) {
                if (i != 1) {
                    pathBuilder.append(" ");
                }
                pathBuilder.append(args[i]);
            }
            String path = pathBuilder.toString();
            Cache.setCacheMultiCreating(player, path);
            player.sendMessage(Lang.PREFIX.getText() + Lang.CLICK_MULTIFRAME.getText());
            return true;
        }
        if (aufgabe.equalsIgnoreCase("get")) {
            if (args.length != 1) {
                return this.sendHelp(sender);
            }
            if (!(sender instanceof Player)) {
                sender.sendMessage(Lang.PREFIX.getText() + Lang.NO_PLAYER.getText());
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("FramePicture.get")) {
                player.sendMessage(Lang.PREFIX.getText() + Lang.NO_PERMISSION.getText());
                return true;
            }
            if (Cache.hasCacheGetting(player)) {
                player.sendMessage(Lang.PREFIX.getText() + Lang.GETTING_MODE_DISABLED.getText());
                Cache.removeCacheGetting(player);
            } else {
                player.sendMessage(Lang.PREFIX.getText() + Lang.GETTING_MODE_ENABLED.getText());
                Cache.addCacheGetting(player);
            }
            return true;
        }
        if (aufgabe.equalsIgnoreCase("reload")) {
            Player player;
            if (args.length != 1) {
                return this.sendHelp(sender);
            }
            if (sender instanceof Player && !(player = (Player)sender).hasPermission("FramePicture.reload")) {
                player.sendMessage(Lang.PREFIX.getText() + Lang.NO_PERMISSION.getText());
                return true;
            }
            if (!Config.configFile.exists()) {
                Config.save();
            }
            Config.load();
            Config.save();
            this.manager.loadFrames();
            this.manager.saveFrames();
            if (Config.MONEY_ENABLED) {
                FramePicturePlugin.getPlugin().setupEconomy();
                if (FramePicturePlugin.getEconomy() == null) {
                    FramePicturePlugin.log.info("Vault not found! Money Support disabled!");
                    Config.MONEY_ENABLED = false;
                    Config.save();
                }
            }
            for (World world : Bukkit.getWorlds()) {
                this.manager.replaceTracker(world);
            }
            Lang.load();
            this.manager.getLogger().info("Plugin reloaded!");
            sender.sendMessage(Lang.PREFIX.getText() + Lang.PLUGIN_RELOAD.getText());
            return true;
        }
        return this.sendHelp(sender);
    }

    public boolean sendHelp(CommandSender sender) {
        sender.sendMessage(ChatColor.GREEN + "Help from /FramePicture or /fp:");
        sender.sendMessage("/FramePicture set <URL>  " + ChatColor.GOLD + "--" + ChatColor.WHITE + "  Set a Picture in a Frame.");
        sender.sendMessage("/FramePicture multiset <URL>  " + ChatColor.GOLD + "--" + ChatColor.WHITE + "  Create a Picture wall.");
        sender.sendMessage("/FramePicture get  " + ChatColor.GOLD + "--" + ChatColor.WHITE + "  Get the Url from a Picture");
        sender.sendMessage("/FramePicture reload  " + ChatColor.GOLD + "--" + ChatColor.WHITE + "  Reload the Config.");
        return true;
    }
}

