/*
 * Decompiled with CFR 0.152.
 */
package de.howaner.FramePicture.util;

import de.howaner.FramePicture.FramePicturePlugin;
import java.io.File;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    public static boolean CHANGE_SIZE_ENABLED = true;
    public static int SIZE_WIDTH = 128;
    public static int SIZE_HEIGHT = 128;
    public static boolean SIZE_CENTER = true;
    public static boolean MONEY_ENABLED = false;
    public static double CREATE_PRICE = 10.0;
    public static boolean WORLDGUARD_ENABLED = false;
    public static boolean WORLDGUARD_BUILD = true;
    public static boolean WORLDGUARD_BREAK = true;
    public static boolean FRAME_REMOVE_IMAGES = false;
    public static boolean FRAME_LOAD_ON_START = true;
    public static File configFile = new File("plugins/FramePicture/config.yml");

    public static void load() {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        CHANGE_SIZE_ENABLED = config.getBoolean("AutoSize.Enabled");
        SIZE_WIDTH = config.getInt("AutoSize.Width");
        SIZE_HEIGHT = config.getInt("AutoSize.Height");
        SIZE_CENTER = config.getBoolean("AutoSize.Center");
        MONEY_ENABLED = config.getBoolean("Money.Enabled");
        CREATE_PRICE = config.getDouble("Money.CreatePrice");
        WORLDGUARD_ENABLED = config.getBoolean("WorldGuard.Enabled");
        WORLDGUARD_BUILD = config.getBoolean("WorldGuard.ProtectBuild");
        WORLDGUARD_BREAK = config.getBoolean("WorldGuard.ProtectBreak");
        if (config.isBoolean("Frame.RemoveImageWhenFrameDestroy")) {
            FRAME_REMOVE_IMAGES = config.getBoolean("Frame.RemoveImageWhenFrameDestroy");
        }
        if (config.isBoolean("Frame.LoadOnStart")) {
            FRAME_LOAD_ON_START = config.getBoolean("Frame.CacheOnStart");
        }
        FramePicturePlugin.log.info("Configuration loaded!");
    }

    public static void save() {
        YamlConfiguration config = new YamlConfiguration();
        config.set("AutoSize.Enabled", (Object)CHANGE_SIZE_ENABLED);
        config.set("AutoSize.Width", (Object)SIZE_WIDTH);
        config.set("AutoSize.Height", (Object)SIZE_HEIGHT);
        config.set("AutoSize.Center", (Object)SIZE_CENTER);
        config.set("Money.Enabled", (Object)MONEY_ENABLED);
        config.set("Money.CreatePrice", (Object)CREATE_PRICE);
        config.set("WorldGuard.Enabled", (Object)WORLDGUARD_ENABLED);
        config.set("WorldGuard.ProtectBuild", (Object)WORLDGUARD_BUILD);
        config.set("WorldGuard.ProtectBreak", (Object)WORLDGUARD_BREAK);
        config.set("Frame.RemoveImageWhenFrameDestroy", (Object)FRAME_REMOVE_IMAGES);
        config.set("Frame.CacheOnStart", (Object)FRAME_LOAD_ON_START);
        try {
            config.save(configFile);
        }
        catch (Exception e) {
            FramePicturePlugin.log.log(Level.WARNING, "Error while saving the Config!");
            e.printStackTrace();
        }
    }
}

